/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.subtitleparser.webvttparser;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import org.opencastproject.subtitleparser.webvttparser.WebVTTSubtitle;
import org.opencastproject.subtitleparser.webvttparser.WebVTTSubtitleCue;
import org.opencastproject.subtitleparser.webvttparser.WebVTTSubtitleRegion;
import org.opencastproject.subtitleparser.webvttparser.WebVTTSubtitleStyle;

public class WebVTTWriter {
    private Charset charset;

    public WebVTTWriter() {
        this.charset = StandardCharsets.UTF_8;
    }

    public WebVTTWriter(Charset charset) {
        this.charset = charset;
    }

    public void write(WebVTTSubtitle subtitleObject, OutputStream os) throws IOException {
        try {
            List<String> headerLines = subtitleObject.getHeaderLines();
            for (int i = 0; i < headerLines.size(); ++i) {
                if (i == 0 && !headerLines.get(i).startsWith("WEBVTT")) {
                    os.write(("WEBVTT " + headerLines.get(i) + "\n").getBytes(this.charset));
                    continue;
                }
                os.write((headerLines.get(i) + "\n").getBytes(this.charset));
            }
            if (headerLines.size() == 0) {
                os.write("WEBVTT\n".getBytes(this.charset));
            }
            os.write("\n".getBytes(this.charset));
            for (WebVTTSubtitleRegion region : subtitleObject.getRegions()) {
                for (String regionLine : region.getLines()) {
                    os.write((regionLine + "\n").getBytes(this.charset));
                }
                os.write("\n".getBytes(this.charset));
            }
            for (WebVTTSubtitleStyle style : subtitleObject.getStyle()) {
                for (String styleLine : style.getLines()) {
                    os.write((styleLine + "\n").getBytes(this.charset));
                }
                os.write("\n".getBytes(this.charset));
            }
            for (WebVTTSubtitleCue cue : subtitleObject.getCues()) {
                if (cue.getId() != null) {
                    String number = String.format("%s\n", cue.getId());
                    os.write(number.getBytes(this.charset));
                }
                String startToEnd = String.format("%s --> %s %s\n", this.formatTimeCode(cue.getStartTime()), this.formatTimeCode(cue.getEndTime()), Optional.ofNullable(cue.getCueSettingsList()).orElse(""));
                os.write(startToEnd.getBytes(this.charset));
                String text = String.format("%s\n", cue.getText());
                os.write(text.getBytes(this.charset));
                os.write("\n".getBytes(this.charset));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new IOException("Encoding error in input subtitle");
        }
    }

    private String formatTimeCode(long ms) {
        long milliseconds = ms % 1000L;
        long seconds = ms / 1000L % 60L;
        long minutes = ms / 60000L % 60L;
        long hours = ms / 3600000L;
        return String.format("%02d:%02d:%02d.%03d", hours, minutes, seconds, milliseconds);
    }
}

