/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.statisticswriter;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.BooleanUtils;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.statistics.api.StatisticsWriter;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Write statistical data about video/audio tracks", "workflow.operation=statistics-writer"})
public class StatisticsWriterWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final String OPT_FLAVOR = "flavor";
    private static final String OPT_RETRACT = "retract";
    private static final String OPT_MEASUREMENT_NAME = "measurement-name";
    private static final String OPT_RESOURCE_ID_NAME = "organization-resource-id-name";
    private static final String OPT_RETENTION_POLICY = "retention-policy";
    private static final String OPT_TEMPORAL_RESOLUTION = "temporal-resolution";
    private static final String OPT_LENGTH_FIELD_NAME = "length-field-name";
    private StatisticsWriter statisticsWriter;
    private SecurityService securityService;

    @Reference
    public void setStatisticsWriter(StatisticsWriter statisticsWriter) {
        this.statisticsWriter = statisticsWriter;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        TimeUnit timeResolution;
        MediaPackage mediaPackage = workflowInstance.getMediaPackage();
        WorkflowOperationInstance operation = workflowInstance.getCurrentOperation();
        String flavor = operation.getConfiguration(OPT_FLAVOR);
        String measurementName = operation.getConfiguration(OPT_MEASUREMENT_NAME);
        String resourceIdName = operation.getConfiguration(OPT_RESOURCE_ID_NAME);
        String lengthFieldName = operation.getConfiguration(OPT_LENGTH_FIELD_NAME);
        String retentionPolicy = operation.getConfiguration(OPT_RETENTION_POLICY);
        String temporalResolutionStr = operation.getConfiguration(OPT_TEMPORAL_RESOLUTION);
        try {
            timeResolution = TimeUnit.valueOf(operation.getConfiguration(OPT_TEMPORAL_RESOLUTION).toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new WorkflowOperationException("invalid time unit '" + temporalResolutionStr + "'");
        }
        boolean retract = BooleanUtils.toBoolean((String)operation.getConfiguration(OPT_RETRACT));
        for (Track track : mediaPackage.getTracks(MediaPackageElementFlavor.parseFlavor((String)flavor))) {
            if (track.getDuration() == null) continue;
            Duration duration = Duration.ofMillis(track.getDuration());
            if (retract) {
                duration = duration.negated();
            }
            this.statisticsWriter.writeDuration(this.securityService.getOrganization().getId(), measurementName, retentionPolicy, resourceIdName, lengthFieldName, timeResolution, duration);
        }
        return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
    }
}

