/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.statistics.api;

import com.google.common.collect.Ordering;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import org.opencastproject.statistics.api.DataResolution;

public final class StatisticsUtil {
    private StatisticsUtil() {
    }

    public static List<Instant> getBuckets(Instant from, Instant to, DataResolution resolution, ZoneId zoneId) {
        ArrayList<Instant> result = new ArrayList<Instant>();
        LocalDateTime localStart = LocalDateTime.ofInstant(from, zoneId);
        LocalDateTime localEnd = LocalDateTime.ofInstant(to, zoneId);
        block7: while (!localStart.isAfter(localEnd)) {
            switch (resolution) {
                case MONTHLY: {
                    Instant currentMonthStart = YearMonth.of(localStart.getYear(), localStart.getMonth()).atDay(1).atStartOfDay().toInstant(ZoneOffset.UTC);
                    result.add((Instant)Ordering.natural().max((Object)from, (Object)currentMonthStart));
                    localStart = localStart.plusMonths(1L).withDayOfMonth(1).withHour(0).withMinute(0).withSecond(0).withNano(0);
                    continue block7;
                }
                case YEARLY: {
                    Instant currentYearStart = YearMonth.of(localStart.getYear(), 1).atDay(1).atStartOfDay().toInstant(ZoneOffset.UTC);
                    result.add((Instant)Ordering.natural().max((Object)from, (Object)currentYearStart));
                    localStart = localStart.plusYears(1L).withMonth(1).withDayOfMonth(1).withHour(0).withMinute(0).withSecond(0).withNano(0);
                    continue block7;
                }
                case DAILY: {
                    Instant currentDayStart = localStart.withHour(0).withMinute(0).withSecond(0).withNano(0).toInstant(ZoneOffset.UTC);
                    result.add((Instant)Ordering.natural().max((Object)from, (Object)currentDayStart));
                    localStart = localStart.plusDays(1L).withHour(0).withMinute(0).withSecond(0).withNano(0);
                    continue block7;
                }
                case WEEKLY: {
                    int daysOff = 1 - localStart.getDayOfWeek().getValue();
                    Instant currentWeekStart = localStart.plusDays(daysOff).withHour(0).withMinute(0).withSecond(0).withNano(0).toInstant(ZoneOffset.UTC);
                    result.add(currentWeekStart);
                    localStart = localStart.plusDays(7L).plusDays(daysOff).withHour(0).withMinute(0).withSecond(0).withNano(0);
                    continue block7;
                }
                case HOURLY: {
                    Instant currentHourStart = ZonedDateTime.of(localStart.withMinute(0).withSecond(0).withNano(0), zoneId).toInstant();
                    result.add((Instant)Ordering.natural().max((Object)from, (Object)currentHourStart));
                    localStart = localStart.plusHours(1L).withMinute(0).withSecond(0).withNano(0);
                    continue block7;
                }
            }
        }
        return result;
    }
}

