/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.statistics.provider.random.provider;

import java.time.Instant;
import java.time.ZoneId;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.opencastproject.statistics.api.DataResolution;
import org.opencastproject.statistics.api.ResourceType;
import org.opencastproject.statistics.api.StatisticsUtil;
import org.opencastproject.statistics.api.TimeSeries;
import org.opencastproject.statistics.api.TimeSeriesProvider;
import org.opencastproject.util.data.Collections;

public class RandomStatisticsProvider
implements TimeSeriesProvider {
    private static final Random random = new Random();
    private String id;
    private ResourceType resourceType;
    private String title;
    private String description;

    public RandomStatisticsProvider(String id, ResourceType resourceType, String title, String description) {
        this.id = id;
        this.resourceType = resourceType;
        this.title = title;
        this.description = description;
    }

    public TimeSeries getValues(String resourceId, Instant from, Instant to, DataResolution resolution, ZoneId zoneId) {
        List labels = StatisticsUtil.getBuckets((Instant)from, (Instant)to, (DataResolution)resolution, (ZoneId)zoneId).stream().map(Instant::toString).collect(Collectors.toList());
        List values = labels.stream().map(l -> random.nextInt(100)).map(Double::valueOf).collect(Collectors.toList());
        return new TimeSeries(labels, values, Double.valueOf(values.stream().mapToDouble(v -> v).sum()));
    }

    public String getId() {
        return this.id;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public Set<DataResolution> getDataResolutions() {
        return Collections.set((Object[])DataResolution.values());
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }
}

