/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.statistics.provider.random;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.fileinstall.ArtifactInstaller;
import org.opencastproject.statistics.api.StatisticsCoordinator;
import org.opencastproject.statistics.api.StatisticsProvider;
import org.opencastproject.statistics.provider.random.provider.RandomProviderConfiguration;
import org.opencastproject.statistics.provider.random.provider.RandomStatisticsProvider;
import org.opencastproject.util.ConfigurationException;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={ArtifactInstaller.class}, property={"service.description=Statistics Provider Random Service"})
public class StatisticsProviderRandomService
implements ArtifactInstaller {
    private static final Logger logger = LoggerFactory.getLogger(StatisticsProviderRandomService.class);
    private StatisticsCoordinator statisticsCoordinator;
    private Map<String, StatisticsProvider> fileNameToProvider = new ConcurrentHashMap<String, StatisticsProvider>();

    @Reference
    public void setStatisticsCoordinator(StatisticsCoordinator service) {
        this.statisticsCoordinator = service;
    }

    @Activate
    public void activate(ComponentContext cc) {
        logger.info("Activating Statistics Provider Random Service");
    }

    @Deactivate
    public void deactivate(ComponentContext cc) {
        logger.info("Deactivating Statistics Provider Random Service");
        this.fileNameToProvider.values().forEach(provider -> this.statisticsCoordinator.removeProvider(provider));
    }

    public void install(File file) throws Exception {
        String json = new String(Files.readAllBytes(file.toPath()), Charset.forName("utf-8"));
        RandomProviderConfiguration providerCfg = RandomProviderConfiguration.fromJson(json);
        if (!"timeseries".equalsIgnoreCase(providerCfg.getType())) {
            throw new ConfigurationException("Unknown random statistics type: " + providerCfg.getType());
        }
        RandomStatisticsProvider provider = new RandomStatisticsProvider(providerCfg.getId(), providerCfg.getResourceType(), providerCfg.getTitle(), providerCfg.getDescription());
        this.fileNameToProvider.put(file.getName(), (StatisticsProvider)provider);
        this.statisticsCoordinator.addProvider((StatisticsProvider)provider);
    }

    public void uninstall(File file) throws Exception {
        if (this.fileNameToProvider.containsKey(file.getName())) {
            this.statisticsCoordinator.removeProvider(this.fileNameToProvider.get(file.getName()));
            this.fileNameToProvider.remove(file.getName());
        }
    }

    public boolean canHandle(File file) {
        return "statistics".equals(file.getParentFile().getName()) && file.getName().endsWith(".json") && file.getName().toUpperCase().startsWith("random.".toUpperCase());
    }

    public void update(File file) throws Exception {
        this.uninstall(file);
        this.install(file);
    }
}

