/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.staticfiles.impl;

import com.google.common.util.concurrent.AbstractScheduledService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Service;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.management.ObjectInstance;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.staticfiles.api.StaticFileService;
import org.opencastproject.staticfiles.jmx.UploadStatistics;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.OsgiUtil;
import org.opencastproject.util.ProgressInputStream;
import org.opencastproject.util.RequireUtil;
import org.opencastproject.util.jmx.JmxUtil;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.ComponentException;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={StaticFileService.class}, property={"service.description=Static File Service", "service.PID=org.opencastproject.staticfiles.impl.StaticFileServiceImpl"})
public class StaticFileServiceImpl
implements StaticFileService {
    private static final Logger logger = LoggerFactory.getLogger(StaticFileServiceImpl.class);
    public static final String STATICFILES_ROOT_DIRECTORY_KEY = "org.opencastproject.staticfiles.rootdir";
    private UploadStatistics staticFileStatistics = new UploadStatistics();
    private ObjectInstance registerMXBean;
    private SecurityService securityService = null;
    private OrganizationDirectoryService orgDirectory = null;
    private String rootDirPath;
    private PurgeTemporaryStorageService purgeService;

    @Activate
    public void activate(ComponentContext cc) {
        logger.info("Upload Static Resource Service started.");
        this.registerMXBean = JmxUtil.registerMXBean((Object)this.staticFileStatistics, (String)"UploadStatistics");
        this.rootDirPath = OsgiUtil.getContextProperty((ComponentContext)cc, (String)STATICFILES_ROOT_DIRECTORY_KEY);
        File rootFile = new File(this.rootDirPath);
        if (!rootFile.exists()) {
            try {
                FileUtils.forceMkdir((File)rootFile);
            }
            catch (IOException e) {
                throw new ComponentException(String.format("%s does not exists and could not be created", rootFile.getAbsolutePath()));
            }
        }
        if (!rootFile.canRead()) {
            throw new ComponentException(String.format("Cannot read from %s", rootFile.getAbsolutePath()));
        }
        this.purgeService = new PurgeTemporaryStorageService();
        this.purgeService.addListener(new Service.Listener(this){

            public void failed(Service.State from, Throwable failure) {
                logger.warn("Temporary storage purging service failed:", failure);
            }
        }, MoreExecutors.directExecutor());
        this.purgeService.startAsync();
        logger.info("Purging of temporary storage section scheduled");
    }

    @Deactivate
    public void deactivate() {
        JmxUtil.unregisterMXBean((ObjectInstance)this.registerMXBean);
        this.purgeService.stopAsync();
        this.purgeService = null;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    public void setOrganizationDirectoryService(OrganizationDirectoryService directoryService) {
        this.orgDirectory = directoryService;
    }

    public String storeFile(String filename, InputStream inputStream) throws IOException {
        RequireUtil.notNull((Object)filename, (String)"filename");
        RequireUtil.notNull((Object)inputStream, (String)"inputStream");
        String uuid = UUID.randomUUID().toString();
        String org = this.securityService.getOrganization().getId();
        Path file = this.getTemporaryStorageDir(org).resolve(Paths.get(uuid, filename));
        try (ProgressInputStream progressInputStream = new ProgressInputStream(inputStream);){
            progressInputStream.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    long totalNumBytesRead = (Long)evt.getNewValue();
                    long oldTotalNumBytesRead = (Long)evt.getOldValue();
                    StaticFileServiceImpl.this.staticFileStatistics.add(totalNumBytesRead - oldTotalNumBytesRead);
                }
            });
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            Files.copy((InputStream)progressInputStream, file, new CopyOption[0]);
        }
        catch (IOException e) {
            logger.error("Unable to save file '{}' to {}", new Object[]{filename, file, e});
            throw e;
        }
        return uuid;
    }

    public InputStream getFile(String uuid) throws NotFoundException, IOException {
        if (StringUtils.isBlank((CharSequence)uuid)) {
            throw new IllegalArgumentException("The uuid must not be blank");
        }
        String org = this.securityService.getOrganization().getId();
        return Files.newInputStream(this.getFile(org, uuid), new OpenOption[0]);
    }

    public void persistFile(String uuid) throws NotFoundException, IOException {
        String org = this.securityService.getOrganization().getId();
        try (DirectoryStream<Path> folders = Files.newDirectoryStream(this.getTemporaryStorageDir(org), StaticFileServiceImpl.getDirsEqualsUuidFilter(uuid));){
            for (Path folder : folders) {
                Files.move(folder, this.getDurableStorageDir(org).resolve(folder.getFileName()), new CopyOption[0]);
            }
        }
    }

    public void deleteFile(String uuid) throws NotFoundException, IOException {
        String org = this.securityService.getOrganization().getId();
        Path file = this.getFile(org, uuid);
        Files.deleteIfExists(file);
    }

    public String getFileName(String uuid) throws NotFoundException {
        String org = this.securityService.getOrganization().getId();
        try {
            Path file = this.getFile(org, uuid);
            return file.getFileName().toString();
        }
        catch (IOException e) {
            logger.warn("Error while reading file:", (Throwable)e);
            throw new NotFoundException((Throwable)e);
        }
    }

    public Long getContentLength(String uuid) throws NotFoundException {
        String org = this.securityService.getOrganization().getId();
        try {
            Path file = this.getFile(org, uuid);
            return Files.size(file);
        }
        catch (IOException e) {
            logger.warn("Error while reading file:", (Throwable)e);
            throw new NotFoundException((Throwable)e);
        }
    }

    private static DirectoryStream.Filter<Path> getDirsEqualsUuidFilter(final String uuid) {
        return new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path entry) throws IOException {
                return Files.isDirectory(entry, new LinkOption[0]) && entry.getFileName().toString().equals(uuid);
            }
        };
    }

    private Path getTemporaryStorageDir(String org) {
        return Paths.get(this.rootDirPath, org, "temp");
    }

    private Path getDurableStorageDir(String org) {
        return Paths.get(this.rootDirPath, org);
    }

    private Path getFile(String org, String uuid) throws NotFoundException, IOException {
        Iterator<Path> iterator;
        DirectoryStream<Path> files;
        try (DirectoryStream<Path> dirs = Files.newDirectoryStream(this.getDurableStorageDir(org), StaticFileServiceImpl.getDirsEqualsUuidFilter(uuid));){
            for (Path dir : dirs) {
                files = Files.newDirectoryStream(dir);
                try {
                    Path file;
                    iterator = files.iterator();
                    if (!iterator.hasNext()) continue;
                    Path path = file = iterator.next();
                    return path;
                }
                finally {
                    if (files == null) continue;
                    files.close();
                }
            }
        }
        dirs = Files.newDirectoryStream(this.getTemporaryStorageDir(org), StaticFileServiceImpl.getDirsEqualsUuidFilter(uuid));
        try {
            for (Path dir : dirs) {
                files = Files.newDirectoryStream(dir);
                try {
                    Path file;
                    iterator = files.iterator();
                    if (!iterator.hasNext()) continue;
                    Path path = file = iterator.next();
                    return path;
                }
                finally {
                    if (files == null) continue;
                    files.close();
                }
            }
        }
        finally {
            if (dirs != null) {
                dirs.close();
            }
        }
        throw new NotFoundException(String.format("No file with UUID '%s' found.", uuid));
    }

    void purgeTemporaryStorageSection(String org, final long lifetime) throws IOException {
        logger.debug("Purge temporary storage section of organization '{}'", (Object)org);
        Path temporaryStorageDir = this.getTemporaryStorageDir(org);
        if (Files.exists(temporaryStorageDir, new LinkOption[0])) {
            try (DirectoryStream<Path> tempFilesStream = Files.newDirectoryStream(temporaryStorageDir, (DirectoryStream.Filter<? super Path>)new DirectoryStream.Filter<Path>(){

                @Override
                public boolean accept(Path path) throws IOException {
                    return Files.getLastModifiedTime(path, new LinkOption[0]).toMillis() < new Date().getTime() - lifetime;
                }
            });){
                for (Path file : tempFilesStream) {
                    FileUtils.deleteQuietly((File)file.toFile());
                }
            }
        }
    }

    void purgeTemporaryStorageSection() throws IOException {
        logger.info("Start purging temporary storage section of all known organizations");
        for (Organization org : this.orgDirectory.getOrganizations()) {
            this.purgeTemporaryStorageSection(org.getId(), TimeUnit.DAYS.toMillis(1L));
        }
    }

    private class PurgeTemporaryStorageService
    extends AbstractScheduledService {
        private PurgeTemporaryStorageService() {
        }

        protected void runOneIteration() throws Exception {
            StaticFileServiceImpl.this.purgeTemporaryStorageSection();
        }

        protected AbstractScheduledService.Scheduler scheduler() {
            return AbstractScheduledService.Scheduler.newFixedRateSchedule((long)0L, (long)1L, (TimeUnit)TimeUnit.HOURS);
        }
    }
}

