/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.staticfiles.endpoint;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Dictionary;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.staticfiles.api.StaticFileService;
import org.opencastproject.util.MimeTypes;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.OsgiUtil;
import org.opencastproject.util.ProgressInputStream;
import org.opencastproject.util.RestUtil;
import org.opencastproject.util.UrlSupport;
import org.opencastproject.util.data.Option;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/staticfiles")
@RestService(name="StaticResourceService", title="Static Resources Service", abstractText="This service allows the uploading of static resources such as videos and images.", notes={"All paths above are relative to the REST endpoint base (something like http://your.server/files)", "If the service is down or not working it will return a status 503, this means the the underlying service is not working and is either restarting or has failed", "A status code 500 means a general failure has occurred which is not recoverable and was not anticipated. In other words, there is a bug! You should file an error report with your server logs from the time when the error occurred: <a href=\"https://github.com/opencast/opencast/issues\">Opencast Issue Tracker</a>"})
@Component(immediate=true, service={StaticFileRestService.class}, property={"service.description=Static File Service REST Endpoint", "opencast.service.type=org.opencastproject.staticfiles", "opencast.service.path=/staticfiles", "opencast.service.jobproducer=false"})
@JaxrsResource
public class StaticFileRestService {
    private static final Logger logger = LoggerFactory.getLogger(StaticFileRestService.class);
    public static final String STATICFILES_URL_PATH = "staticfiles";
    public static final String STATICFILES_WEBSERVER_ENABLED_KEY = "org.opencastproject.staticfiles.webserver.enabled";
    public static final String STATICFILES_WEBSERVER_URL_KEY = "org.opencastproject.staticfiles.webserver.url";
    public static final String STATICFILES_UPLOAD_MAX_SIZE_KEY = "org.opencastproject.staticfiles.upload.max.size";
    private SecurityService securityService = null;
    private StaticFileService staticFileService;
    private String serverUrl;
    private Option<String> webserverURL = Option.none();
    private long maxUploadSize = 1000000000L;
    protected boolean useWebserver = false;

    @Reference
    public void setStaticFileService(StaticFileService staticFileService) {
        this.staticFileService = staticFileService;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public void activate(ComponentContext cc) throws ConfigurationException {
        logger.info("Static File REST Service started.");
        this.serverUrl = OsgiUtil.getContextProperty((ComponentContext)cc, (String)"org.opencastproject.server.url");
        this.useWebserver = BooleanUtils.toBoolean((String)((String)OsgiUtil.getOptCfg((Dictionary)cc.getProperties(), (String)STATICFILES_WEBSERVER_ENABLED_KEY).getOrElse((Object)"false")));
        this.webserverURL = OsgiUtil.getOptCfg((Dictionary)cc.getProperties(), (String)STATICFILES_WEBSERVER_URL_KEY);
        Option cfgMaxUploadSize = OsgiUtil.getOptContextProperty((ComponentContext)cc, (String)STATICFILES_UPLOAD_MAX_SIZE_KEY);
        if (cfgMaxUploadSize.isSome()) {
            this.maxUploadSize = Long.parseLong((String)cfgMaxUploadSize.get());
        }
    }

    @GET
    @Path(value="{uuid}")
    @RestQuery(name="getStaticFile", description="Returns a static file resource", pathParameters={@RestParameter(name="uuid", description="Static File Universal Unique Id", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="Returns a static file resource", responseCode=200), @RestResponse(description="No file by the given uuid found", responseCode=404)}, returnDescription="")
    public Response getStaticFile(@PathParam(value="uuid") String uuid) throws NotFoundException {
        try {
            InputStream file = this.staticFileService.getFile(uuid);
            String filename = this.staticFileService.getFileName(uuid);
            Long length = this.staticFileService.getContentLength(uuid);
            return RestUtil.R.ok((InputStream)file, this.getMimeType(filename), (Option)Option.some((Object)length), (Option)Option.some((Object)filename));
        }
        catch (IOException | NotFoundException e) {
            return RestUtil.R.notFound();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/plain"})
    @Path(value="")
    @RestQuery(name="postStaticFile", description="Post a new static resource", bodyParameter=@RestParameter(description="The static resource file", isRequired=true, name="BODY", type=RestParameter.Type.FILE), responses={@RestResponse(description="Returns the id of the uploaded static resource", responseCode=201), @RestResponse(description="No filename or file to upload found", responseCode=400), @RestResponse(description="The upload size is too big", responseCode=400)}, returnDescription="")
    public Response postStaticFile(@Context HttpServletRequest request) {
        if (this.maxUploadSize > 0L && (long)request.getContentLength() > this.maxUploadSize) {
            logger.warn("Preventing upload of static file as its size {} is larger than the max size allowed {}", (Object)request.getContentLength(), (Object)this.maxUploadSize);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        ProgressInputStream inputStream = null;
        try {
            FileItemIterator iter;
            String filename = null;
            if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
                boolean isDone = false;
                iter = new ServletFileUpload().getItemIterator(request);
                while (iter.hasNext()) {
                    FileItemStream item = iter.next();
                    if (item.isFormField()) continue;
                    logger.debug("Processing file item");
                    filename = item.getName();
                    inputStream = new ProgressInputStream(item.openStream());
                    inputStream.addPropertyChangeListener(new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent evt) {
                            long totalNumBytesRead = (Long)evt.getNewValue();
                            if (totalNumBytesRead > StaticFileRestService.this.maxUploadSize) {
                                logger.warn("Upload limit of {} bytes reached, returning a bad request.", (Object)StaticFileRestService.this.maxUploadSize);
                                throw new WebApplicationException(Response.Status.BAD_REQUEST);
                            }
                        }
                    });
                    isDone = true;
                    if (!isDone) continue;
                    break;
                }
            } else {
                logger.warn("Request is not multi part request, returning a bad request.");
                Response isDone = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                return isDone;
            }
            if (filename == null) {
                logger.warn("Request was missing the filename, returning a bad request.");
                Response isDone = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                return isDone;
            }
            if (inputStream == null) {
                logger.warn("Request was missing the file, returning a bad request.");
                Response isDone = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                return isDone;
            }
            String uuid = this.staticFileService.storeFile(filename, (InputStream)inputStream);
            try {
                iter = Response.created((URI)this.getStaticFileURL(uuid)).entity((Object)uuid).build();
            }
            catch (NotFoundException e) {
                Response response;
                try {
                    logger.error("Previous stored file with uuid {} couldn't beren found:", (Object)uuid, (Object)e);
                    response = Response.serverError().build();
                }
                catch (WebApplicationException e2) {
                    Response response2 = e2.getResponse();
                    return response2;
                }
                catch (Exception e3) {
                    logger.error("Unable to store file", (Throwable)e3);
                    Response response3 = Response.serverError().build();
                    return response3;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)inputStream);
                return response;
            }
            IOUtils.closeQuietly((InputStream)inputStream);
            return iter;
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
    }

    @POST
    @Path(value="{uuid}/persist")
    @RestQuery(name="persistFile", description="Persists a recently uploaded file to the permanent storage", pathParameters={@RestParameter(description="File UUID", isRequired=true, name="uuid", type=RestParameter.Type.STRING)}, responses={@RestResponse(description="The file has been persisted", responseCode=200), @RestResponse(description="No file by the given UUID found", responseCode=404)}, returnDescription="")
    public Response persistFile(@PathParam(value="uuid") String uuid) throws NotFoundException {
        try {
            this.staticFileService.persistFile(uuid);
            return RestUtil.R.ok();
        }
        catch (IOException e) {
            logger.error("Unable to persist file '{}':", (Object)uuid, (Object)e);
            return RestUtil.R.serverError();
        }
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="{uuid}/url")
    @RestQuery(name="getStaticFileUrl", description="Returns a static file resource's URL", pathParameters={@RestParameter(name="uuid", description="Static File Universal Unique Id", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(description="Returns a static file resource's URL", responseCode=200), @RestResponse(description="No file by the given uuid found", responseCode=404)}, returnDescription="")
    public Response getStaticFileUrl(@PathParam(value="uuid") String uuid) throws NotFoundException {
        try {
            return Response.ok((Object)this.getStaticFileURL(uuid).toString()).build();
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Unable to retrieve static file URL from {}", (Object)uuid, (Object)e);
            return Response.serverError().build();
        }
    }

    @DELETE
    @Path(value="{uuid}")
    @RestQuery(name="deleteStaticFile", description="Remove the static file", returnDescription="No content", pathParameters={@RestParameter(name="uuid", description="Static File Universal Unique Id", isRequired=true, type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=204, description="File deleted"), @RestResponse(responseCode=404, description="No file by the given uuid found")})
    public Response deleteStaticFile(@PathParam(value="uuid") String uuid) throws NotFoundException {
        try {
            this.staticFileService.deleteFile(uuid);
            return Response.noContent().build();
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Unable to delete static file {}", (Object)uuid, (Object)e);
            return Response.serverError().build();
        }
    }

    public URI getStaticFileURL(String uuid) throws NotFoundException {
        if (this.useWebserver && this.webserverURL.isSome()) {
            return URI.create(UrlSupport.concat((String[])new String[]{(String)this.webserverURL.get(), this.securityService.getOrganization().getId(), uuid, this.staticFileService.getFileName(uuid)}));
        }
        return URI.create(UrlSupport.concat((String[])new String[]{this.serverUrl, STATICFILES_URL_PATH, uuid}));
    }

    private Option<String> getMimeType(String filename) {
        Option mimeType;
        try {
            mimeType = Option.some((Object)MimeTypes.fromString((String)filename).toString());
        }
        catch (Exception e) {
            logger.warn("Unable to detect the mime type of file {}", (Object)filename);
            mimeType = Option.none();
        }
        return mimeType;
    }
}

