/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.speechtotext;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.inspection.api.MediaInspectionService;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.MediaPackageElements;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.mediapackage.attachment.AttachmentImpl;
import org.opencastproject.mediapackage.selector.TrackSelector;
import org.opencastproject.mediapackage.track.TrackImpl;
import org.opencastproject.metadata.api.MediaPackageMetadata;
import org.opencastproject.metadata.dublincore.DublinCoreCatalogService;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.speechtotext.api.SpeechToTextService;
import org.opencastproject.speechtotext.api.SpeechToTextServiceException;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.ConfiguredTagsAndFlavors;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Speech-to-Text Workflow Operation Handler", "workflow.operation=speechtotext"})
public class SpeechToTextWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(SpeechToTextWorkflowOperationHandler.class);
    private static final String LANGUAGE_CODE = "language-code";
    private static final String LANGUAGE_FALLBACK = "language-fallback";
    private static final String TARGET_ELEMENT = "target-element";
    private static final String PLACEHOLDER_LANG = "#{lang}";
    private static final String TRANSLATE_MODE = "translate";
    private static final String TRACK_SELECTION_STRATEGY = "track-selection-strategy";
    private static final String LIMIT_TO_ONE = "limit-to-one";
    private static final String ASYNCHRONOUS = "async";
    private static final String JOBS_WORKFLOW_CONFIGURATION = "speech-to-text-jobs";
    private SpeechToTextService speechToTextService = null;
    private Workspace workspace;
    private MediaInspectionService mediaInspectionService;
    private DublinCoreCatalogService dublinCoreCatalogService;

    @Activate
    public void activate(ComponentContext cc) {
        super.activate(cc);
        logger.info("Registering speech-to-text workflow operation handler");
    }

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        MediaPackage mediaPackage = workflowInstance.getMediaPackage();
        logger.info("Start speech-to-text workflow operation for media package {}", (Object)mediaPackage);
        boolean async = BooleanUtils.toBoolean((String)workflowInstance.getCurrentOperation().getConfiguration(ASYNCHRONOUS));
        ConfiguredTagsAndFlavors tagsAndFlavors = this.getTagsAndFlavors(workflowInstance, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.one, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.one);
        MediaPackageElementFlavor sourceFlavor = tagsAndFlavors.getSingleSrcFlavor();
        List srcTags = tagsAndFlavors.getSrcTags();
        TrackSelector trackSelector = new TrackSelector();
        trackSelector.addFlavor(sourceFlavor);
        for (String tag : srcTags) {
            trackSelector.addTag(tag);
        }
        Collection tracks = trackSelector.select(mediaPackage, true);
        if (tracks.isEmpty()) {
            throw new WorkflowOperationException(String.format("No tracks with source flavor '%s' found for transcription", sourceFlavor));
        }
        logger.info("Found {} track(s) with source flavor '{}'.", (Object)tracks.size(), (Object)sourceFlavor);
        String languageCode = this.getMediaPackageLanguage(mediaPackage, workflowInstance);
        AppendSubtitleAs appendSubtitleAs = this.howToAppendTheSubtitles(workflowInstance);
        Boolean translate = this.getTranslationMode(workflowInstance);
        List<Track> tracksWithAudio = tracks.stream().filter(Track::hasAudio).collect(Collectors.toList());
        TrackSelectionStrategy trackSelectionStrategy = this.getTrackSelectionStrategy(mediaPackage, workflowInstance);
        List<Track> tracksToTranscribe = this.filterTracksByStrategy(tracksWithAudio, trackSelectionStrategy);
        if (tracksToTranscribe.isEmpty()) {
            logger.info("No subtitles were created for media package {}. Workflow Configuration 'track-selection-strategy' is set to {}", (Object)mediaPackage, (Object)trackSelectionStrategy);
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.SKIP);
        }
        boolean limitToOne = BooleanUtils.toBoolean((String)workflowInstance.getCurrentOperation().getConfiguration(LIMIT_TO_ONE));
        if (limitToOne) {
            tracksToTranscribe = List.of(tracksToTranscribe.get(0));
        }
        if (async) {
            this.createSubtitleAsync(workflowInstance, tracksToTranscribe, languageCode, translate);
        } else {
            for (Track track : tracksToTranscribe) {
                this.createSubtitle(track, languageCode, mediaPackage, tagsAndFlavors, appendSubtitleAs, translate);
            }
        }
        logger.info("Speech-To-Text workflow operation for media package {} completed", (Object)mediaPackage);
        return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
    }

    private List<Track> filterTracksByStrategy(List<Track> tracksWithAudio, TrackSelectionStrategy trackSelectionStrategy) {
        ArrayList<Track> tracksToTranscribe = new ArrayList<Track>();
        if (!tracksWithAudio.isEmpty()) {
            String presenterTypeConstant = MediaPackageElements.PRESENTER_SOURCE.getType();
            String presentationTypeConstant = MediaPackageElements.PRESENTATION_SOURCE.getType();
            List presenterTracksWithAudio = tracksWithAudio.stream().filter(track -> Objects.equals(track.getFlavor().getType(), presenterTypeConstant)).collect(Collectors.toList());
            List presentationTracksWithAudio = tracksWithAudio.stream().filter(track -> Objects.equals(track.getFlavor().getType(), presentationTypeConstant)).collect(Collectors.toList());
            if (TrackSelectionStrategy.PRESENTER_OR_NOTHING.equals((Object)trackSelectionStrategy)) {
                tracksToTranscribe.addAll(presenterTracksWithAudio);
            }
            if (TrackSelectionStrategy.PRESENTATION_OR_NOTHING.equals((Object)trackSelectionStrategy)) {
                tracksToTranscribe.addAll(presentationTracksWithAudio);
            }
            if (TrackSelectionStrategy.TRY_PRESENTER_FIRST.equals((Object)trackSelectionStrategy)) {
                tracksToTranscribe.addAll(presenterTracksWithAudio);
                if (tracksToTranscribe.isEmpty()) {
                    tracksToTranscribe.addAll(tracksWithAudio);
                }
            }
            if (TrackSelectionStrategy.TRY_PRESENTATION_FIRST.equals((Object)trackSelectionStrategy)) {
                tracksToTranscribe.addAll(presentationTracksWithAudio);
                if (tracksToTranscribe.isEmpty()) {
                    tracksToTranscribe.addAll(tracksWithAudio);
                }
            }
            if (TrackSelectionStrategy.EVERYTHING.equals((Object)trackSelectionStrategy)) {
                tracksToTranscribe.addAll(tracksWithAudio);
            }
        }
        return tracksToTranscribe;
    }

    private void createSubtitle(Track track, String languageCode, MediaPackage parentMediaPackage, ConfiguredTagsAndFlavors tagsAndFlavors, AppendSubtitleAs appendSubtitleAs, Boolean translate) throws WorkflowOperationException {
        Job job;
        URI trackURI = track.getURI();
        logger.info("Generating subtitle for '{}'...", (Object)trackURI);
        try {
            job = this.speechToTextService.transcribe(trackURI, languageCode, translate);
        }
        catch (SpeechToTextServiceException e) {
            throw new WorkflowOperationException(String.format("Generating subtitles for '%s' in media package '%s' failed", trackURI, parentMediaPackage), (Throwable)e);
        }
        if (!this.waitForStatus(new Job[]{job}).isSuccess()) {
            throw new WorkflowOperationException(String.format("Speech-to-Text job for media package '%s' failed", parentMediaPackage));
        }
        try {
            String[] jobOutput = job.getPayload().split(",");
            URI output = new URI(jobOutput[0]);
            String outputLanguage = jobOutput[1];
            String engineType = jobOutput[2];
            String mediaPackageIdentifier = UUID.randomUUID().toString();
            AttachmentImpl subtitleMediaPackageElement = switch (appendSubtitleAs.ordinal()) {
                case 0 -> new AttachmentImpl();
                default -> new TrackImpl();
            };
            subtitleMediaPackageElement.setIdentifier(mediaPackageIdentifier);
            try (InputStream in = this.workspace.read(output);){
                URI uri = this.workspace.put(parentMediaPackage.getIdentifier().toString(), mediaPackageIdentifier, FilenameUtils.getName((String)output.getPath()), in);
                subtitleMediaPackageElement.setURI(uri);
            }
            MediaPackageElementFlavor targetFlavor = tagsAndFlavors.getSingleTargetFlavor().applyTo(track.getFlavor());
            subtitleMediaPackageElement.setFlavor(targetFlavor);
            List targetTags = tagsAndFlavors.getTargetTags();
            targetTags.add("lang:" + outputLanguage);
            targetTags.add("generator-type:auto");
            targetTags.add("generator:" + engineType.toLowerCase());
            Job inspection = this.mediaInspectionService.enrich((MediaPackageElement)subtitleMediaPackageElement, true);
            if (!this.waitForStatus(new Job[]{inspection}).isSuccess()) {
                throw new SpeechToTextServiceException(String.format("Transcription for '%s' failed at enriching process", trackURI));
            }
            subtitleMediaPackageElement = MediaPackageElementParser.getFromXml((String)inspection.getPayload());
            for (String tag : targetTags) {
                subtitleMediaPackageElement.addTag(tag);
            }
            parentMediaPackage.add((MediaPackageElement)subtitleMediaPackageElement);
            this.workspace.delete(output);
        }
        catch (Exception e) {
            throw new WorkflowOperationException("Error handling text-to-speech service output", (Throwable)e);
        }
        try {
            this.workspace.cleanup(parentMediaPackage.getIdentifier());
        }
        catch (IOException e) {
            throw new WorkflowOperationException((Throwable)e);
        }
    }

    private void createSubtitleAsync(WorkflowInstance workflow, List<Track> tracks, String languageCode, Boolean translate) throws WorkflowOperationException {
        logger.info("Asynchronously generating subtitles");
        StringBuilder jobs = new StringBuilder();
        try {
            for (Track track : tracks) {
                Job job = this.speechToTextService.transcribe(track.getURI(), languageCode, translate);
                jobs.append(",").append(job.getId());
            }
        }
        catch (SpeechToTextServiceException e) {
            throw new WorkflowOperationException(String.format("Starting subtitle job in media package '%s' failed", workflow.getMediaPackage().getIdentifier()), (Throwable)e);
        }
        String config = Objects.toString(workflow.getConfiguration(JOBS_WORKFLOW_CONFIGURATION), "") + String.valueOf(jobs);
        workflow.setConfiguration(JOBS_WORKFLOW_CONFIGURATION, config.replaceFirst("^,", ""));
    }

    private TrackSelectionStrategy getTrackSelectionStrategy(MediaPackage mediaPackage, WorkflowInstance workflowInstance) throws WorkflowOperationException {
        WorkflowOperationInstance operation = workflowInstance.getCurrentOperation();
        String strategyCfg = StringUtils.trimToEmpty((String)operation.getConfiguration(TRACK_SELECTION_STRATEGY)).toLowerCase();
        if (strategyCfg.isEmpty()) {
            return TrackSelectionStrategy.EVERYTHING;
        }
        try {
            return TrackSelectionStrategy.fromString(strategyCfg);
        }
        catch (IllegalArgumentException e) {
            throw new WorkflowOperationException(String.format("Speech-to-Text job for media package '%s' failed, because of wrong workflow configuration. track-selection-strategy of type '%s' does not exist.", mediaPackage, strategyCfg));
        }
    }

    private AppendSubtitleAs howToAppendTheSubtitles(WorkflowInstance workflowInstance) throws WorkflowOperationException {
        WorkflowOperationInstance operation = workflowInstance.getCurrentOperation();
        String targetElement = StringUtils.trimToEmpty((String)operation.getConfiguration(TARGET_ELEMENT)).toLowerCase();
        if (targetElement.isEmpty()) {
            return AppendSubtitleAs.track;
        }
        try {
            return AppendSubtitleAs.valueOf(targetElement);
        }
        catch (IllegalArgumentException e) {
            throw new WorkflowOperationException(String.format("Speech-to-Text job for media package '%s' failed, because of wrong workflow configuration. target-element of type '%s' does not exist.", workflowInstance.getMediaPackage(), targetElement));
        }
    }

    private Boolean getTranslationMode(WorkflowInstance workflowInstance) {
        WorkflowOperationInstance operation = workflowInstance.getCurrentOperation();
        return BooleanUtils.toBoolean((String)StringUtils.trimToEmpty((String)operation.getConfiguration(TRANSLATE_MODE)));
    }

    private String getMediaPackageLanguage(MediaPackage mediaPackage, WorkflowInstance workflowInstance) {
        WorkflowOperationInstance operation = workflowInstance.getCurrentOperation();
        String language = StringUtils.trimToEmpty((String)operation.getConfiguration(LANGUAGE_CODE));
        if (language.isEmpty()) {
            MediaPackageMetadata dublinCoreMetadata = this.dublinCoreCatalogService.getMetadata(mediaPackage);
            language = StringUtils.trimToEmpty((String)dublinCoreMetadata.getLanguage());
        }
        if (language.isEmpty()) {
            language = StringUtils.trimToEmpty((String)mediaPackage.getLanguage());
        }
        if (language.isEmpty()) {
            language = Objects.toString(operation.getConfiguration(LANGUAGE_FALLBACK), "");
        }
        return language;
    }

    @Reference
    public void setSpeechToTextService(SpeechToTextService speechToTextService) {
        this.speechToTextService = speechToTextService;
    }

    @Reference
    public void setMediaInspectionService(MediaInspectionService mediaInspectionService) {
        this.mediaInspectionService = mediaInspectionService;
    }

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Reference
    public void setDublinCoreCatalogService(DublinCoreCatalogService dublinCoreCatalogService) {
        this.dublinCoreCatalogService = dublinCoreCatalogService;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    private static enum AppendSubtitleAs {
        attachment,
        track;

    }

    private static enum TrackSelectionStrategy {
        PRESENTER_OR_NOTHING,
        PRESENTATION_OR_NOTHING,
        TRY_PRESENTER_FIRST,
        TRY_PRESENTATION_FIRST,
        EVERYTHING;


        private static TrackSelectionStrategy fromString(String value) {
            for (TrackSelectionStrategy strategy : TrackSelectionStrategy.values()) {
                if (!strategy.name().equalsIgnoreCase(value)) continue;
                return strategy;
            }
            throw new IllegalArgumentException("No TrackSelectionStrategy enum constant " + TrackSelectionStrategy.class.getCanonicalName() + "." + value);
        }
    }
}

