/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.speechtotext;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.inspection.api.MediaInspectionService;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.attachment.AttachmentImpl;
import org.opencastproject.mediapackage.track.TrackImpl;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.serviceregistry.api.ServiceRegistryException;
import org.opencastproject.speechtotext.api.SpeechToTextServiceException;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.ConfiguredTagsAndFlavors;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Speech-to-Text Attach Workflow Operation Handler", "workflow.operation=speechtotext-attach"})
public class SpeechToTextAttachWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final Logger logger = LoggerFactory.getLogger(SpeechToTextAttachWorkflowOperationHandler.class);
    private static final String TARGET_ELEMENT = "target-element";
    private static final String JOBS_WORKFLOW_CONFIGURATION = "speech-to-text-jobs";
    private Workspace workspace;
    private MediaInspectionService mediaInspectionService;

    @Activate
    public void activate(ComponentContext cc) {
        super.activate(cc);
        logger.info("Registering speechtotext-attach workflow operation handler");
    }

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        MediaPackage mediaPackage = workflowInstance.getMediaPackage();
        logger.info("Start speechtotext-attach workflow operation for media package {}", (Object)mediaPackage);
        AppendSubtitleAs appendSubtitleAs = this.howToAppendTheSubtitles(workflowInstance);
        String jobIds = Objects.toString(workflowInstance.getConfiguration(JOBS_WORKFLOW_CONFIGURATION), "");
        if (jobIds.isEmpty()) {
            logger.info("No speechtotext jobs to attach. Skipping.");
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.SKIP);
        }
        for (String jobId : jobIds.split(",")) {
            ConfiguredTagsAndFlavors tagsAndFlavors = this.getTagsAndFlavors(workflowInstance, AbstractWorkflowOperationHandler.Configuration.none, AbstractWorkflowOperationHandler.Configuration.none, AbstractWorkflowOperationHandler.Configuration.many, AbstractWorkflowOperationHandler.Configuration.one);
            this.attachSubtitle(Long.parseLong(jobId), mediaPackage, tagsAndFlavors, appendSubtitleAs);
        }
        workflowInstance.getConfigurations().remove(JOBS_WORKFLOW_CONFIGURATION);
        logger.info("Speech-To-Text workflow operation for media package {} completed", (Object)mediaPackage);
        return this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
    }

    private void attachSubtitle(long jobId, MediaPackage mediaPackage, ConfiguredTagsAndFlavors tagsAndFlavors, AppendSubtitleAs appendSubtitleAs) throws WorkflowOperationException {
        Job job;
        logger.info("Attaching subtitle from job '{}' to media package {}", (Object)jobId, (Object)mediaPackage);
        try {
            job = this.serviceRegistry.getJob(jobId);
        }
        catch (ServiceRegistryException | NotFoundException e) {
            throw new WorkflowOperationException(String.format("Could not find speechtotext job %s", jobId), e);
        }
        if (!"speechtotext".equals(job.getOperation())) {
            throw new WorkflowOperationException(String.format("Job %s is on type %s. Expected `speechtotext`", jobId, job.getOperation()));
        }
        if (!this.waitForStatus(new Job[]{job}).isSuccess()) {
            throw new WorkflowOperationException(String.format("Speechtotext job for media package '%s' failed", mediaPackage));
        }
        try {
            String[] jobOutput = job.getPayload().split(",");
            URI output = new URI(jobOutput[0]);
            String outputLanguage = jobOutput[1];
            String engineType = jobOutput[2];
            AttachmentImpl subtitleElement = appendSubtitleAs == AppendSubtitleAs.attachment ? new AttachmentImpl() : new TrackImpl();
            String elementId = subtitleElement.generateIdentifier();
            try (InputStream in = this.workspace.read(output);){
                URI uri = this.workspace.put(mediaPackage.getIdentifier().toString(), elementId, FilenameUtils.getName((String)output.getPath()), in);
                subtitleElement.setURI(uri);
            }
            subtitleElement.setFlavor(tagsAndFlavors.getSingleTargetFlavor());
            List targetTags = tagsAndFlavors.getTargetTags();
            targetTags.add("lang:" + outputLanguage);
            targetTags.add("generator-type:auto");
            targetTags.add("generator:" + engineType.toLowerCase());
            for (String tag : targetTags) {
                subtitleElement.addTag(tag);
            }
            Job inspection = this.mediaInspectionService.enrich((MediaPackageElement)subtitleElement, true);
            if (!this.waitForStatus(new Job[]{inspection}).isSuccess()) {
                throw new SpeechToTextServiceException(String.format("Transcription for '%s' failed at enriching process", mediaPackage));
            }
            mediaPackage.add(MediaPackageElementParser.getFromXml((String)inspection.getPayload()));
            this.workspace.delete(output);
        }
        catch (Exception e) {
            throw new WorkflowOperationException("Error handling text-to-speech service output", (Throwable)e);
        }
        try {
            this.workspace.cleanup(mediaPackage.getIdentifier());
        }
        catch (IOException e) {
            throw new WorkflowOperationException((Throwable)e);
        }
    }

    private AppendSubtitleAs howToAppendTheSubtitles(WorkflowInstance workflowInstance) throws WorkflowOperationException {
        WorkflowOperationInstance operation = workflowInstance.getCurrentOperation();
        String targetElement = StringUtils.trimToEmpty((String)operation.getConfiguration(TARGET_ELEMENT)).toLowerCase();
        if (targetElement.isEmpty()) {
            return AppendSubtitleAs.track;
        }
        try {
            return AppendSubtitleAs.valueOf(targetElement);
        }
        catch (IllegalArgumentException e) {
            throw new WorkflowOperationException(String.format("Speech-to-Text job for media package '%s' failed, because of wrong workflow configuration. target-element of type '%s' does not exist.", workflowInstance.getMediaPackage(), targetElement));
        }
    }

    @Reference
    public void setMediaInspectionService(MediaInspectionService mediaInspectionService) {
        this.mediaInspectionService = mediaInspectionService;
    }

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    private static enum AppendSubtitleAs {
        attachment,
        track;

    }
}

