/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.speechtotext.util;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class LangCodeUtil {
    private static final Map<String, String> iso3ToIso2Map = new HashMap<String, String>();
    private static final Map<String, String> langNameToIso2Map = new HashMap<String, String>();

    private LangCodeUtil() {
        throw new UnsupportedOperationException("Utility class should not have a public or default constructor");
    }

    public static String iso3ToIso2(String langIso3Code, String defaultValue) {
        return iso3ToIso2Map.getOrDefault(langIso3Code, defaultValue);
    }

    public static String getIso2FromLang(String langNameInEnglish, String defaultValue) {
        return langNameToIso2Map.getOrDefault(langNameInEnglish, defaultValue);
    }

    static {
        for (String languageCode : Locale.getISOLanguages()) {
            Locale locale = new Locale(languageCode);
            String languageName = locale.getDisplayLanguage(new Locale("en"));
            langNameToIso2Map.put(languageName, languageCode);
            String languageISO3 = locale.getISO3Language();
            iso3ToIso2Map.put(languageISO3, languageCode);
        }
    }
}

