/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.speechtotext.impl.engine;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.opencastproject.speechtotext.api.SpeechToTextEngine;
import org.opencastproject.speechtotext.api.SpeechToTextEngineException;
import org.opencastproject.speechtotext.util.LangCodeUtil;
import org.opencastproject.util.OsgiUtil;
import org.opencastproject.util.data.Option;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Whisper implementation of the SpeechToTextEngine interface", "enginetype=whisper"})
public class WhisperEngine
implements SpeechToTextEngine {
    private static final Logger logger = LoggerFactory.getLogger(WhisperEngine.class);
    private static final String engineName = "Whisper";
    private static final String WHISPER_EXECUTABLE_PATH_CONFIG_KEY = "whisper.root.path";
    public static final String WHISPER_EXECUTABLE_DEFAULT_PATH = "whisper";
    private String whisperExecutable = "whisper";
    private static final String WHISPER_MODEL_CONFIG_KEY = "whisper.model";
    public static final String WHISPER_MODEL_DEFAULT = "base";
    private String whisperModel = "base";
    private static final String WHISPER_QUANTIZATION = "whisper.quantization";
    private String quantization;
    private static final String WHISPER_VAD = "whisper.vad_enabled";
    private Option<Boolean> isVADEnabled = Option.none();
    private final Pattern outputPattern = Pattern.compile("\\[\\d{2}:\\d{2}.\\d{3} --> \\d{2}:\\d{2}.\\d{3}]");
    private static final String WHISPER_ARGS_CONFIG_KEY = "whisper.args";
    private String[] whisperArgs;

    public String getEngineName() {
        return engineName;
    }

    @Activate
    @Modified
    public void activate(ComponentContext cc) {
        Dictionary prop = cc.getProperties();
        logger.debug("Activated/Modified Whisper engine service");
        this.whisperExecutable = Objects.toString(prop.get(WHISPER_EXECUTABLE_PATH_CONFIG_KEY), WHISPER_EXECUTABLE_DEFAULT_PATH);
        logger.debug("Set Whisper path to {}", (Object)this.whisperExecutable);
        this.whisperModel = Objects.toString(prop.get(WHISPER_MODEL_CONFIG_KEY), WHISPER_MODEL_DEFAULT);
        logger.debug("Whisper model set to {}", (Object)this.whisperModel);
        this.quantization = Objects.toString(prop.get(WHISPER_QUANTIZATION), null);
        logger.debug("Whisper quantization set to {}", (Object)this.quantization);
        this.isVADEnabled = OsgiUtil.getOptCfgAsBoolean((Dictionary)prop, (String)WHISPER_VAD);
        logger.debug("Whisper Voice Activity Detection set to {}", this.isVADEnabled.getOrElse((Object)false));
        this.whisperArgs = Objects.toString(prop.get(WHISPER_ARGS_CONFIG_KEY), "").trim().split("\\s+");
        logger.debug("Additional args for Whisper: {}", (Object)this.whisperArgs);
        logger.debug("Finished activating/updating speech-to-text service");
    }

    public SpeechToTextEngine.Result generateSubtitlesFile(File mediaFile, File workingDirectory, String language, Boolean translate) throws SpeechToTextEngineException {
        File output;
        String[] baseCommands = new String[]{this.whisperExecutable, mediaFile.getAbsolutePath(), "--model", this.whisperModel, "--output_dir", workingDirectory.getAbsolutePath()};
        ArrayList<String> transcriptionCommand = new ArrayList<String>(Arrays.asList(baseCommands));
        if (translate.booleanValue()) {
            transcriptionCommand.add("--task");
            transcriptionCommand.add("translate");
            logger.debug("Translation enabled");
            language = "en";
        }
        if (!language.isBlank() && !translate.booleanValue()) {
            if ((language = LangCodeUtil.iso3ToIso2(language, "")).isBlank()) {
                logger.warn("No 2-letter language code found, using language auto detection");
            } else {
                logger.debug("Using language {} from workflows", (Object)language);
                transcriptionCommand.add("--language");
                transcriptionCommand.add(language);
            }
        }
        if (this.quantization != null) {
            logger.debug("Using quantization {}", (Object)this.quantization);
            transcriptionCommand.add("--compute_type");
            transcriptionCommand.add(this.quantization);
        }
        if (this.isVADEnabled.isSome()) {
            logger.debug("Setting VAD to {}", this.isVADEnabled.get());
            transcriptionCommand.add("--vad_filter");
            transcriptionCommand.add(((Boolean)this.isVADEnabled.get()).toString());
        }
        transcriptionCommand.addAll(Arrays.asList(this.whisperArgs));
        logger.info("Executing Whisper's transcription command: {}", transcriptionCommand);
        Process transcriptonProcess = null;
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(transcriptionCommand);
            processBuilder.redirectInput(ProcessBuilder.Redirect.PIPE).redirectOutput(ProcessBuilder.Redirect.PIPE).redirectError(ProcessBuilder.Redirect.PIPE);
            processBuilder.redirectErrorStream(true);
            transcriptonProcess = processBuilder.start();
            try (BufferedReader in = new BufferedReader(new InputStreamReader(transcriptonProcess.getInputStream()));){
                String line;
                while ((line = in.readLine()) != null) {
                    logger.debug(line);
                }
            }
            int exitCode = transcriptonProcess.waitFor();
            logger.debug("Whisper process finished with exit code {}", (Object)exitCode);
            if (exitCode != 0) {
                throw new SpeechToTextEngineException(String.format("Whisper exited abnormally with status %d (command: %s)", exitCode, transcriptionCommand));
            }
            String outputFileName = FilenameUtils.getBaseName((String)mediaFile.getAbsolutePath()) + ".vtt";
            output = new File(workingDirectory, outputFileName);
            logger.debug("Whisper output file {}", (Object)output);
            if (!output.isFile()) {
                throw new SpeechToTextEngineException("Whisper produced no output");
            }
            logger.info("Subtitles file generated successfully: {}", (Object)output);
        }
        catch (Exception e) {
            logger.debug("Transcription failed closing Whisper transcription process for: {}", (Object)mediaFile);
            throw new SpeechToTextEngineException((Throwable)e);
        }
        finally {
            if (transcriptonProcess != null) {
                transcriptonProcess.destroy();
                if (transcriptonProcess.isAlive()) {
                    transcriptonProcess.destroyForcibly();
                }
            }
        }
        if (language.isBlank()) {
            String jsonFile = FilenameUtils.removeExtension((String)output.getAbsolutePath()) + ".json";
            JSONParser jsonParser = new JSONParser();
            try {
                FileReader reader = new FileReader(jsonFile);
                Object obj = jsonParser.parse((Reader)reader);
                JSONObject jsonObject = (JSONObject)obj;
                language = (String)jsonObject.get((Object)"language");
                language = LangCodeUtil.getIso2FromLang(language, language);
                logger.debug("Language detected by Whisper: {}", (Object)language);
            }
            catch (Exception e) {
                logger.debug("Error reading Whisper JSON file for: {}", (Object)mediaFile);
                throw new SpeechToTextEngineException((Throwable)e);
            }
        }
        return new SpeechToTextEngine.Result(language, output);
    }
}

