/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.speechtotext.impl.engine;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.opencastproject.speechtotext.api.SpeechToTextEngine;
import org.opencastproject.speechtotext.api.SpeechToTextEngineException;
import org.opencastproject.speechtotext.util.LangCodeUtil;
import org.opencastproject.util.IoSupport;
import org.opencastproject.util.OsgiUtil;
import org.opencastproject.util.data.Option;
import org.opencastproject.util.data.functions.Strings;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=WhisperC++ implementation of the SpeechToTextEngine interface", "enginetype=whispercpp"})
public class WhisperCppEngine
implements SpeechToTextEngine {
    private static final Logger logger = LoggerFactory.getLogger(WhisperCppEngine.class);
    private static final String engineName = "WhisperC++";
    private static final String WHISPERCPP_EXECUTABLE_PATH_CONFIG_KEY = "whispercpp.root.path";
    public static final String WHISPERCPP_EXECUTABLE_DEFAULT_PATH = "whisper-cli";
    private String whispercppExecutable = "whisper-cli";
    private static final String WHISPERCPP_MODEL_CONFIG_KEY = "whispercpp.model";
    public static final String WHISPERCPP_MODEL_DEFAULT = "/usr/share/whisper.cpp/models/ggml-base.bin";
    private String whispercppModel = "/usr/share/whisper.cpp/models/ggml-base.bin";
    private static final String WHISPERCPP_ARGS_CONFIG_KEY = "whispercpp.args";
    private String[] whispercppArgs;
    private static final String WHISPERCPP_BEAM_SIZE_CONFIG_KEY = "whispercpp.beam-size";
    private Option<Integer> whispercppBeamSize;
    private static final String WHISPERCPP_MAX_LENGTH_CONFIG_KEY = "whispercpp.max-len";
    private Option<Integer> whispercppMaxLength;
    private static final String WHISPERCPP_THREADS_CONFIG_KEY = "whispercpp.threads";
    private Option<Integer> whispercppThreads;
    private static final String WHISPERCPP_PROCESSORS_CONFIG_KEY = "whispercpp.processors";
    private Option<Integer> whispercppProcessors;
    private static final String WHISPERCPP_MAX_CONTEXT_CONFIG_KEY = "whispercpp.max-context";
    private Option<Integer> whispercppMaxContext;
    private static final String WHISPERCPP_SPLIT_ON_WORD_CONFIG_KEY = "whispercpp.split-on-word";
    private Option<Boolean> whispercppSplitOnWord;
    private static final String WHISPERCPP_BEST_OF_CONFIG_KEY = "whispercpp.best-of";
    private Option<Integer> whispercppBestOf;
    private static final String WHISPERCPP_WORD_THRESHOLD_CONFIG_KEY = "whispercpp.word-thold";
    private Option<Double> whispercppWordThreshold;
    private static final String WHISPERCPP_ENTROPY_THRESHOLD_CONFIG_KEY = "whispercpp.entropy-thold";
    private Option<Double> whispercppEntropyThreshold;
    private static final String WHISPERCPP_LOG_PROB_THRESHOLD_CONFIG_KEY = "whispercpp.logprob-thold";
    private Option<Double> whispercppLogProbThreshold;
    private static final String WHISPERCPP_DIARIZATION_CONFIG_KEY = "whispercpp.diarize";
    private Option<Boolean> whispercppDiarization;
    private static final String WHISPERCPP_TINY_DIARIZATION_CONFIG_KEY = "whispercpp.tinydiarize";
    private Option<Boolean> whispercppTinyDiarization;
    private static final String WHISPERCPP_NO_FALLBACK_CONFIG_KEY = "whispercpp.no-fallback";
    private Option<Boolean> whispercppNoFallback;
    private static final String WHISPERCPP_VAD_CONFIG_KEY = "whispercpp.vad";
    private Option<Boolean> whispercppVad;
    private static final String WHISPERCPP_VAD_MODEL_CONFIG_KEY = "whispercpp.vad-model";
    private Option<String> whispercppVadModel;
    private static final String WHISPERCPP_VAD_THRESHOLD_CONFIG_KEY = "whispercpp.vad-thold";
    private Option<Double> whispercppVadThreshold;
    private static final String WHISPERCPP_VAD_MIN_SPEECH_CONFIG_KEY = "whispercpp.vad-min-speech-dur";
    private Option<Integer> whispercppVadMinSpeech;
    private static final String WHISPERCPP_VAD_MIN_SILENCE_CONFIG_KEY = "whispercpp.vad-min-silence-dur";
    private Option<Integer> whispercppVadMinSilence;
    private static final String WHISPERCPP_VAD_MAX_SPEECH_CONFIG_KEY = "whispercpp.vad-max-speech-dur";
    private Option<Double> whispercppVadMaxSpeech;
    private static final String WHISPERCPP_VAD_SPEECH_PADDING_CONFIG_KEY = "whispercpp.vad-speech-pad";
    private Option<Integer> whispercppVadSpeechPadding;
    private static final String WHISPERCPP_VAD_SAMPLES_OVERLAP_CONFIG_KEY = "whispercpp.vad-samples-overlap";
    private Option<Double> whispercppVadSamplesOverlap;
    private static final String AUTO_ENCODING_CONFIG_KEY = "whispercpp.auto-encode";
    private static final Boolean AUTO_ENCODING_DEFAULT = true;
    private boolean autoEncode = AUTO_ENCODING_DEFAULT;
    public static final String FFMPEG_BINARY_CONFIG_KEY = "org.opencastproject.composer.ffmpeg.path";
    public static final String DEFAULT_FFMPEG_BINARY = "ffmpeg";
    protected String ffmpegBinary = "ffmpeg";

    public String getEngineName() {
        return engineName;
    }

    @Activate
    @Modified
    public void activate(ComponentContext cc) {
        logger.debug("Activated/Modified WhisperC++ engine service class");
        this.whispercppExecutable = (String)StringUtils.defaultIfBlank((CharSequence)((String)cc.getProperties().get(WHISPERCPP_EXECUTABLE_PATH_CONFIG_KEY)), (CharSequence)WHISPERCPP_EXECUTABLE_DEFAULT_PATH);
        logger.debug("Set WhisperC++ path to {}", (Object)this.whispercppExecutable);
        this.whispercppModel = (String)StringUtils.defaultIfBlank((CharSequence)((String)cc.getProperties().get(WHISPERCPP_MODEL_CONFIG_KEY)), (CharSequence)WHISPERCPP_MODEL_DEFAULT);
        logger.debug("WhisperC++ Language model set to {}", (Object)this.whispercppModel);
        this.whispercppBeamSize = OsgiUtil.getOptCfgAsInt((Dictionary)cc.getProperties(), (String)WHISPERCPP_BEAM_SIZE_CONFIG_KEY);
        if (this.whispercppBeamSize.isSome()) {
            logger.debug("WhisperC++ beam size set to {}", this.whispercppBeamSize);
        }
        this.whispercppMaxLength = OsgiUtil.getOptCfgAsInt((Dictionary)cc.getProperties(), (String)WHISPERCPP_MAX_LENGTH_CONFIG_KEY);
        if (this.whispercppMaxLength.isSome()) {
            logger.debug("WhisperC++ maximum segment length set to {}", this.whispercppMaxLength);
        }
        this.whispercppThreads = OsgiUtil.getOptCfgAsInt((Dictionary)cc.getProperties(), (String)WHISPERCPP_THREADS_CONFIG_KEY);
        if (this.whispercppThreads.isSome()) {
            logger.debug("WhisperC++ number of threads set to {}", this.whispercppThreads);
        }
        this.whispercppProcessors = OsgiUtil.getOptCfgAsInt((Dictionary)cc.getProperties(), (String)WHISPERCPP_PROCESSORS_CONFIG_KEY);
        if (this.whispercppProcessors.isSome()) {
            logger.debug("WhisperC++ number of processors set to {}", this.whispercppProcessors);
        }
        this.whispercppMaxContext = OsgiUtil.getOptCfgAsInt((Dictionary)cc.getProperties(), (String)WHISPERCPP_MAX_CONTEXT_CONFIG_KEY);
        if (this.whispercppMaxContext.isSome()) {
            logger.debug("WhisperC++ max context set to {}", this.whispercppMaxContext);
        }
        this.whispercppSplitOnWord = OsgiUtil.getOptCfgAsBoolean((Dictionary)cc.getProperties(), (String)WHISPERCPP_SPLIT_ON_WORD_CONFIG_KEY);
        if (this.whispercppSplitOnWord.isSome()) {
            logger.debug("WhisperC++ split on word set to {}", this.whispercppSplitOnWord);
        }
        this.whispercppBestOf = OsgiUtil.getOptCfgAsInt((Dictionary)cc.getProperties(), (String)WHISPERCPP_BEST_OF_CONFIG_KEY);
        if (this.whispercppBestOf.isSome()) {
            logger.debug("WhisperC++ best of set to {}", this.whispercppBestOf);
        }
        this.whispercppWordThreshold = OsgiUtil.getOptCfg((Dictionary)cc.getProperties(), (String)WHISPERCPP_WORD_THRESHOLD_CONFIG_KEY).bind(Strings.toDouble);
        if (this.whispercppWordThreshold.isSome()) {
            logger.debug("WhisperC++ word threshold set to {}", this.whispercppWordThreshold);
        }
        this.whispercppEntropyThreshold = OsgiUtil.getOptCfg((Dictionary)cc.getProperties(), (String)WHISPERCPP_ENTROPY_THRESHOLD_CONFIG_KEY).bind(Strings.toDouble);
        if (this.whispercppEntropyThreshold.isSome()) {
            logger.debug("WhisperC++ entropy threshold set to {}", this.whispercppEntropyThreshold);
        }
        this.whispercppLogProbThreshold = OsgiUtil.getOptCfg((Dictionary)cc.getProperties(), (String)WHISPERCPP_LOG_PROB_THRESHOLD_CONFIG_KEY).bind(Strings.toDouble);
        if (this.whispercppLogProbThreshold.isSome()) {
            logger.debug("WhisperC++ log prob threshold set to {}", this.whispercppLogProbThreshold);
        }
        this.whispercppDiarization = OsgiUtil.getOptCfgAsBoolean((Dictionary)cc.getProperties(), (String)WHISPERCPP_DIARIZATION_CONFIG_KEY);
        if (this.whispercppDiarization.isSome()) {
            logger.debug("WhisperC++ diarization set to {}", this.whispercppDiarization);
        }
        this.whispercppTinyDiarization = OsgiUtil.getOptCfgAsBoolean((Dictionary)cc.getProperties(), (String)WHISPERCPP_TINY_DIARIZATION_CONFIG_KEY);
        if (this.whispercppTinyDiarization.isSome()) {
            logger.debug("WhisperC++ tiny diarization set to {}", this.whispercppTinyDiarization);
        }
        this.whispercppNoFallback = OsgiUtil.getOptCfgAsBoolean((Dictionary)cc.getProperties(), (String)WHISPERCPP_NO_FALLBACK_CONFIG_KEY);
        if (this.whispercppNoFallback.isSome()) {
            logger.debug("WhisperC++ no fallback set to {}", this.whispercppNoFallback);
        }
        this.whispercppVad = OsgiUtil.getOptCfgAsBoolean((Dictionary)cc.getProperties(), (String)WHISPERCPP_VAD_CONFIG_KEY);
        if (this.whispercppVad.isSome()) {
            logger.debug("WhisperC++ VAD set to {}", this.whispercppVad);
        }
        this.whispercppVadModel = OsgiUtil.getOptCfg((Dictionary)cc.getProperties(), (String)WHISPERCPP_VAD_MODEL_CONFIG_KEY);
        if (this.whispercppVadModel.isSome()) {
            logger.debug("WhisperC++ VAD model set to {}", this.whispercppVadModel);
        }
        this.whispercppVadThreshold = OsgiUtil.getOptCfg((Dictionary)cc.getProperties(), (String)WHISPERCPP_VAD_THRESHOLD_CONFIG_KEY).bind(Strings.toDouble);
        if (this.whispercppVadThreshold.isSome()) {
            logger.debug("WhisperC++ VAD threshold set to {}", this.whispercppVadThreshold);
        }
        this.whispercppVadMinSpeech = OsgiUtil.getOptCfgAsInt((Dictionary)cc.getProperties(), (String)WHISPERCPP_VAD_MIN_SPEECH_CONFIG_KEY);
        if (this.whispercppVadMinSpeech.isSome()) {
            logger.debug("WhisperC++ VAD min speech set to {}", this.whispercppVadMinSpeech);
        }
        this.whispercppVadMinSilence = OsgiUtil.getOptCfgAsInt((Dictionary)cc.getProperties(), (String)WHISPERCPP_VAD_MIN_SILENCE_CONFIG_KEY);
        if (this.whispercppVadMinSilence.isSome()) {
            logger.debug("WhisperC++ VAD min silence set to {}", this.whispercppVadMinSilence);
        }
        this.whispercppVadMaxSpeech = OsgiUtil.getOptCfg((Dictionary)cc.getProperties(), (String)WHISPERCPP_VAD_MAX_SPEECH_CONFIG_KEY).bind(Strings.toDouble);
        if (this.whispercppVadMaxSpeech.isSome()) {
            logger.debug("WhisperC++ VAD max speech set to {}", this.whispercppVadMaxSpeech);
        }
        this.whispercppVadSpeechPadding = OsgiUtil.getOptCfgAsInt((Dictionary)cc.getProperties(), (String)WHISPERCPP_VAD_SPEECH_PADDING_CONFIG_KEY);
        if (this.whispercppVadSpeechPadding.isSome()) {
            logger.debug("WhisperC++ VAD speech padding set to {}", this.whispercppVadSpeechPadding);
        }
        this.whispercppVadSamplesOverlap = OsgiUtil.getOptCfg((Dictionary)cc.getProperties(), (String)WHISPERCPP_VAD_SAMPLES_OVERLAP_CONFIG_KEY).bind(Strings.toDouble);
        if (this.whispercppVadSamplesOverlap.isSome()) {
            logger.debug("WhisperC++ VAD samples overlap set to {}", this.whispercppVadSamplesOverlap);
        }
        this.whispercppArgs = Objects.toString(cc.getProperties().get(WHISPERCPP_ARGS_CONFIG_KEY), "").trim().split("\\s+");
        logger.debug("Additional args for WhisperC++: {}", (Object)this.whispercppArgs);
        this.autoEncode = BooleanUtils.toBoolean((String)Objects.toString(cc.getProperties().get(AUTO_ENCODING_CONFIG_KEY), AUTO_ENCODING_DEFAULT.toString()));
        logger.debug("Automatically convert input media: {}", (Object)this.autoEncode);
        this.ffmpegBinary = Objects.toString(cc.getBundleContext().getProperty(FFMPEG_BINARY_CONFIG_KEY), DEFAULT_FFMPEG_BINARY);
        logger.debug("ffmpeg binary set to {}", (Object)this.ffmpegBinary);
        logger.debug("Finished activating/updating speech-to-text service");
    }

    public SpeechToTextEngine.Result generateSubtitlesFile(File mediaFile, File workingDirectory, String language, Boolean translate) throws SpeechToTextEngineException {
        File vtt;
        String subtitleLanguage;
        String whisperInput = mediaFile.getAbsolutePath();
        if (this.autoEncode) {
            whisperInput = FilenameUtils.concat((String)workingDirectory.getAbsolutePath(), (String)(String.valueOf(UUID.randomUUID()) + ".wav"));
            List<String> ffmpegCommand = List.of(this.ffmpegBinary, "-i", mediaFile.getAbsolutePath(), "-ar", "16000", "-ac", "1", "-c:a", "pcm_s16le", whisperInput);
            try {
                this.execCommand(ffmpegCommand);
            }
            catch (IOException e) {
                throw new SpeechToTextEngineException("Failed to convert audio file", (Throwable)e);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        if (!whisperInput.toLowerCase().endsWith(".wav")) {
            throw new SpeechToTextEngineException("WhisperC++ currently doesn't support any media extension other than wav");
        }
        String outputName = FilenameUtils.getBaseName((String)mediaFile.getAbsolutePath());
        ArrayList<String> command = new ArrayList<String>(List.of(this.whispercppExecutable, whisperInput, "--model", this.whispercppModel, "-ovtt", "-oj", "--output-file", FilenameUtils.concat((String)workingDirectory.getAbsolutePath(), (String)outputName)));
        if (this.whispercppBeamSize.isSome()) {
            command.add("-bs");
            command.add(Integer.toString((Integer)this.whispercppBeamSize.get()));
        }
        if (this.whispercppMaxLength.isSome()) {
            command.add("-ml");
            command.add(Integer.toString((Integer)this.whispercppMaxLength.get()));
        }
        if (this.whispercppThreads.isSome()) {
            command.add("-t");
            command.add(Integer.toString((Integer)this.whispercppThreads.get()));
        }
        if (this.whispercppProcessors.isSome()) {
            command.add("-p");
            command.add(Integer.toString((Integer)this.whispercppProcessors.get()));
        }
        if (this.whispercppMaxContext.isSome()) {
            command.add("-mc");
            command.add(Integer.toString((Integer)this.whispercppMaxContext.get()));
        }
        if (this.whispercppSplitOnWord.isSome() && ((Boolean)this.whispercppSplitOnWord.get()).booleanValue()) {
            command.add("-sow");
        }
        if (this.whispercppBestOf.isSome()) {
            command.add("-bo");
            command.add(Integer.toString((Integer)this.whispercppBestOf.get()));
        }
        if (this.whispercppWordThreshold.isSome()) {
            command.add("-wt");
            command.add(String.format(Locale.US, "%f", this.whispercppWordThreshold.get()));
        }
        if (this.whispercppEntropyThreshold.isSome()) {
            command.add("-et");
            command.add(String.format(Locale.US, "%f", this.whispercppEntropyThreshold.get()));
        }
        if (this.whispercppLogProbThreshold.isSome()) {
            command.add("-lpt");
            command.add(String.format(Locale.US, "%f", this.whispercppLogProbThreshold.get()));
        }
        if (this.whispercppDiarization.isSome() && ((Boolean)this.whispercppDiarization.get()).booleanValue()) {
            command.add("-di");
        }
        if (this.whispercppTinyDiarization.isSome() && ((Boolean)this.whispercppTinyDiarization.get()).booleanValue()) {
            command.add("-tdrz");
        }
        if (this.whispercppNoFallback.isSome() && ((Boolean)this.whispercppNoFallback.get()).booleanValue()) {
            command.add("-nf");
        }
        if (this.whispercppVad.isSome() && ((Boolean)this.whispercppVad.get()).booleanValue()) {
            command.add("--vad");
        }
        if (this.whispercppVadModel.isSome()) {
            command.add("-vm");
            command.add((String)this.whispercppVadModel.get());
        }
        if (this.whispercppVadThreshold.isSome()) {
            command.add("-vt");
            command.add(String.format(Locale.US, "%f", this.whispercppVadThreshold.get()));
        }
        if (this.whispercppVadMinSpeech.isSome()) {
            command.add("-vspd");
            command.add(Integer.toString((Integer)this.whispercppVadMinSpeech.get()));
        }
        if (this.whispercppVadMinSilence.isSome()) {
            command.add("-vsd");
            command.add(Integer.toString((Integer)this.whispercppVadMinSilence.get()));
        }
        if (this.whispercppVadMaxSpeech.isSome()) {
            command.add("-vmsd");
            command.add(String.format(Locale.US, "%f", this.whispercppVadMaxSpeech.get()));
        }
        if (this.whispercppVadSpeechPadding.isSome()) {
            command.add("-vp");
            command.add(Integer.toString((Integer)this.whispercppVadSpeechPadding.get()));
        }
        if (this.whispercppVadSamplesOverlap.isSome()) {
            command.add("-vo");
            command.add(String.format(Locale.US, "%f", this.whispercppVadSamplesOverlap.get()));
        }
        if (!language.isBlank()) {
            logger.info("Found language '{}'", (Object)language);
            language = LangCodeUtil.iso3ToIso2(language, language);
            logger.info("Using language code '{}' for transcription process", (Object)language);
            command.add("--language");
            command.add(language);
        } else {
            logger.debug("Auto-detecting language");
            command.add("--language");
            command.add("auto");
        }
        if (translate.booleanValue()) {
            command.add("--translate");
            logger.info("Translation enabled");
            subtitleLanguage = "en";
        } else {
            subtitleLanguage = language;
        }
        command.addAll(Arrays.asList(this.whispercppArgs));
        logger.info("Executing WhisperC++'s transcription command: {}", command);
        try {
            this.execCommand(command);
            vtt = new File(workingDirectory, outputName + ".vtt");
            if (!vtt.isFile()) {
                throw new SpeechToTextEngineException("WhisperC++ produced no output");
            }
            logger.info("Subtitles file generated successfully: {}", (Object)vtt);
        }
        catch (Exception e) {
            logger.info("Transcription failed closing WhisperC++ transcription process for: {}", (Object)whisperInput);
            throw new SpeechToTextEngineException((Throwable)e);
        }
        if (subtitleLanguage.isBlank()) {
            JSONParser jsonParser = new JSONParser();
            File json = new File(workingDirectory, outputName + ".json");
            try {
                FileReader reader = new FileReader(json);
                Object obj = jsonParser.parse((Reader)reader);
                JSONObject jsonObject = (JSONObject)obj;
                JSONObject result = (JSONObject)jsonObject.get((Object)"result");
                subtitleLanguage = (String)result.get((Object)"language");
                subtitleLanguage = LangCodeUtil.getIso2FromLang(subtitleLanguage, subtitleLanguage);
                logger.info("Language detected by WhisperC++: {}", (Object)subtitleLanguage);
            }
            catch (Exception e) {
                logger.info("Error reading WhisperC++ JSON file for: {}", (Object)mediaFile);
                throw new SpeechToTextEngineException((Throwable)e);
            }
            finally {
                FileUtils.deleteQuietly((File)json);
            }
        }
        return new SpeechToTextEngine.Result(subtitleLanguage, vtt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execCommand(List<String> command) throws IOException, InterruptedException, SpeechToTextEngineException {
        Process process;
        block15: {
            logger.info("Executing command: {}", command);
            process = null;
            try {
                ProcessBuilder processBuilder = new ProcessBuilder(command);
                processBuilder.redirectErrorStream(true);
                processBuilder.redirectInput(ProcessBuilder.Redirect.PIPE).redirectError(ProcessBuilder.Redirect.PIPE).redirectOutput(ProcessBuilder.Redirect.PIPE);
                process = processBuilder.start();
                try (BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                    String line;
                    while ((line = in.readLine()) != null) {
                        logger.debug(line);
                    }
                }
                int exitCode = process.waitFor();
                logger.info("Process finished with exit code {}", (Object)exitCode);
                if (exitCode == 0) break block15;
                Object error = "";
                try (InputStream errorStream = process.getInputStream();){
                    error = "\n Output:\n" + IOUtils.toString((InputStream)errorStream, (Charset)StandardCharsets.UTF_8);
                }
                throw new SpeechToTextEngineException(String.format("Process exited abnormally with status %d (command: %s) %s", exitCode, command, error));
            }
            catch (Throwable throwable) {
                IoSupport.closeQuietly(process);
                throw throwable;
            }
        }
        IoSupport.closeQuietly((Process)process);
    }
}

