/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.speechtotext.impl.engine;

import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.speechtotext.api.SpeechToTextEngine;
import org.opencastproject.speechtotext.api.SpeechToTextEngineException;
import org.opencastproject.util.IoSupport;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Vosk implementation of the SpeechToTextEngine interface", "enginetype=vosk"})
public class VoskEngine
implements SpeechToTextEngine {
    private static final Logger logger = LoggerFactory.getLogger(VoskEngine.class);
    private static final String engineName = "Vosk";
    private static final String VOSK_EXECUTABLE_PATH_CONFIG_KEY = "vosk.root.path";
    public static final String VOSK_EXECUTABLE_DEFAULT_PATH = "vosk-cli";
    private String voskExecutable = "vosk-cli";
    private static final String VOSK_DEFAULT_LANGUAGE_KEY = "vosk.default.language";
    public static final String VOSK_DEFAULT_LANGUAGE = "eng";
    private String voskLanguage = "eng";

    public String getEngineName() {
        return engineName;
    }

    @Activate
    @Modified
    public void activate(ComponentContext cc) {
        logger.debug("Activated/Modified Vosk engine service class");
        this.voskExecutable = (String)StringUtils.defaultIfBlank((CharSequence)((String)cc.getProperties().get(VOSK_EXECUTABLE_PATH_CONFIG_KEY)), (CharSequence)VOSK_EXECUTABLE_DEFAULT_PATH);
        this.voskLanguage = (String)StringUtils.defaultIfBlank((CharSequence)((String)cc.getProperties().get(VOSK_DEFAULT_LANGUAGE_KEY)), (CharSequence)VOSK_DEFAULT_LANGUAGE);
        logger.debug("Set vosk path to {}", (Object)this.voskExecutable);
        logger.debug("Set default vosk language to {}", (Object)this.voskLanguage);
        logger.debug("Finished activating/updating speech-to-text service");
    }

    public SpeechToTextEngine.Result generateSubtitlesFile(File mediaFile, File workingDirectory, String language, Boolean translate) throws SpeechToTextEngineException {
        if (language.isBlank()) {
            logger.debug("Language field empty, using {} as default language", (Object)this.voskLanguage);
            language = this.voskLanguage;
        }
        File output = new File(workingDirectory, FilenameUtils.getBaseName((String)mediaFile.getAbsolutePath()) + ".vtt");
        List<String> command = Arrays.asList(this.voskExecutable, "-i", mediaFile.getAbsolutePath(), "-o", output.getAbsolutePath(), "-l", language);
        logger.info("Executing Vosk's transcription command: {}", command);
        Process process = null;
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(command);
            processBuilder.redirectErrorStream(true);
            process = processBuilder.start();
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                Object error = "";
                try (InputStream errorStream = process.getInputStream();){
                    error = "\n Output:\n" + IOUtils.toString((InputStream)errorStream, (Charset)StandardCharsets.UTF_8);
                }
                throw new SpeechToTextEngineException(String.format("Vosk exited abnormally with status %d (command: %s)%s", exitCode, command, error));
            }
            if (!output.isFile()) {
                throw new SpeechToTextEngineException("Vosk produced no output");
            }
            logger.info("Subtitles file generated successfully: {}", (Object)output);
        }
        catch (Exception e) {
            try {
                logger.debug("Transcription failed closing Vosk transcription process for: {}", (Object)mediaFile);
                throw new SpeechToTextEngineException((Throwable)e);
            }
            catch (Throwable throwable) {
                IoSupport.closeQuietly(process);
                throw throwable;
            }
        }
        IoSupport.closeQuietly((Process)process);
        return new SpeechToTextEngine.Result(language, output);
    }
}

