/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.speechtotext.impl.engine;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.Locale;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.opencastproject.speechtotext.api.SpeechToTextEngine;
import org.opencastproject.speechtotext.api.SpeechToTextEngineException;
import org.opencastproject.util.IoSupport;
import org.opencastproject.util.OsgiUtil;
import org.opencastproject.util.data.Option;
import org.opencastproject.util.data.functions.Strings;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=WhisperC++ implementation of the SpeechToTextEngine interface", "enginetype=whispercpp"})
public class WhisperCppEngine
implements SpeechToTextEngine {
    private static final Logger logger = LoggerFactory.getLogger(WhisperCppEngine.class);
    private static final String engineName = "WhisperC++";
    private static final String WHISPERCPP_EXECUTABLE_PATH_CONFIG_KEY = "whispercpp.root.path";
    public static final String WHISPERCPP_EXECUTABLE_DEFAULT_PATH = "whispercpp";
    private String whispercppExecutable = "whispercpp";
    private static final String WHISPERCPP_MODEL_CONFIG_KEY = "whispercpp.model";
    public static final String WHISPERCPP_MODEL_DEFAULT = "/usr/share/ggml/ggml-base.bin";
    private String whispercppModel = "/usr/share/ggml/ggml-base.bin";
    private static final String WHISPERCPP_BEAM_SIZE_CONFIG_KEY = "whispercpp.beam-size";
    private Option<Integer> whispercppBeamSize;
    private static final String WHISPERCPP_MAX_LENGTH_CONFIG_KEY = "whispercpp.max-len";
    private Option<Integer> whispercppMaxLength;
    private static final String WHISPERCPP_THREADS_CONFIG_KEY = "whispercpp.threads";
    private Option<Integer> whispercppThreads;
    private static final String WHISPERCPP_PROCESSORS_CONFIG_KEY = "whispercpp.processors";
    private Option<Integer> whispercppProcessors;
    private static final String WHISPERCPP_MAX_CONTEXT_CONFIG_KEY = "whispercpp.max-context";
    private Option<Integer> whispercppMaxContext;
    private static final String WHISPERCPP_SPLIT_ON_WORD_CONFIG_KEY = "whispercpp.split-on-word";
    private Option<Boolean> whispercppSplitOnWord;
    private static final String WHISPERCPP_BEST_OF_CONFIG_KEY = "whispercpp.best-of";
    private Option<Integer> whispercppBestOf;
    private static final String WHISPERCPP_WORD_THRESHOLD_CONFIG_KEY = "whispercpp.word-thold";
    private Option<Double> whispercppWordThreshold;
    private static final String WHISPERCPP_ENTROPY_THRESHOLD_CONFIG_KEY = "whispercpp.entropy-thold";
    private Option<Double> whispercppEntropyThreshold;
    private static final String WHISPERCPP_LOG_PROB_THRESHOLD_CONFIG_KEY = "whispercpp.logprob-thold";
    private Option<Double> whispercppLogProbThreshold;
    private static final String WHISPERCPP_DIARIZATION_CONFIG_KEY = "whispercpp.diarize";
    private Option<Boolean> whispercppDiarization;
    private static final String WHISPERCPP_TINY_DIARIZATION_CONFIG_KEY = "whispercpp.tinydiarize";
    private Option<Boolean> whispercppTinyDiarization;
    private static final String WHISPERCPP_NO_FALLBACK_CONFIG_KEY = "whispercpp.no-fallback";
    private Option<Boolean> whispercppNoFallback;

    public String getEngineName() {
        return engineName;
    }

    @Activate
    @Modified
    public void activate(ComponentContext cc) {
        logger.debug("Activated/Modified WhisperC++ engine service class");
        this.whispercppExecutable = (String)StringUtils.defaultIfBlank((CharSequence)((String)cc.getProperties().get(WHISPERCPP_EXECUTABLE_PATH_CONFIG_KEY)), (CharSequence)WHISPERCPP_EXECUTABLE_DEFAULT_PATH);
        logger.debug("Set WhisperC++ path to {}", (Object)this.whispercppExecutable);
        this.whispercppModel = (String)StringUtils.defaultIfBlank((CharSequence)((String)cc.getProperties().get(WHISPERCPP_MODEL_CONFIG_KEY)), (CharSequence)WHISPERCPP_MODEL_DEFAULT);
        logger.debug("WhisperC++ Language model set to {}", (Object)this.whispercppModel);
        this.whispercppBeamSize = OsgiUtil.getOptCfgAsInt((Dictionary)cc.getProperties(), (String)WHISPERCPP_BEAM_SIZE_CONFIG_KEY);
        if (this.whispercppBeamSize.isSome()) {
            logger.debug("WhisperC++ beam size set to {}", this.whispercppBeamSize);
        }
        this.whispercppMaxLength = OsgiUtil.getOptCfgAsInt((Dictionary)cc.getProperties(), (String)WHISPERCPP_MAX_LENGTH_CONFIG_KEY);
        if (this.whispercppMaxLength.isSome()) {
            logger.debug("WhisperC++ maximum segment length set to {}", this.whispercppMaxLength);
        }
        this.whispercppThreads = OsgiUtil.getOptCfgAsInt((Dictionary)cc.getProperties(), (String)WHISPERCPP_THREADS_CONFIG_KEY);
        if (this.whispercppThreads.isSome()) {
            logger.debug("WhisperC++ number of threads set to {}", this.whispercppThreads);
        }
        this.whispercppProcessors = OsgiUtil.getOptCfgAsInt((Dictionary)cc.getProperties(), (String)WHISPERCPP_PROCESSORS_CONFIG_KEY);
        if (this.whispercppProcessors.isSome()) {
            logger.debug("WhisperC++ number of processors set to {}", this.whispercppProcessors);
        }
        this.whispercppMaxContext = OsgiUtil.getOptCfgAsInt((Dictionary)cc.getProperties(), (String)WHISPERCPP_MAX_CONTEXT_CONFIG_KEY);
        if (this.whispercppMaxContext.isSome()) {
            logger.debug("WhisperC++ max context set to {}", this.whispercppMaxContext);
        }
        this.whispercppSplitOnWord = OsgiUtil.getOptCfgAsBoolean((Dictionary)cc.getProperties(), (String)WHISPERCPP_SPLIT_ON_WORD_CONFIG_KEY);
        if (this.whispercppSplitOnWord.isSome()) {
            logger.debug("WhisperC++ split on word set to {}", this.whispercppSplitOnWord);
        }
        this.whispercppBestOf = OsgiUtil.getOptCfgAsInt((Dictionary)cc.getProperties(), (String)WHISPERCPP_BEST_OF_CONFIG_KEY);
        if (this.whispercppBestOf.isSome()) {
            logger.debug("WhisperC++ best of set to {}", this.whispercppBestOf);
        }
        this.whispercppWordThreshold = OsgiUtil.getOptCfg((Dictionary)cc.getProperties(), (String)WHISPERCPP_WORD_THRESHOLD_CONFIG_KEY).bind(Strings.toDouble);
        if (this.whispercppWordThreshold.isSome()) {
            logger.debug("WhisperC++ word threshold set to {}", this.whispercppWordThreshold);
        }
        this.whispercppEntropyThreshold = OsgiUtil.getOptCfg((Dictionary)cc.getProperties(), (String)WHISPERCPP_ENTROPY_THRESHOLD_CONFIG_KEY).bind(Strings.toDouble);
        if (this.whispercppEntropyThreshold.isSome()) {
            logger.debug("WhisperC++ entropy threshold set to {}", this.whispercppEntropyThreshold);
        }
        this.whispercppLogProbThreshold = OsgiUtil.getOptCfg((Dictionary)cc.getProperties(), (String)WHISPERCPP_LOG_PROB_THRESHOLD_CONFIG_KEY).bind(Strings.toDouble);
        if (this.whispercppLogProbThreshold.isSome()) {
            logger.debug("WhisperC++ log prob threshold set to {}", this.whispercppLogProbThreshold);
        }
        this.whispercppDiarization = OsgiUtil.getOptCfgAsBoolean((Dictionary)cc.getProperties(), (String)WHISPERCPP_DIARIZATION_CONFIG_KEY);
        if (this.whispercppDiarization.isSome()) {
            logger.debug("WhisperC++ diarization set to {}", this.whispercppDiarization);
        }
        this.whispercppTinyDiarization = OsgiUtil.getOptCfgAsBoolean((Dictionary)cc.getProperties(), (String)WHISPERCPP_TINY_DIARIZATION_CONFIG_KEY);
        if (this.whispercppTinyDiarization.isSome()) {
            logger.debug("WhisperC++ tiny diarization set to {}", this.whispercppTinyDiarization);
        }
        this.whispercppNoFallback = OsgiUtil.getOptCfgAsBoolean((Dictionary)cc.getProperties(), (String)WHISPERCPP_NO_FALLBACK_CONFIG_KEY);
        if (this.whispercppNoFallback.isSome()) {
            logger.debug("WhisperC++ no fallback set to {}", this.whispercppNoFallback);
        }
        logger.debug("Finished activating/updating speech-to-text service");
    }

    public SpeechToTextEngine.Result generateSubtitlesFile(File mediaFile, File workingDirectory, String language, Boolean translate) throws SpeechToTextEngineException {
        File vtt;
        String subtitleLanguage;
        if (!mediaFile.getPath().toLowerCase().endsWith(".wav")) {
            throw new SpeechToTextEngineException("WhisperC++ currently doesn't support any media extension other than wav");
        }
        String outputName = FilenameUtils.getBaseName((String)mediaFile.getAbsolutePath());
        ArrayList<String> command = new ArrayList<String>(List.of(this.whispercppExecutable, mediaFile.getAbsolutePath(), "--model", this.whispercppModel, "-ovtt", "-oj", "--output-file", FilenameUtils.concat((String)workingDirectory.getAbsolutePath(), (String)outputName)));
        if (this.whispercppBeamSize.isSome()) {
            command.add("-bs");
            command.add(Integer.toString((Integer)this.whispercppBeamSize.get()));
        }
        if (this.whispercppMaxLength.isSome()) {
            command.add("-ml");
            command.add(Integer.toString((Integer)this.whispercppMaxLength.get()));
        }
        if (this.whispercppThreads.isSome()) {
            command.add("-t");
            command.add(Integer.toString((Integer)this.whispercppThreads.get()));
        }
        if (this.whispercppProcessors.isSome()) {
            command.add("-p");
            command.add(Integer.toString((Integer)this.whispercppProcessors.get()));
        }
        if (this.whispercppMaxContext.isSome()) {
            command.add("-mc");
            command.add(Integer.toString((Integer)this.whispercppMaxContext.get()));
        }
        if (this.whispercppSplitOnWord.isSome() && ((Boolean)this.whispercppSplitOnWord.get()).booleanValue()) {
            command.add("-sow");
        }
        if (this.whispercppBestOf.isSome()) {
            command.add("-bo");
            command.add(Integer.toString((Integer)this.whispercppBestOf.get()));
        }
        if (this.whispercppWordThreshold.isSome()) {
            command.add("-wt");
            command.add(String.format(Locale.US, "%f", this.whispercppWordThreshold.get()));
        }
        if (this.whispercppEntropyThreshold.isSome()) {
            command.add("-et");
            command.add(String.format(Locale.US, "%f", this.whispercppEntropyThreshold.get()));
        }
        if (this.whispercppLogProbThreshold.isSome()) {
            command.add("-lpt");
            command.add(String.format(Locale.US, "%f", this.whispercppLogProbThreshold.get()));
        }
        if (this.whispercppDiarization.isSome() && ((Boolean)this.whispercppDiarization.get()).booleanValue()) {
            command.add("-di");
        }
        if (this.whispercppTinyDiarization.isSome() && ((Boolean)this.whispercppTinyDiarization.get()).booleanValue()) {
            command.add("-tdrz");
        }
        if (this.whispercppNoFallback.isSome() && ((Boolean)this.whispercppNoFallback.get()).booleanValue()) {
            command.add("-nf");
        }
        if (!language.isBlank()) {
            logger.info("Using language {} from workflows", (Object)language);
            command.add("--language");
            command.add(language);
        } else {
            logger.debug("Auto-detecting language");
            command.add("--language");
            command.add("auto");
        }
        if (translate.booleanValue()) {
            command.add("--translate");
            logger.info("Translation enabled");
            subtitleLanguage = "en";
        } else {
            subtitleLanguage = language;
        }
        logger.info("Executing WhisperC++'s transcription command: {}", command);
        Process process = null;
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(command);
            processBuilder.redirectErrorStream(true);
            processBuilder.redirectInput(ProcessBuilder.Redirect.PIPE).redirectError(ProcessBuilder.Redirect.PIPE).redirectOutput(ProcessBuilder.Redirect.PIPE);
            process = processBuilder.start();
            try (BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = in.readLine()) != null) {
                    logger.debug(line);
                }
            }
            int exitCode = process.waitFor();
            logger.info("WhisperC++ process finished with exit code {}", (Object)exitCode);
            if (exitCode != 0) {
                Object error = "";
                try (InputStream errorStream = process.getInputStream();){
                    error = "\n Output:\n" + IOUtils.toString((InputStream)errorStream, (Charset)StandardCharsets.UTF_8);
                }
                throw new SpeechToTextEngineException(String.format("WhisperC++ exited abnormally with status %d (command: %s)%s", exitCode, command, error));
            }
            vtt = new File(workingDirectory, outputName + ".vtt");
            if (!vtt.isFile()) {
                throw new SpeechToTextEngineException("WhisperC++ produced no output");
            }
            logger.info("Subtitles file generated successfully: {}", (Object)vtt);
        }
        catch (Exception e) {
            try {
                logger.info("Transcription failed closing WhisperC++ transcription process for: {}", (Object)mediaFile);
                throw new SpeechToTextEngineException((Throwable)e);
            }
            catch (Throwable throwable) {
                IoSupport.closeQuietly(process);
                throw throwable;
            }
        }
        IoSupport.closeQuietly((Process)process);
        if (subtitleLanguage.isBlank()) {
            JSONParser jsonParser = new JSONParser();
            File json = new File(workingDirectory, outputName + ".json");
            try {
                FileReader reader = new FileReader(json);
                Object obj = jsonParser.parse((Reader)reader);
                JSONObject jsonObject = (JSONObject)obj;
                JSONObject result = (JSONObject)jsonObject.get((Object)"result");
                subtitleLanguage = (String)result.get((Object)"language");
                logger.info("Language detected by WhisperC++: {}", (Object)subtitleLanguage);
            }
            catch (Exception e) {
                logger.info("Error reading WhisperC++ JSON file for: {}", (Object)mediaFile);
                throw new SpeechToTextEngineException((Throwable)e);
            }
            finally {
                FileUtils.deleteQuietly((File)json);
            }
        }
        return new SpeechToTextEngine.Result(subtitleLanguage, vtt);
    }
}

