/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.speechtotext.impl.endpoint;

import com.google.gson.JsonSyntaxException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.opencastproject.job.api.JaxbJob;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobProducer;
import org.opencastproject.rest.AbstractJobProducerEndpoint;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.speechtotext.api.SpeechToTextService;
import org.opencastproject.speechtotext.api.SpeechToTextServiceException;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@RestService(name="speechtotext", title="Speech to Text Service", abstractText="Create subtitles for video or audio clips.", notes={"The file format is WebVTT (*.vtt)"})
@Component(immediate=true, service={SpeechToTextServiceRestEndpoint.class}, property={"service.description=Speech to Text Service REST Endpoint", "opencast.service.type=org.opencastproject.speechtotext", "opencast.service.path=/speechtotext", "opencast.service.jobproducer=true"})
public class SpeechToTextServiceRestEndpoint
extends AbstractJobProducerEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(SpeechToTextServiceRestEndpoint.class);
    private SpeechToTextService speechToTextService;
    private ServiceRegistry serviceRegistry = null;

    @POST
    @Produces(value={"text/xml"})
    @Path(value="speechtotext")
    @RestQuery(name="speechtotext", description="Generates subtitles for media files with audio.", restParameters={@RestParameter(name="mediaFilePath", isRequired=true, type=RestParameter.Type.STRING, description="Location of to the media file."), @RestParameter(name="language", isRequired=false, type=RestParameter.Type.STRING, description="Language of the media file."), @RestParameter(name="translate", isRequired=false, type=RestParameter.Type.BOOLEAN, description="Enable translation to english")}, responses={@RestResponse(description="Subtitles created successfully", responseCode=200), @RestResponse(description="Invalid data", responseCode=400), @RestResponse(description="Internal error", responseCode=500)}, returnDescription="Returns the path to the generated subtitles file.")
    public Response speechToText(@FormParam(value="mediaFilePath") String mediaFilePath, @FormParam(value="language") String language, @FormParam(value="translate") Boolean translate) {
        try {
            logger.debug("Starting to generate subtitles.");
            Job job = this.speechToTextService.transcribe(new URI(mediaFilePath), language, translate);
            return Response.ok((Object)new JaxbJob(job)).build();
        }
        catch (JsonSyntaxException | NullPointerException | URISyntaxException e) {
            logger.debug("Invalid data passed to REST endpoint:\nmediaFilePath: {}\nlanguage: {}\ntranslate: {})", new Object[]{mediaFilePath, language, translate});
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (SpeechToTextServiceException e) {
            logger.error("Error generating subtitles from file {}", (Object)mediaFilePath, (Object)e);
            return Response.serverError().build();
        }
    }

    public JobProducer getService() {
        if (this.speechToTextService instanceof JobProducer) {
            logger.debug("get speech to text service");
            return (JobProducer)this.speechToTextService;
        }
        return null;
    }

    @Reference
    protected void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Reference
    public void setSpeechToTextService(SpeechToTextService speechToTextService) {
        this.speechToTextService = speechToTextService;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }
}

