/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.sox.impl.endpoint;

import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.job.api.JaxbJob;
import org.opencastproject.job.api.Job;
import org.opencastproject.job.api.JobProducer;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementParser;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.rest.AbstractJobProducerEndpoint;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.sox.api.SoxException;
import org.opencastproject.sox.api.SoxService;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@RestService(name="sox", title="Sox", abstractText="This service creates and augments Opencast media packages that include media tracks, metadata catalogs and attachments.", notes={"All paths above are relative to the REST endpoint base (something like http://your.server/files)", "If the service is down or not working it will return a status 503, this means the the underlying service is not working and is either restarting or has failed", "A status code 500 means a general failure has occurred which is not recoverable and was not anticipated. In other words, there is a bug! You should file an error report with your server logs from the time when the error occurred: <a href=\"https://github.com/opencast/opencast/issues\">Opencast Issue Tracker</a>"})
@Component(immediate=true, service={SoxRestService.class}, property={"service.description=SoX REST Endpoint", "opencast.service.type=org.opencastproject.sox", "opencast.service.path=/sox", "opencast.service.jobproducer=true"})
public class SoxRestService
extends AbstractJobProducerEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(SoxRestService.class);
    protected String docs;
    protected String serverUrl;
    protected SoxService soxService = null;
    protected ServiceRegistry serviceRegistry = null;

    @Reference
    protected void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Reference
    public void setSoxService(SoxService soxService) {
        this.soxService = soxService;
    }

    public void activate(ComponentContext cc) {
        this.serverUrl = cc == null || cc.getBundleContext().getProperty("org.opencastproject.server.url") == null ? "http://localhost:8080" : cc.getBundleContext().getProperty("org.opencastproject.server.url");
    }

    @POST
    @Path(value="analyze")
    @Produces(value={"text/xml"})
    @RestQuery(name="analyze", description="Starts an audio analyzing process", restParameters={@RestParameter(name="sourceAudioTrack", type=RestParameter.Type.TEXT, isRequired=true, description="The track just containing the audio stream")}, responses={@RestResponse(description="Results in an xml document containing the job for the analyzing task", responseCode=200), @RestResponse(description="If required parameters aren't set or if sourceAudioTrack isn't from the type Track", responseCode=400)}, returnDescription="")
    public Response analyze(@FormParam(value="sourceAudioTrack") String sourceAudioTrackAsXml) throws Exception {
        if (StringUtils.isBlank((CharSequence)sourceAudioTrackAsXml)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"sourceAudioTrack must not be null").build();
        }
        MediaPackageElement sourceTrack = MediaPackageElementParser.getFromXml((String)sourceAudioTrackAsXml);
        if (!Track.TYPE.equals((Object)sourceTrack.getElementType())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"sourceAudioTrack element must be of type track").build();
        }
        try {
            Job job = this.soxService.analyze((Track)sourceTrack);
            return Response.ok().entity((Object)new JaxbJob(job)).build();
        }
        catch (SoxException e) {
            logger.warn("Unable to analyze the audio track: " + e.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Path(value="normalize")
    @Produces(value={"text/xml"})
    @RestQuery(name="normalize", description="Starts audio normalization process", restParameters={@RestParameter(name="sourceAudioTrack", description="The track containing the audio stream", isRequired=true, type=RestParameter.Type.TEXT), @RestParameter(name="targetRmsLevDb", description="The target RMS level dB", isRequired=true, type=RestParameter.Type.INTEGER)}, responses={@RestResponse(description="Results in an xml document containing the job for the audio normalization task", responseCode=200), @RestResponse(description="If required parameters aren't set or if sourceAudioTrack isn't from the type Track", responseCode=400)}, returnDescription="")
    public Response normalize(@FormParam(value="sourceAudioTrack") String sourceAudioTrackAsXml, @FormParam(value="targetRmsLevDb") Float targetRmsLevDb) throws Exception {
        if (StringUtils.isBlank((CharSequence)sourceAudioTrackAsXml)) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"sourceAudioTrack must not be null").build();
        }
        if (targetRmsLevDb == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"targetRmsLevDb must not be null").build();
        }
        MediaPackageElement sourceTrack = MediaPackageElementParser.getFromXml((String)sourceAudioTrackAsXml);
        if (!Track.TYPE.equals((Object)sourceTrack.getElementType())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"sourceAudioTrack element must be of type track").build();
        }
        try {
            Job job = this.soxService.normalize((Track)sourceTrack, targetRmsLevDb);
            return Response.ok().entity((Object)new JaxbJob(job)).build();
        }
        catch (SoxException e) {
            logger.warn("Unable to normalize the track: " + e.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    public JobProducer getService() {
        if (this.soxService instanceof JobProducer) {
            return (JobProducer)this.soxService;
        }
        return null;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }
}

