/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.smil;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.mediapackage.Attachment;
import org.opencastproject.mediapackage.Catalog;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementBuilder;
import org.opencastproject.mediapackage.MediaPackageElementBuilderFactory;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.mediapackage.selector.TrackSelector;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.smil.api.SmilException;
import org.opencastproject.smil.api.SmilResponse;
import org.opencastproject.smil.api.SmilService;
import org.opencastproject.smil.entity.api.Smil;
import org.opencastproject.smil.entity.media.container.api.SmilMediaContainer;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationInstance;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Cut Marks To Smil Operation Handler", "workflow.operation=cut-marks-to-smil"})
public class CutMarksToSmilWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    private static final String SOURCE_MEDIA_FLAVORS = "source-media-flavors";
    private static final String SOURCE_JSON_FLAVOR = "source-json-flavor";
    private static final String TARGET_SMIL_FLAVOR = "target-smil-flavor";
    private static final String TARGET_TAGS = "target-tags";
    private static final String CUTTING_SMIL_NAME = "prepared_cutting_smil";
    private static final Logger logger = LoggerFactory.getLogger(CutMarksToSmilWorkflowOperationHandler.class);
    private Workspace workspace = null;
    private SmilService smilService;
    private static final Gson gson = new Gson();
    private static final Type timesListType = new TypeToken<List<Times>>(){}.getType();

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Reference
    public void setSmilService(SmilService smilService) {
        this.smilService = smilService;
    }

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        Smil smil;
        List cutMarks;
        logger.info("Running cut marks to smil workflow operation on workflow {}", (Object)workflowInstance.getId());
        WorkflowOperationInstance operation = workflowInstance.getCurrentOperation();
        MediaPackage mediaPackage = (MediaPackage)workflowInstance.getMediaPackage().clone();
        MediaPackageElementFlavor jsonFlavor = MediaPackageElementFlavor.parseFlavor((String)this.getConfig(operation, SOURCE_JSON_FLAVOR));
        MediaPackageElementFlavor targetSmilFlavor = MediaPackageElementFlavor.parseFlavor((String)this.getConfig(operation, TARGET_SMIL_FLAVOR));
        String flavorNames = operation.getConfiguration(SOURCE_MEDIA_FLAVORS);
        ArrayList<MediaPackageElementFlavor> flavors = new ArrayList<MediaPackageElementFlavor>();
        for (String flavorName : this.asList(flavorNames)) {
            flavors.add(MediaPackageElementFlavor.parseFlavor((String)flavorName));
        }
        String targetTagsOption = StringUtils.trimToNull((String)operation.getConfiguration(TARGET_TAGS));
        List targetTags = this.asList(targetTagsOption);
        Attachment[] cutMarksElements = mediaPackage.getAttachments(jsonFlavor);
        if (cutMarksElements.length < 1) {
            logger.debug("No cut marks found as attachment. Falling back to catalogs\u2026");
            cutMarksElements = mediaPackage.getCatalogs(jsonFlavor);
        }
        if (cutMarksElements.length < 1) {
            logger.warn("No cut marks with source flavor {} found. Skipping\u2026", (Object)jsonFlavor);
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.SKIP);
        }
        if (cutMarksElements.length > 1) {
            throw new WorkflowOperationException(String.format("More than one cut marks element with source flavor %s found! Make sure there is only one.", jsonFlavor));
        }
        Attachment jsonWithTimes = cutMarksElements[0];
        try (BufferedReader reader = new BufferedReader(new FileReader(this.getMediaPackageElementPath((MediaPackageElement)jsonWithTimes)));){
            cutMarks = (List)gson.fromJson((Reader)reader, timesListType);
        }
        catch (Exception e) {
            throw new WorkflowOperationException("Could not read JSON", (Throwable)e);
        }
        if (cutMarks.size() < 1) {
            logger.warn("Source JSON did not contain any timestamps! Skipping...");
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.SKIP);
        }
        for (Object entry : cutMarks) {
            logger.debug("Entry begin={}, duration={}", (Object)((Times)entry).begin, (Object)((Times)entry).duration);
            if (((Times)entry).begin >= 0L && ((Times)entry).duration >= 0L) continue;
            throw new WorkflowOperationException("Times may not be negative.");
        }
        logger.info("Get tracks from media package");
        ArrayList tracksFromFlavors = new ArrayList();
        for (MediaPackageElementFlavor flavor : flavors) {
            logger.debug("Trying to get tracks with flavor {}", (Object)flavor);
            TrackSelector trackSelector = new TrackSelector();
            trackSelector.addFlavor(flavor);
            Collection tracks = trackSelector.select(mediaPackage, false);
            logger.debug("Found {} tracks with flavor {}", (Object)tracks.size(), (Object)flavor);
            tracksFromFlavors.addAll(tracks);
        }
        if (tracksFromFlavors.isEmpty()) {
            logger.warn("No track with given flavors. Skipping\u2026");
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.SKIP);
        }
        long shortestDuration = Long.MAX_VALUE;
        for (Track track : tracksFromFlavors) {
            if (track.getDuration() >= shortestDuration) continue;
            shortestDuration = track.getDuration();
        }
        ListIterator iter = cutMarks.listIterator();
        while (iter.hasNext()) {
            long begin = ((Times)iter.next()).begin;
            if (begin <= shortestDuration) continue;
            logger.info("Skipped mark with begin: {}, ", (Object)begin);
            iter.remove();
        }
        if (cutMarks.size() < 1) {
            logger.warn("No timestamps are valid for the given tracks! Skipping...");
            return this.createResult(mediaPackage, WorkflowOperationResult.Action.SKIP);
        }
        try {
            SmilResponse smilResponse = this.smilService.createNewSmil(mediaPackage);
            logger.info("Start adding tracks");
            for (Times mark : cutMarks) {
                smilResponse = this.smilService.addParallel(smilResponse.getSmil());
                SmilMediaContainer par = (SmilMediaContainer)smilResponse.getEntity();
                logger.debug("Segment begin: {}; Segment duration: {}", (Object)mark.begin, (Object)mark.duration);
                smilResponse = this.smilService.addClips(smilResponse.getSmil(), par.getId(), tracksFromFlavors.toArray(new Track[0]), mark.begin.longValue(), mark.duration.longValue());
            }
            smil = smilResponse.getSmil();
            logger.info("Done adding tracks");
        }
        catch (SmilException e) {
            throw new WorkflowOperationException("Failed to create SMIL Catalog", (Throwable)e);
        }
        try (InputStream is = IOUtils.toInputStream((String)smil.toXML(), (String)"UTF-8");){
            URI smilURI = this.workspace.put(mediaPackage.getIdentifier().toString(), smil.getId(), CUTTING_SMIL_NAME, is);
            MediaPackageElementBuilder mpeBuilder = MediaPackageElementBuilderFactory.newInstance().newElementBuilder();
            Catalog catalog = (Catalog)mpeBuilder.elementFromURI(smilURI, MediaPackageElement.Type.Catalog, targetSmilFlavor);
            catalog.setIdentifier(smil.getId());
            for (String tag : targetTags) {
                catalog.addTag(tag);
            }
            mediaPackage.add(catalog);
        }
        catch (IOException | JAXBException | SAXException e) {
            throw new WorkflowOperationException("Failed to parse crated SMIL Catalog", e);
        }
        WorkflowOperationResult result = this.createResult(mediaPackage, WorkflowOperationResult.Action.CONTINUE);
        logger.debug("Cut marks to smil operation completed");
        return result;
    }

    private String getMediaPackageElementPath(MediaPackageElement mpe) throws WorkflowOperationException {
        File mediaFile;
        try {
            mediaFile = this.workspace.get(mpe.getURI());
        }
        catch (IOException | NotFoundException e) {
            throw new WorkflowOperationException("Error finding the media file in the workspace", e);
        }
        return mediaFile.getAbsolutePath();
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }

    static class Times {
        private Long begin;
        private Long duration;

        Times() {
        }
    }
}

