/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.smil.impl;

import java.io.File;
import java.util.ArrayList;
import javax.xml.bind.JAXBException;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.Track;
import org.opencastproject.smil.api.SmilException;
import org.opencastproject.smil.api.SmilResponse;
import org.opencastproject.smil.api.SmilService;
import org.opencastproject.smil.entity.SmilBodyImpl;
import org.opencastproject.smil.entity.SmilHeadImpl;
import org.opencastproject.smil.entity.SmilImpl;
import org.opencastproject.smil.entity.SmilObjectImpl;
import org.opencastproject.smil.entity.api.Smil;
import org.opencastproject.smil.entity.api.SmilMeta;
import org.opencastproject.smil.entity.api.SmilObject;
import org.opencastproject.smil.entity.media.container.SmilMediaParallelImpl;
import org.opencastproject.smil.entity.media.container.SmilMediaSequenceImpl;
import org.opencastproject.smil.entity.media.element.SmilMediaAudioImpl;
import org.opencastproject.smil.entity.media.element.SmilMediaElementImpl;
import org.opencastproject.smil.entity.media.element.SmilMediaReferenceImpl;
import org.opencastproject.smil.entity.media.element.SmilMediaVideoImpl;
import org.opencastproject.smil.entity.media.param.SmilMediaParamGroupImpl;
import org.opencastproject.smil.entity.media.param.api.SmilMediaParam;
import org.opencastproject.smil.entity.media.param.api.SmilMediaParamGroup;
import org.opencastproject.smil.impl.SmilResponseImpl;
import org.osgi.service.component.annotations.Component;

@Component(property={"service.description=SMIL Service"}, service={SmilService.class})
public class SmilServiceImpl
implements SmilService {
    public SmilResponse createNewSmil() {
        return new SmilResponseImpl(new SmilImpl());
    }

    public SmilResponse createNewSmil(MediaPackage mediaPackage) {
        SmilImpl smil = new SmilImpl();
        ((SmilHeadImpl)smil.getHead()).addMeta("media-package-id", mediaPackage.getIdentifier().toString());
        return new SmilResponseImpl(smil);
    }

    public SmilResponse addParallel(Smil smil) throws SmilException {
        return this.addParallel(smil, smil.getBody().getId());
    }

    public SmilResponse addParallel(Smil smil, String parentId) throws SmilException {
        SmilMediaParallelImpl par = new SmilMediaParallelImpl();
        ((SmilBodyImpl)smil.getBody()).addMediaElement(par, parentId);
        return new SmilResponseImpl(smil, par);
    }

    public SmilResponse addSequence(Smil smil) throws SmilException {
        return this.addSequence(smil, smil.getBody().getId());
    }

    public SmilResponse addSequence(Smil smil, String parentId) throws SmilException {
        SmilMediaSequenceImpl seq = new SmilMediaSequenceImpl();
        ((SmilBodyImpl)smil.getBody()).addMediaElement(seq, parentId);
        return new SmilResponseImpl(smil, seq);
    }

    public SmilResponse addClip(Smil smil, String parentId, Track track, long start, long duration) throws SmilException {
        return this.addClip(smil, parentId, track, start, duration, null);
    }

    public SmilResponse addClip(Smil smil, String parentId, Track track, long start, long duration, String pgId) throws SmilException {
        boolean newTrack;
        if (start < 0L) {
            throw new SmilException("Start position should be positive.");
        }
        if (duration < 0L) {
            throw new SmilException("Duration should be positive.");
        }
        if (track.getURI() == null) {
            throw new SmilException("Track URI isn't set.");
        }
        if (track.getFlavor() == null) {
            throw new SmilException("Track flavor isn't set.");
        }
        if (track.getDuration() != null) {
            if (!track.hasAudio() && !track.hasVideo()) {
                throw new SmilException("Track should have at least one audio or video stream.");
            }
            if (start >= track.getDuration()) {
                throw new SmilException("Start value is bigger than track length.");
            }
            if (start + duration > track.getDuration()) {
                duration = track.getDuration() - start;
            }
        }
        SmilMediaParamGroup trackParamGroup = null;
        for (SmilMediaParamGroup paramGroup : smil.getHead().getParamGroups()) {
            if (pgId != null && paramGroup.getId().equals(pgId.trim())) {
                trackParamGroup = paramGroup;
                break;
            }
            SmilMediaParam param = ((SmilMediaParamGroupImpl)paramGroup).getParamByName("track-id");
            if (param == null || !param.getValue().equals(track.getIdentifier())) continue;
            trackParamGroup = paramGroup;
            break;
        }
        boolean bl = newTrack = trackParamGroup == null;
        if (newTrack) {
            trackParamGroup = new SmilMediaParamGroupImpl();
            ((SmilMediaParamGroupImpl)trackParamGroup).addParam("track-id", track.getIdentifier());
            ((SmilMediaParamGroupImpl)trackParamGroup).addParam("track-src", track.getURI().toString());
            ((SmilMediaParamGroupImpl)trackParamGroup).addParam("track-flavor", track.getFlavor().toString());
            ((SmilHeadImpl)smil.getHead()).addParamGroup(trackParamGroup);
        }
        SmilMeta durationMeta = null;
        for (SmilMeta meta : smil.getHead().getMetas()) {
            if (!"track-duration".equals(meta.getName())) continue;
            durationMeta = meta;
            break;
        }
        if (track.getDuration() != null) {
            if (durationMeta == null) {
                ((SmilHeadImpl)smil.getHead()).addMeta("track-duration", String.format("%dms", track.getDuration()));
            } else {
                long durationOld = Long.parseLong(durationMeta.getContent().replace("ms", ""));
                if (track.getDuration() > durationOld) {
                    ((SmilHeadImpl)smil.getHead()).addMeta("track-duration", String.format("%dms", track.getDuration()));
                }
            }
        }
        SmilMediaElementImpl media = null;
        media = track.hasVideo() ? new SmilMediaVideoImpl(track.getURI(), start, start + duration) : (track.hasAudio() ? new SmilMediaAudioImpl(track.getURI(), start, start + duration) : new SmilMediaReferenceImpl(track.getURI(), start, start + duration));
        media.setParamGroup(trackParamGroup.getId());
        if (parentId == null || "".equals(parentId)) {
            parentId = smil.getBody().getId();
        }
        ((SmilBodyImpl)smil.getBody()).addMediaElement(media, parentId);
        if (newTrack) {
            return new SmilResponseImpl(smil, new SmilObject[]{media, trackParamGroup});
        }
        return new SmilResponseImpl(smil, media);
    }

    public SmilResponse addClips(Smil smil, String parentId, Track[] tracks, long start, long duration) throws SmilException {
        ArrayList<SmilObject> trackEntities = new ArrayList<SmilObject>(tracks.length);
        ArrayList<SmilObject> otherEntities = new ArrayList<SmilObject>(tracks.length);
        for (Track track : tracks) {
            SmilResponse response = this.addClip(smil, parentId, track, start, duration);
            if (response.getEntitiesCount() == 1) {
                trackEntities.add(response.getEntity());
                continue;
            }
            trackEntities.add(response.getEntities()[0]);
            for (int e = 1; e < response.getEntitiesCount(); ++e) {
                otherEntities.add(response.getEntities()[e]);
            }
        }
        SmilObject[] entities = new SmilObject[trackEntities.size() + otherEntities.size()];
        for (int e = 0; e < entities.length; ++e) {
            entities[e] = e < trackEntities.size() ? (SmilObject)trackEntities.get(e) : (SmilObject)otherEntities.get(e - trackEntities.size());
        }
        return new SmilResponseImpl(smil, entities);
    }

    public SmilResponse addMeta(Smil smil, String name, String content) {
        SmilMeta meta = ((SmilHeadImpl)smil.getHead()).addMeta(name, content);
        return new SmilResponseImpl(smil, meta);
    }

    public SmilResponse removeSmilElement(Smil smil, String elementId) {
        SmilObject removed = ((SmilObjectImpl)((Object)smil)).removeElement(elementId);
        if (removed == null) {
            return new SmilResponseImpl(smil);
        }
        return new SmilResponseImpl(smil, removed);
    }

    public SmilResponse fromXml(String smilXml) throws SmilException {
        try {
            return new SmilResponseImpl(SmilImpl.fromXML(smilXml));
        }
        catch (JAXBException ex) {
            throw new SmilException("Parsing SMIL document failed.", (Throwable)ex);
        }
    }

    public SmilResponse fromXml(File smilXmlFile) throws SmilException {
        try {
            return new SmilResponseImpl(SmilImpl.fromXML(smilXmlFile));
        }
        catch (JAXBException ex) {
            throw new SmilException("Parsing SMIL document failed.", (Throwable)ex);
        }
    }
}

