/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.smil.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.io.IOUtils;
import org.opencastproject.smil.api.SmilException;
import org.opencastproject.smil.api.SmilResponse;
import org.opencastproject.smil.entity.SmilImpl;
import org.opencastproject.smil.entity.SmilObjectImpl;
import org.opencastproject.smil.entity.api.Smil;
import org.opencastproject.smil.entity.api.SmilObject;
import org.opencastproject.util.XmlSafeParser;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlRootElement(name="smil-response", namespace="http://smil.opencastproject.org")
public class SmilResponseImpl
implements SmilResponse {
    private Smil smil;
    private SmilObject[] entities;

    private SmilResponseImpl() {
        this.smil = null;
        this.entities = null;
    }

    public SmilResponseImpl(Smil smil) {
        this(smil, new SmilObject[0]);
    }

    public SmilResponseImpl(Smil smil, SmilObject entity) {
        this(smil, new SmilObject[]{entity});
    }

    public SmilResponseImpl(Smil smil, SmilObject[] entities) {
        this.smil = smil;
        this.entities = entities;
    }

    @XmlElement(type=SmilImpl.class, required=true)
    public Smil getSmil() {
        return this.smil;
    }

    private void setSmil(Smil smil) {
        this.smil = smil;
    }

    public int getEntitiesCount() {
        if (this.entities == null) {
            return 0;
        }
        return this.entities.length;
    }

    public SmilObject getEntity() throws SmilException {
        if (this.entities.length == 0) {
            throw new SmilException("There is no entity.");
        }
        if (this.entities.length > 1) {
            throw new SmilException("There is more than one entity.");
        }
        return this.entities[0];
    }

    public SmilObject[] getEntities() throws SmilException {
        if (this.entities.length == 0) {
            throw new SmilException("There are no entities.");
        }
        return this.entities;
    }

    public String toXml() throws JAXBException {
        StringWriter writer = new StringWriter();
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{SmilResponseImpl.class});
        Marshaller marshaller = ctx.createMarshaller();
        marshaller.marshal((Object)this, (Writer)writer);
        return writer.toString();
    }

    public static SmilResponse fromXml(String smilResponseXml) throws JAXBException {
        InputStream smilStream = IOUtils.toInputStream((String)smilResponseXml);
        try {
            SmilResponse smilResponse = SmilResponseImpl.fromXml(smilStream);
            return smilResponse;
        }
        finally {
            IOUtils.closeQuietly((InputStream)smilStream);
        }
    }

    protected static SmilResponse fromXml(InputStream smilResponseXml) throws JAXBException {
        JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{SmilResponseImpl.class});
        Unmarshaller unmarshaller = ctx.createUnmarshaller();
        try {
            return (SmilResponse)unmarshaller.unmarshal((Node)XmlSafeParser.parse((InputStream)smilResponseXml));
        }
        catch (IOException | SAXException e) {
            throw new JAXBException((Throwable)e);
        }
    }

    @XmlElementRef
    private SmilResponseEntity<SmilObject>[] getResponseEntities() {
        SmilResponseEntity[] entitiesWrapped = new SmilResponseEntity[this.entities.length];
        for (int i = 0; i < this.entities.length; ++i) {
            entitiesWrapped[i] = new SmilResponseEntity<SmilObject>(this.entities[i]);
        }
        return entitiesWrapped;
    }

    private void setResponseEntities(SmilResponseEntity<SmilObject>[] entities) {
        this.entities = new SmilObject[entities.length];
        for (int e = 0; e < entities.length; ++e) {
            this.entities[e] = entities[e].getEntity();
        }
    }

    @XmlRootElement(name="entity", namespace="http://smil.opencastproject.org")
    private static class SmilResponseEntity<SmilObject> {
        private SmilObject entity;

        SmilResponseEntity() {
        }

        SmilResponseEntity(SmilObject entity) {
            this.entity = entity;
        }

        @XmlElementRef(type=SmilObjectImpl.class)
        public SmilObject getEntity() {
            return this.entity;
        }

        private void setEntity(SmilObject entity) {
            this.entity = entity;
        }
    }
}

