/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.smil.entity.media.container;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlSeeAlso;
import org.opencastproject.smil.api.SmilException;
import org.opencastproject.smil.entity.SmilObjectImpl;
import org.opencastproject.smil.entity.api.SmilObject;
import org.opencastproject.smil.entity.media.SmilMediaObjectImpl;
import org.opencastproject.smil.entity.media.api.SmilMediaObject;
import org.opencastproject.smil.entity.media.container.SmilMediaParallelImpl;
import org.opencastproject.smil.entity.media.container.SmilMediaSequenceImpl;
import org.opencastproject.smil.entity.media.container.api.SmilMediaContainer;

@XmlSeeAlso(value={SmilMediaParallelImpl.class, SmilMediaSequenceImpl.class})
public abstract class SmilMediaContainerImpl
extends SmilMediaObjectImpl
implements SmilMediaContainer {
    private List<SmilMediaObject> elements = new LinkedList<SmilMediaObject>();

    @Override
    public boolean isContainer() {
        return true;
    }

    @Override
    public List<SmilMediaObject> getElements() {
        return Collections.unmodifiableList(this.elements);
    }

    @XmlElementRef(type=SmilMediaObjectImpl.class)
    protected List<SmilMediaObject> getElementsList() {
        return this.elements;
    }

    protected void setElementsList(List<SmilMediaObject> elements) {
        this.elements = elements;
    }

    @Override
    public abstract SmilMediaContainer.ContainerType getContainerType();

    @Override
    public boolean isParentOf(String childId) {
        for (SmilMediaObject child : this.elements) {
            if (child.getId().equals(childId)) {
                return true;
            }
            if (!child.isContainer() || !((SmilMediaContainer)child).isParentOf(childId)) continue;
            return true;
        }
        return false;
    }

    public void addMediaObject(SmilMediaObject mediaObject, String parentId) throws SmilException {
        if (!this.getId().equals(parentId)) {
            for (SmilMediaObject child : this.elements) {
                if (!child.isContainer() || !((SmilMediaContainer)child).isParentOf(parentId)) continue;
                ((SmilMediaContainerImpl)child).addMediaObject(mediaObject, parentId);
            }
            throw new SmilException("There is no element with id " + parentId);
        }
        this.elements.add(mediaObject);
    }

    @Override
    public SmilObject getElementOrNull(String elementId) {
        if (this.getId().equals(elementId)) {
            return this;
        }
        for (SmilMediaObject media : this.getElements()) {
            SmilObject element = ((SmilMediaObjectImpl)media).getElementOrNull(elementId);
            if (element == null) continue;
            return element;
        }
        return null;
    }

    @Override
    public void putAllChilds(List<SmilObject> elements) {
        for (SmilObject smilObject : this.getElements()) {
            elements.add(smilObject);
            ((SmilObjectImpl)smilObject).putAllChilds(elements);
        }
    }

    @Override
    public SmilObject removeElement(String elementId) {
        SmilObject child = null;
        for (SmilObject smilObject : this.elements) {
            if (smilObject.getId().equals(elementId)) {
                child = smilObject;
                break;
            }
            SmilObject removed = ((SmilObjectImpl)smilObject).removeElement(elementId);
            if (removed == null) continue;
            return removed;
        }
        if (child != null) {
            this.elements.remove(child);
        }
        return child;
    }
}

