/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.smil.entity;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import org.opencastproject.smil.entity.SmilMetaImpl;
import org.opencastproject.smil.entity.SmilObjectImpl;
import org.opencastproject.smil.entity.api.SmilHead;
import org.opencastproject.smil.entity.api.SmilMeta;
import org.opencastproject.smil.entity.api.SmilObject;
import org.opencastproject.smil.entity.media.param.SmilMediaParamGroupImpl;
import org.opencastproject.smil.entity.media.param.api.SmilMediaParam;
import org.opencastproject.smil.entity.media.param.api.SmilMediaParamGroup;

@XmlRootElement(name="head")
public class SmilHeadImpl
extends SmilObjectImpl
implements SmilHead {
    private List<SmilMeta> metas = new LinkedList<SmilMeta>();
    private List<SmilMediaParamGroup> paramGroups = new LinkedList<SmilMediaParamGroup>();

    @Override
    public List<SmilMeta> getMetas() {
        return Collections.unmodifiableList(this.metas);
    }

    @XmlElementRef(type=SmilMetaImpl.class)
    protected List<SmilMeta> getMetasList() {
        return this.metas;
    }

    protected void setMetasList(List<SmilMeta> metas) {
        this.metas = metas;
    }

    @Override
    public List<SmilMediaParamGroup> getParamGroups() {
        return Collections.unmodifiableList(this.paramGroups);
    }

    @XmlElementRef(type=SmilMediaParamGroupImpl.class)
    protected List<SmilMediaParamGroup> getParamGroupsList() {
        return this.paramGroups;
    }

    protected void setParamGroupsList(List<SmilMediaParamGroup> paramGroups) {
        this.paramGroups = paramGroups;
    }

    @Override
    protected String getIdPrefix() {
        return "h";
    }

    @Override
    public SmilObject removeElement(String elementId) {
        SmilObject child = null;
        for (SmilObject smilObject : this.metas) {
            if (!smilObject.getId().equals(elementId)) continue;
            child = smilObject;
            break;
        }
        if (child != null) {
            this.metas.remove(child);
            return child;
        }
        for (SmilObject smilObject : this.paramGroups) {
            if (smilObject.getId().equals(elementId)) {
                child = smilObject;
                break;
            }
            SmilObject removedElement = ((SmilMediaParamGroupImpl)smilObject).removeElement(elementId);
            if (removedElement == null) continue;
            return removedElement;
        }
        if (child != null) {
            this.paramGroups.remove(child);
            return child;
        }
        return null;
    }

    public void clear() {
        this.metas.clear();
        this.paramGroups.clear();
    }

    public SmilMeta getMetaByName(String name) {
        for (SmilMeta m : this.metas) {
            if (!m.getName().equals(name)) continue;
            return m;
        }
        return null;
    }

    public SmilMeta addMeta(String name, String content) {
        SmilMeta meta = this.getMetaByName(name);
        if (meta != null) {
            ((SmilMetaImpl)meta).setName(name);
            ((SmilMetaImpl)meta).setContent(content);
        } else {
            meta = new SmilMetaImpl(name, content);
            this.metas.add(meta);
        }
        return meta;
    }

    public void addMeta(SmilMeta meta) {
        SmilObject m = this.getElementOrNull(meta.getId());
        if (m != null && m instanceof SmilMeta) {
            ((SmilMetaImpl)m).setName(meta.getName());
            ((SmilMetaImpl)m).setContent(meta.getContent());
        } else {
            this.metas.add(meta);
        }
    }

    public void removeMetaByName(String name) {
        SmilMeta metaFound = this.getMetaByName(name);
        if (metaFound != null) {
            this.metas.remove(metaFound);
        }
    }

    public void addParamGroup(SmilMediaParamGroup group) {
        if (group == null) {
            return;
        }
        SmilObject g = this.getElementOrNull(group.getId());
        if (g != null && g instanceof SmilMediaParamGroup) {
            for (SmilMediaParam p : group.getParams()) {
                ((SmilMediaParamGroupImpl)g).addParam(p);
            }
        } else {
            this.paramGroups.add(group);
        }
    }

    public void removeParamGroup(SmilMediaParamGroup group) {
        SmilObject g = this.getElementOrNull(group.getId());
        if (g != null && g instanceof SmilMediaParamGroup) {
            this.paramGroups.remove(g);
        }
    }

    @Override
    public SmilObject getElementOrNull(String elementId) {
        if (this.getId().equals(elementId)) {
            return this;
        }
        SmilObject element = null;
        for (SmilMeta meta : this.metas) {
            element = ((SmilMetaImpl)meta).getElementOrNull(elementId);
            if (element == null) continue;
            return element;
        }
        for (SmilMediaParamGroup paramGroup : this.paramGroups) {
            element = ((SmilMediaParamGroupImpl)paramGroup).getElementOrNull(elementId);
            if (element == null) continue;
            return element;
        }
        return null;
    }

    @Override
    public void putAllChilds(List<SmilObject> elements) {
        for (SmilObject smilObject : this.getMetas()) {
            elements.add(smilObject);
            ((SmilObjectImpl)smilObject).putAllChilds(elements);
        }
        for (SmilObject smilObject : this.getParamGroups()) {
            elements.add(smilObject);
            ((SmilObjectImpl)smilObject).putAllChilds(elements);
        }
    }
}

