/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.smil.api.util;

import com.android.mms.dom.smil.parser.SmilXmlParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.io.IOUtils;
import org.opencastproject.mediapackage.Catalog;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageElement;
import org.opencastproject.mediapackage.MediaPackageElementFlavor;
import org.opencastproject.mediapackage.selector.CatalogSelector;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.XmlUtil;
import org.opencastproject.util.data.Either;
import org.opencastproject.util.data.functions.Misc;
import org.opencastproject.workspace.api.Workspace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.smil.SMILDocument;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class SmilUtil {
    private static final Logger logger = LoggerFactory.getLogger(SmilUtil.class);
    public static final String SMIL_NODE_NAME = "smil";
    public static final String SMIL_NS_URI = "http://www.w3.org/ns/SMIL";

    private SmilUtil() {
    }

    public static Document loadSmilDocument(InputStream in, MediaPackageElement mpe) {
        try {
            Either eitherDocument = XmlUtil.parseNs((InputSource)new InputSource(in));
            if (eitherDocument.isRight()) {
                return (Document)eitherDocument.right().value();
            }
            throw (Exception)eitherDocument.left().value();
        }
        catch (Exception e) {
            logger.warn("Unable to load smil document from catalog '{}'", (Object)mpe, (Object)e);
            return (Document)Misc.chuck((Throwable)e);
        }
    }

    public static Document createSmil() {
        Document smilDocument = XmlUtil.newDocument();
        smilDocument.setXmlVersion("1.1");
        Element smil = smilDocument.createElementNS(SMIL_NS_URI, SMIL_NODE_NAME);
        smil.setAttribute("version", "3.0");
        smilDocument.appendChild(smil);
        Element head = smilDocument.createElement("head");
        smil.appendChild(head);
        Element body = smilDocument.createElement("body");
        smil.appendChild(body);
        Element parallel = smilDocument.createElement("par");
        parallel.setAttribute("dur", "0ms");
        body.appendChild(parallel);
        return smilDocument;
    }

    public static Document addTrack(Document smilDocument, TrackType trackType, boolean hasVideo, long startTime, long duration, URI uri, String trackId) {
        Node sequence;
        Element parallel = (Element)smilDocument.getElementsByTagName("par").item(0);
        if (parallel.getChildNodes().getLength() == 0) {
            Element presenterSeq = smilDocument.createElement("seq");
            parallel.appendChild(presenterSeq);
            Element presentationSeq = smilDocument.createElement("seq");
            parallel.appendChild(presentationSeq);
        }
        String trackDurationString = parallel.getAttribute("dur");
        Long oldTrackDuration = Long.parseLong(trackDurationString.substring(0, trackDurationString.indexOf("ms")));
        Long newTrackDuration = startTime + duration;
        if (newTrackDuration > oldTrackDuration) {
            parallel.setAttribute("dur", newTrackDuration + "ms");
        }
        switch (trackType) {
            case PRESENTER: {
                sequence = parallel.getChildNodes().item(0);
                break;
            }
            case PRESENTATION: {
                sequence = parallel.getChildNodes().item(1);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown track type " + trackType.toString());
            }
        }
        Element element = smilDocument.createElement(hasVideo ? "video" : "audio");
        element.setAttribute("begin", Long.toString(startTime) + "ms");
        element.setAttribute("dur", Long.toString(duration) + "ms");
        element.setAttribute("src", URIUtil.getPath((String)uri.toString()));
        if (trackId != null) {
            element.setAttribute("xml:id", trackId);
        }
        sequence.appendChild(element);
        return smilDocument;
    }

    public static SMILDocument getSmilDocumentFromMediaPackage(MediaPackage mp, MediaPackageElementFlavor smilFlavor, Workspace workspace) throws IOException, SAXException, NotFoundException {
        CatalogSelector smilSelector = new CatalogSelector();
        smilSelector.addFlavor(smilFlavor);
        Collection smilCatalog = smilSelector.select(mp, false);
        if (smilCatalog.size() == 1) {
            return SmilUtil.getSmilDocument((Catalog)smilCatalog.iterator().next(), workspace);
        }
        logger.error("More or less than one smil catalog found: {}", (Object)smilCatalog);
        throw new IllegalStateException("More or less than one smil catalog found!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SMILDocument getSmilDocument(Catalog smilCatalog, Workspace workspace) throws NotFoundException, IOException, SAXException {
        SMILDocument sMILDocument;
        FileInputStream in = null;
        try {
            File smilXmlFile = workspace.get(smilCatalog.getURI());
            SmilXmlParser smilParser = new SmilXmlParser();
            in = new FileInputStream(smilXmlFile);
            sMILDocument = smilParser.parse((InputStream)in);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        return sMILDocument;
    }

    public static enum TrackType {
        PRESENTER,
        PRESENTATION;

    }
}

