/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.silencedetection.api;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.opencastproject.silencedetection.api.MediaSegment;
import org.opencastproject.util.XmlSafeParser;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@XmlRootElement(name="media-segments")
@XmlAccessorType(value=XmlAccessType.NONE)
public class MediaSegments {
    @XmlElement(name="trackId", required=true)
    private String trackId;
    @XmlElement(name="filePath")
    private String filePath;
    @XmlElementWrapper(name="segments", required=true, nillable=false)
    @XmlElement(name="segment")
    private List<MediaSegment> mediaSegments;

    public MediaSegments() {
        this(null, null, null);
    }

    public MediaSegments(String trackId, String filePath, List<MediaSegment> mediaSegments) {
        this.trackId = trackId;
        this.filePath = filePath;
        this.mediaSegments = mediaSegments;
    }

    public List<MediaSegment> getMediaSegments() {
        return this.mediaSegments;
    }

    public String getTrackId() {
        return this.trackId;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String toXml() throws JAXBException {
        StringWriter sw = new StringWriter();
        JAXBContext jctx = JAXBContext.newInstance((Class[])new Class[]{MediaSegments.class});
        Marshaller mediaSegmentsMarshaller = jctx.createMarshaller();
        mediaSegmentsMarshaller.marshal((Object)this, (Writer)sw);
        return sw.toString();
    }

    public static MediaSegments fromXml(String mediaSegmentsXml) throws JAXBException {
        MediaSegments mediaSegments = null;
        JAXBContext jctx = JAXBContext.newInstance((Class[])new Class[]{MediaSegments.class});
        Unmarshaller unmarshaller = jctx.createUnmarshaller();
        try (StringReader sr = new StringReader(mediaSegmentsXml);){
            InputSource is = new InputSource(sr);
            mediaSegments = (MediaSegments)unmarshaller.unmarshal((Node)XmlSafeParser.parse((InputSource)is));
        }
        catch (IOException | SAXException e) {
            throw new JAXBException((Throwable)e);
        }
        return mediaSegments;
    }
}

