/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.assetmanager.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.opencastproject.assetmanager.api.AssetManager;
import org.opencastproject.assetmanager.api.Snapshot;
import org.opencastproject.assetmanager.api.fn.Enrichments;
import org.opencastproject.assetmanager.api.query.AQueryBuilder;
import org.opencastproject.assetmanager.api.query.AResult;
import org.opencastproject.assetmanager.api.query.Target;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.workflow.api.ConfiguredWorkflow;
import org.opencastproject.workflow.api.WorkflowDatabaseException;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowParsingException;
import org.opencastproject.workflow.api.WorkflowService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Workflows {
    private static final Logger logger = LoggerFactory.getLogger(Workflows.class);
    private final AssetManager am;
    private final WorkflowService wfs;

    public Workflows(AssetManager am, WorkflowService wfs) {
        this.am = am;
        this.wfs = wfs;
    }

    public List<WorkflowInstance> applyWorkflowToLatestVersion(Iterable<String> mpIds, ConfiguredWorkflow wf) {
        ArrayList<WorkflowInstance> result = new ArrayList<WorkflowInstance>();
        for (String mpId : mpIds) {
            List<Snapshot> snapshots = this.findLatestSnapshots(mpId);
            for (Snapshot snapshot : snapshots) {
                MediaPackage mp = snapshot.getMediaPackage();
                Optional<WorkflowInstance> optWorkflow = this.applyWorkflow(wf, mp);
                optWorkflow.ifPresent(result::add);
            }
        }
        return result;
    }

    private Optional<WorkflowInstance> applyWorkflow(ConfiguredWorkflow wf, MediaPackage mp) {
        try {
            WorkflowInstance instance = this.wfs.start(wf.getWorkflowDefinition(), mp, wf.getParameters());
            return Optional.of(instance);
        }
        catch (UnauthorizedException | WorkflowDatabaseException | WorkflowParsingException e) {
            logger.error("Cannot start workflow on media package {}", (Object)mp.getIdentifier(), (Object)e);
            return Optional.empty();
        }
    }

    private List<Snapshot> findLatestSnapshots(String mpId) {
        AQueryBuilder q = this.am.createQuery();
        List snapshots = Enrichments.enrich((AResult)q.select(new Target[]{q.snapshot()}).where(q.mediaPackageId(mpId).and(q.version().isLatest())).run()).getSnapshots();
        ArrayList<Snapshot> result = new ArrayList<Snapshot>();
        for (Snapshot snapshot : snapshots) {
            result.add(snapshot);
        }
        return result;
    }
}

