/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.security.shibboleth;

import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.opencastproject.security.api.UserDirectoryService;
import org.opencastproject.security.shibboleth.ShibbolethLoginHandler;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.web.authentication.preauth.RequestHeaderAuthenticationFilter;
import org.springframework.util.Assert;

public class ShibbolethRequestHeaderAuthenticationFilter
extends RequestHeaderAuthenticationFilter {
    private UserDetailsService userDetailsService = null;
    private UserDirectoryService userDirectoryService = null;
    private ShibbolethLoginHandler loginHandler = null;
    private boolean debug = false;

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.userDetailsService, (String)"A UserDetailsService must be set");
        Assert.notNull((Object)this.loginHandler, (String)"A ShibbolethLoginHandler must be set");
        Assert.notNull((Object)this.userDirectoryService, (String)"A UserDirectoryService must be set");
    }

    protected Object getPreAuthenticatedPrincipal(HttpServletRequest request) {
        String o = (String)super.getPreAuthenticatedPrincipal(request);
        if (this.debug) {
            this.debug(request);
        }
        if (o != null && !"".equals(o.trim())) {
            try {
                if (this.userDetailsService.loadUserByUsername(o) != null) {
                    this.loginHandler.existingUserLogin(o, request);
                }
            }
            catch (UsernameNotFoundException e) {
                this.loginHandler.newUserLogin(o, request);
            }
            this.userDirectoryService.invalidate(o);
        }
        return o;
    }

    protected void debug(HttpServletRequest request) {
        Enumeration he = request.getHeaderNames();
        while (he.hasMoreElements()) {
            String headerName = (String)he.nextElement();
            StringBuffer buf = new StringBuffer(headerName).append(": ");
            Enumeration hv = request.getHeaders(headerName);
            boolean first = true;
            while (hv.hasMoreElements()) {
                if (!first) {
                    buf.append(", ");
                }
                buf.append((String)hv.nextElement());
                first = false;
            }
            this.logger.info((Object)buf.toString());
        }
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setUserDetailsService(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    public void setShibbolethLoginHandler(ShibbolethLoginHandler loginHandler) {
        this.loginHandler = loginHandler;
    }
}

