/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.security.lti;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.persistence.RollbackException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.impl.jpa.JpaOrganization;
import org.opencastproject.security.impl.jpa.JpaRole;
import org.opencastproject.security.impl.jpa.JpaUserReference;
import org.opencastproject.security.util.SecurityUtil;
import org.opencastproject.userdirectory.api.UserReferenceProvider;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.oauth.provider.ConsumerAuthentication;
import org.springframework.security.oauth.provider.OAuthAuthenticationHandler;
import org.springframework.security.oauth.provider.token.OAuthAccessProviderToken;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;

@Component(property={"service.description=Lti User Login"}, immediate=true, service={LtiLaunchAuthenticationHandler.class, OAuthAuthenticationHandler.class})
public class LtiLaunchAuthenticationHandler
implements OAuthAuthenticationHandler {
    private static final Logger logger = LoggerFactory.getLogger(LtiLaunchAuthenticationHandler.class);
    private static final String LTI_USER_ID_PARAM = "user_id";
    private static final String LTI_CONSUMER_GUID = "tool_consumer_instance_guid";
    private static final String ROLES = "roles";
    private static final String CONTEXT_ID = "context_id";
    private static final String LTI_USER_ID_PREFIX = "lti";
    private static final String LTI_ID_DELIMITER = ":";
    private static final String ROLE_OAUTH_USER = "ROLE_OAUTH_USER";
    private static final String DEFAULT_CONTEXT = "LTI";
    private static final String DEFAULT_LEARNER = "USER";
    private static final String HIGHLY_TRUSTED_CONSUMER_KEY_PREFIX = "lti.oauth.highly_trusted_consumer_key.";
    private static final String BLACKLIST_USER_PREFIX = "lti.blacklist.user.";
    private static final String ALLOW_SYSTEM_ADMINISTRATOR_KEY = "lti.allow_system_administrator";
    private static final String ALLOW_DIGEST_USER_KEY = "lti.allow_digest_user";
    private static final String CREATE_JPA_USER_REFERENCE_KEY = "lti.create_jpa_user_reference";
    private static final String LTI_ROLES_TO_CREATE_JPA_USER_REFERENCES_FROM = "lti.create_jpa_user_reference.roles";
    private SecurityService securityService = null;
    private UserReferenceProvider userReferenceProvider = null;
    private static final String CUSTOM_ROLE_NAME = "lti.custom_role_name";
    private static final String CUSTOM_ROLES = "lti.custom_roles";
    private static final String CUSTOM_ROLE_NAME_PREFIX = "lti.custom_role_name.";
    private static final String CUSTOM_ROLES_LIST_PREFIX = "lti.custom_roles.";
    private static final String ROLE_PREFIX_KEY = "lti.consumer_role_prefix.";
    private final ConcurrentHashMap<String, String> rolePrefixes = new ConcurrentHashMap();
    private HashMap<Pattern, String[]> customRolePatterns = new HashMap();
    private UserDetailsService userDetailsService;
    private ComponentContext componentContext;
    private Set<String> highlyTrustedConsumerKeys = new HashSet<String>();
    private Set<String> usernameBlacklist = new HashSet<String>();
    private Map<String, Boolean> activePersistenceTransactions = new ConcurrentHashMap<String, Boolean>(128);
    private boolean createJpaUserReference = true;
    private List<String> ltiRolesForUserCreation;

    @Reference
    public void setUserDetailsService(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    @Reference
    public void setUserReferenceProvider(UserReferenceProvider userReferenceProvider) {
        this.userReferenceProvider = userReferenceProvider;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Activate
    protected void activate(ComponentContext cc) {
        String adminUsername;
        logger.info("Activating LtiLaunchAuthenticationHandler");
        this.componentContext = cc;
        Dictionary properties = cc.getProperties();
        logger.debug("Updating LtiLaunchAuthenticationHandler");
        this.highlyTrustedConsumerKeys.clear();
        this.usernameBlacklist.clear();
        if (properties == null) {
            logger.warn("LtiLaunchAuthenticationHandler is not configured");
            return;
        }
        int i = 1;
        while (true) {
            logger.debug("Looking for configuration of {}", (Object)(HIGHLY_TRUSTED_CONSUMER_KEY_PREFIX + i));
            String consumerKey = StringUtils.trimToNull((String)((String)properties.get(HIGHLY_TRUSTED_CONSUMER_KEY_PREFIX + i)));
            if (consumerKey == null) break;
            this.highlyTrustedConsumerKeys.add(consumerKey);
            ++i;
        }
        if (!BooleanUtils.toBoolean((String)StringUtils.trimToNull((String)((String)properties.get(ALLOW_SYSTEM_ADMINISTRATOR_KEY)))) && (adminUsername = StringUtils.trimToNull((String)((String)properties.get("org.opencastproject.security.admin.user")))) != null) {
            this.usernameBlacklist.add(adminUsername);
        }
        if (!BooleanUtils.toBoolean((String)StringUtils.trimToNull((String)((String)properties.get(ALLOW_DIGEST_USER_KEY))))) {
            this.usernameBlacklist.add(SecurityUtil.getSystemUserName((ComponentContext)this.componentContext));
        }
        i = 1;
        while (true) {
            logger.debug("Looking for configuration of {}", (Object)(BLACKLIST_USER_PREFIX + i));
            String username = StringUtils.trimToNull((String)((String)properties.get(BLACKLIST_USER_PREFIX + i)));
            if (username == null) break;
            this.usernameBlacklist.add(username);
            ++i;
        }
        String createJpaUserRefStr = (String)properties.get(CREATE_JPA_USER_REFERENCE_KEY);
        this.createJpaUserReference = BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBooleanObject((String)StringUtils.trimToNull((String)createJpaUserRefStr)), (boolean)true);
        this.ltiRolesForUserCreation = this.extractLtiRolesForUserCreation(Objects.toString(properties.get(LTI_ROLES_TO_CREATE_JPA_USER_REFERENCES_FROM), "*"));
        int i2 = 1;
        while (true) {
            logger.debug("Looking for custom role configuration of {}", (Object)(CUSTOM_ROLE_NAME_PREFIX + i2));
            String customRoleName = StringUtils.trimToNull((String)((String)properties.get(CUSTOM_ROLE_NAME_PREFIX + i2)));
            if (customRoleName == null) break;
            String customRolesString = StringUtils.trimToNull((String)((String)properties.get(CUSTOM_ROLES_LIST_PREFIX + i2)));
            if (customRolesString != null) {
                this.enrichLtiCustomRoles(customRoleName, customRolesString);
            }
            ++i2;
        }
        String customRoleName = StringUtils.trimToNull((String)((String)properties.get(CUSTOM_ROLE_NAME)));
        if (customRoleName != null) {
            String customRolesString = StringUtils.trimToNull((String)((String)properties.get(CUSTOM_ROLES)));
            this.enrichLtiCustomRoles(customRoleName, customRolesString);
        }
        for (String key : Collections.list(properties.keys())) {
            if (!key.startsWith(ROLE_PREFIX_KEY)) continue;
            String consumerKey = key.substring(ROLE_PREFIX_KEY.length());
            String prefix = Objects.toString(properties.get(key), "");
            logger.debug("Adding role prefix '{}' for consumer using OAuth key '{}'", (Object)prefix, (Object)consumerKey);
            this.rolePrefixes.put(consumerKey, prefix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Authentication createAuthentication(HttpServletRequest request, ConsumerAuthentication authentication, OAuthAccessProviderToken authToken) {
        HashSet<GrantedAuthority> userAuthorities;
        UserDetails userDetails;
        String userIdFromConsumer = request.getParameter(LTI_USER_ID_PARAM);
        if (StringUtils.isBlank((CharSequence)userIdFromConsumer)) {
            logger.warn("Received authentication request without user id ({})", (Object)LTI_USER_ID_PARAM);
            return null;
        }
        String consumerGUID = request.getParameter(LTI_CONSUMER_GUID);
        if (StringUtils.isBlank((CharSequence)consumerGUID)) {
            consumerGUID = "UnknownConsumer";
        }
        Object username = "lti:" + consumerGUID + LTI_ID_DELIMITER + userIdFromConsumer;
        String oaAuthKey = request.getParameter("oauth_consumer_key");
        String rolePrefix = this.rolePrefixes.getOrDefault(oaAuthKey, "");
        if (this.highlyTrustedConsumerKeys.contains(oaAuthKey)) {
            logger.debug("{} is a trusted key", (Object)oaAuthKey);
            String ltiUsername = request.getParameter("ext_user_username");
            if (StringUtils.isBlank((CharSequence)ltiUsername) && StringUtils.isBlank((CharSequence)(ltiUsername = request.getParameter("lis_person_sourcedid")))) {
                ltiUsername = userIdFromConsumer;
            }
            if (this.usernameBlacklist.contains(ltiUsername)) {
                logger.debug("{} is blacklisted", (Object)ltiUsername);
            } else {
                username = ltiUsername;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("LTI user id is : {}", username);
        }
        try {
            userDetails = this.userDetailsService.loadUserByUsername((String)username);
            userAuthorities = new HashSet(userDetails.getAuthorities());
            String roles = request.getParameter(ROLES);
            String context = request.getParameter(CONTEXT_ID);
            this.enrichRoleGrants(roles, context, rolePrefix, userAuthorities);
        }
        catch (UsernameNotFoundException e) {
            logger.trace("This user is known to the tool consumer only. Creating an Opencast user on the fly.", (Throwable)e);
            userAuthorities = new HashSet<GrantedAuthority>();
            String roles = request.getParameter(ROLES);
            String context = request.getParameter(CONTEXT_ID);
            this.enrichRoleGrants(roles, context, rolePrefix, userAuthorities);
            logger.debug("Returning user with {} authorities", (Object)userAuthorities.size());
            userDetails = new User((String)username, "oauth", true, true, true, true, userAuthorities);
        }
        userAuthorities.add((GrantedAuthority)new SimpleGrantedAuthority(ROLE_OAUTH_USER));
        userAuthorities.add((GrantedAuthority)new SimpleGrantedAuthority("ROLE_USER"));
        userAuthorities.add((GrantedAuthority)new SimpleGrantedAuthority("ROLE_ANONYMOUS"));
        if (this.createJpaUserReference && this.ltiRolesForUserCreation.size() > 0) {
            if (this.activePersistenceTransactions.putIfAbsent((String)username, Boolean.TRUE) != null) {
                logger.debug("Concurrent access of user {}. Ignoring.", username);
            } else if (!this.ltiRolesForUserCreation.contains("*") && !this.requestContainsMatchingRoles(request)) {
                logger.debug("No JpaUserReference will be created for LTI user {}.", username);
                this.activePersistenceTransactions.remove(username);
            } else {
                try {
                    JpaOrganization organization = this.fromOrganization(this.securityService.getOrganization());
                    JpaUserReference jpaUserReference = this.userReferenceProvider.findUserReference((String)username, organization.getId());
                    HashSet<JpaRole> jpaRoles = new HashSet<JpaRole>();
                    for (GrantedAuthority authority : userAuthorities) {
                        jpaRoles.add(new JpaRole(authority.getAuthority(), organization));
                    }
                    Date loginDate = new Date();
                    Object name = request.getParameter("lis_person_name_full");
                    if (name == null) {
                        String familyName = Objects.toString(request.getParameter("lis_person_name_family"), "");
                        String givenName = Objects.toString(request.getParameter("lis_person_name_given"), "");
                        name = String.format("%s %s", givenName, familyName).trim();
                        if (((String)name).isEmpty()) {
                            name = username;
                        }
                    }
                    String email = request.getParameter("lis_person_contact_email_primary");
                    if (jpaUserReference == null) {
                        String jpaContext = Objects.toString(request.getParameter(CONTEXT_ID), DEFAULT_CONTEXT);
                        JpaUserReference userReference = new JpaUserReference((String)username, (String)name, email, jpaContext, loginDate, organization, jpaRoles);
                        this.userReferenceProvider.addUserReference(userReference, jpaContext);
                    } else {
                        jpaUserReference.setLastLogin(loginDate);
                        jpaUserReference.setName((String)name);
                        jpaUserReference.setEmail(email);
                        jpaUserReference.setRoles(jpaRoles);
                        this.userReferenceProvider.updateUserReference(jpaUserReference);
                    }
                }
                catch (RollbackException e) {
                    logger.warn("Could not store reference since database was changed during update by another process", (Throwable)e);
                }
                finally {
                    this.activePersistenceTransactions.remove(username);
                }
            }
        }
        PreAuthenticatedAuthenticationToken ltiAuth = new PreAuthenticatedAuthenticationToken((Object)userDetails, authentication.getCredentials(), userAuthorities);
        SecurityContextHolder.getContext().setAuthentication((Authentication)ltiAuth);
        return ltiAuth;
    }

    private void enrichRoleGrants(String roles, String context, String rolePrefix, Collection<GrantedAuthority> userAuthorities) {
        if (roles != null) {
            String[] roleList = roles.split(",");
            context = StringUtils.isBlank((CharSequence)context) ? DEFAULT_CONTEXT : context;
            for (String ltiRole : roleList) {
                for (Pattern rolePattern : this.customRolePatterns.keySet()) {
                    logger.debug("Matching role pattern '{}' against '{}'", (Object)rolePattern.pattern(), (Object)ltiRole);
                    if (!rolePattern.matcher(ltiRole).matches()) continue;
                    for (String roleName : this.customRolePatterns.get(rolePattern)) {
                        userAuthorities.add((GrantedAuthority)new SimpleGrantedAuthority(roleName));
                    }
                }
                String normalizedLtiRole = (String)StringUtils.defaultIfBlank((CharSequence)ltiRole, (CharSequence)DEFAULT_LEARNER);
                String role = rolePrefix + context + "_" + normalizedLtiRole;
                if (role.trim().toUpperCase().startsWith("ROLE_")) {
                    logger.warn("Discarding attempt to acquire role \u201c{}\u201d", (Object)role);
                    continue;
                }
                logger.debug("Adding role: {}", (Object)role);
                userAuthorities.add((GrantedAuthority)new SimpleGrantedAuthority(role));
            }
        }
    }

    private void enrichLtiCustomRoles(String roleName, String customRolesString) {
        String[] customRoles = customRolesString.split(",");
        Pattern customRolePattern = Pattern.compile(roleName);
        this.customRolePatterns.put(customRolePattern, customRoles);
    }

    private JpaOrganization fromOrganization(Organization org) {
        if (org instanceof JpaOrganization) {
            return (JpaOrganization)org;
        }
        return new JpaOrganization(org.getId(), org.getName(), org.getServers(), org.getAdminRole(), org.getAnonymousRole(), org.getProperties());
    }

    private List<String> extractLtiRolesForUserCreation(String ltiRoles) {
        if ("*".equals((ltiRoles = StringUtils.trimToNull((String)ltiRoles)).trim())) {
            return Collections.singletonList("*");
        }
        ltiRoles = ltiRoles.toLowerCase();
        return Arrays.asList(ltiRoles.trim().split("\\s*,\\s*"));
    }

    private boolean requestContainsMatchingRoles(HttpServletRequest request) {
        String roles = request.getParameter(ROLES);
        if (roles != null) {
            List<String> requestRoleList = Arrays.asList(roles.toLowerCase().trim().split("\\s*,\\s*"));
            return !Collections.disjoint(requestRoleList, this.ltiRolesForUserCreation);
        }
        return false;
    }
}

