/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.security.jwt;

import com.auth0.jwk.Jwk;
import com.auth0.jwk.JwkException;
import com.auth0.jwk.SigningKeyNotFoundException;
import com.auth0.jwk.UrlJwkProvider;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.opencastproject.security.jwt.AlgorithmBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuavaCachedUrlJwkProvider
extends UrlJwkProvider {
    private static final Logger logger = LoggerFactory.getLogger(GuavaCachedUrlJwkProvider.class);
    private final Cache<String, List<Jwk>> cache;
    private static final String KEY = "GET_ALL";

    public GuavaCachedUrlJwkProvider(String jwksUrl, long expiresIn, TimeUnit expiresUnit) {
        super(GuavaCachedUrlJwkProvider.urlFromString(jwksUrl));
        this.cache = CacheBuilder.newBuilder().maximumSize(1L).expireAfterWrite(expiresIn, expiresUnit).build();
    }

    private static URL urlFromString(String url) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)url) ? 1 : 0) != 0, (Object)"A URL is required");
        try {
            URI uri = new URI(url).normalize();
            return uri.toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new IllegalArgumentException("Invalid JWKS URI", e);
        }
    }

    public List<Jwk> getAll() {
        return this.getAll(false);
    }

    public List<Jwk> getAll(boolean forceFetch) {
        try {
            List jwks;
            if (forceFetch) {
                this.cache.invalidate((Object)KEY);
            }
            if ((jwks = (List)this.cache.getIfPresent((Object)KEY)) == null) {
                logger.debug("JWKS cache miss");
                jwks = (List)this.cache.get((Object)KEY, () -> super.getAll());
            } else {
                logger.debug("JWKS cache hit");
            }
            return jwks;
        }
        catch (ExecutionException e) {
            logger.error("Error while loading from JWKS cache: " + e.getMessage());
            return Collections.emptyList();
        }
    }

    public List<Algorithm> getAlgorithms(DecodedJWT jwt, boolean forceFetch) throws JwkException {
        ArrayList<Algorithm> algorithms = new ArrayList<Algorithm>();
        for (Jwk jwk : this.getAll(forceFetch)) {
            if ((jwt.getKeyId() != null || !jwt.getAlgorithm().equals(jwk.getAlgorithm())) && (jwt.getKeyId() == null || !jwt.getKeyId().equals(jwk.getId()))) continue;
            algorithms.add(AlgorithmBuilder.buildAlgorithm(jwk));
        }
        if (algorithms.isEmpty()) {
            throw new SigningKeyNotFoundException("No key found", null);
        }
        return algorithms;
    }
}

