/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.security.jwt;

import com.auth0.jwt.interfaces.DecodedJWT;
import java.util.Date;

public class CachedJWT {
    private final String signature;
    private final Date expiresAt;
    private final String username;

    public CachedJWT(DecodedJWT jwt, String username) {
        this.signature = jwt.getSignature();
        this.expiresAt = jwt.getExpiresAt();
        this.username = username;
    }

    public boolean hasExpired() {
        return this.expiresAt != null && !this.expiresAt.after(new Date());
    }

    public String getSignature() {
        return this.signature;
    }

    public Date getExpiresAt() {
        return this.expiresAt;
    }

    public String getUsername() {
        return this.username;
    }
}

