/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.search.impl.persistence;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.TypedQuery;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.opencastproject.db.DBSession;
import org.opencastproject.db.DBSessionFactory;
import org.opencastproject.db.Queries;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.MediaPackageParser;
import org.opencastproject.search.impl.persistence.SearchEntity;
import org.opencastproject.search.impl.persistence.SearchServiceDatabase;
import org.opencastproject.search.impl.persistence.SearchServiceDatabaseException;
import org.opencastproject.security.api.AccessControlList;
import org.opencastproject.security.api.AccessControlParser;
import org.opencastproject.security.api.AccessControlParsingException;
import org.opencastproject.security.api.AccessControlUtil;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.Permissions;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.security.api.User;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.data.Tuple;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={SearchServiceDatabase.class}, property={"service.description=Search Service Persistence"})
public class SearchServiceDatabaseImpl
implements SearchServiceDatabase {
    public static final String PERSISTENCE_UNIT = "org.opencastproject.search.impl.persistence";
    private static final Logger logger = LoggerFactory.getLogger(SearchServiceDatabaseImpl.class);
    protected EntityManagerFactory emf;
    protected DBSessionFactory dbSessionFactory;
    protected DBSession db;
    protected SecurityService securityService;

    @Reference(target="(osgi.unit.name=org.opencastproject.search.impl.persistence)")
    public void setEntityManagerFactory(EntityManagerFactory emf) {
        this.emf = emf;
    }

    @Reference
    public void setDBSessionFactory(DBSessionFactory dbSessionFactory) {
        this.dbSessionFactory = dbSessionFactory;
    }

    @Activate
    public void activate(ComponentContext cc) throws SearchServiceDatabaseException {
        logger.info("Activating persistence manager for search service");
        this.db = this.dbSessionFactory.createSession(this.emf);
        this.populateSeriesData();
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    private void populateSeriesData() throws SearchServiceDatabaseException {
        try {
            this.db.execTxChecked(em -> {
                TypedQuery q = em.createNamedQuery("Search.getNoSeries", SearchEntity.class);
                List seriesList = q.getResultList();
                for (SearchEntity series : seriesList) {
                    String mpSeriesId = MediaPackageParser.getFromXml((String)series.getMediaPackageXML()).getSeries();
                    if (!StringUtils.isNotBlank((CharSequence)mpSeriesId) || mpSeriesId.equals(series.getSeriesId())) continue;
                    logger.info("Fixing missing series ID for episode {}, series is {}", (Object)series.getMediaPackageId(), (Object)mpSeriesId);
                    series.setSeriesId(mpSeriesId);
                    em.merge((Object)series);
                }
            });
        }
        catch (Exception e) {
            logger.error("Could not update media package: {}", (Object)e.getMessage());
            throw new SearchServiceDatabaseException(e);
        }
    }

    @Override
    public void deleteMediaPackage(String mediaPackageId, Date deletionDate) throws SearchServiceDatabaseException, NotFoundException, UnauthorizedException {
        try {
            this.db.execTxChecked(em -> {
                AccessControlList acl;
                Optional<SearchEntity> searchEntity = this.getSearchEntityQuery(mediaPackageId).apply((EntityManager)em);
                if (searchEntity.isEmpty()) {
                    throw new NotFoundException("No media package with id=" + mediaPackageId + " exists");
                }
                User currentUser = this.securityService.getUser();
                Organization currentOrg = this.securityService.getOrganization();
                MediaPackage searchMp = MediaPackageParser.getFromXml((String)searchEntity.get().getMediaPackageXML());
                String accessControlXml = searchEntity.get().getAccessControl();
                if (!(searchMp.isLive() && currentUser.hasRole("ROLE_CAPTURE_AGENT") || accessControlXml == null || AccessControlUtil.isAuthorized((AccessControlList)(acl = AccessControlParser.parseAcl((String)accessControlXml)), (User)currentUser, (Organization)currentOrg, (Object)Permissions.Action.WRITE.toString(), (String)mediaPackageId))) {
                    throw new UnauthorizedException(String.valueOf(currentUser) + " is not authorized to delete media package " + mediaPackageId);
                }
                searchEntity.get().setDeletionDate(deletionDate);
                searchEntity.get().setModificationDate(deletionDate);
                em.merge((Object)searchEntity.get());
            });
        }
        catch (UnauthorizedException | NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Could not delete episode {}: {}", (Object)mediaPackageId, (Object)e.getMessage());
            throw new SearchServiceDatabaseException(e);
        }
    }

    @Override
    public int countMediaPackages() throws SearchServiceDatabaseException {
        try {
            return ((Long)this.db.exec(Queries.namedQuery.find("Search.getCount", Long.class, new Object[0]))).intValue();
        }
        catch (Exception e) {
            logger.error("Could not find number of mediapackages", (Throwable)e);
            throw new SearchServiceDatabaseException(e);
        }
    }

    @Override
    public Stream<Tuple<MediaPackage, String>> getAllMediaPackages(int pagesize, int offset) throws SearchServiceDatabaseException {
        List searchEntities;
        try {
            int firstResult = pagesize * offset;
            searchEntities = (List)this.db.exec(Queries.namedQuery.findSome("Search.findAll", firstResult, pagesize, SearchEntity.class, new Object[0]));
        }
        catch (Exception e) {
            logger.error("Could not retrieve all episodes: {}", (Object)e.getMessage());
            throw new SearchServiceDatabaseException(e);
        }
        try {
            return searchEntities.stream().map(entity -> {
                try {
                    MediaPackage mediaPackage = MediaPackageParser.getFromXml((String)entity.getMediaPackageXML());
                    return Tuple.tuple((Object)mediaPackage, (Object)entity.getOrganization().getId());
                }
                catch (Exception e) {
                    logger.error("Could not parse series entity: {}", (Object)e.getMessage());
                    throw new RuntimeException(e);
                }
            });
        }
        catch (Exception e) {
            logger.error("Could not parse series entity: {}", (Object)e.getMessage());
            throw new SearchServiceDatabaseException(e);
        }
    }

    @Override
    public AccessControlList getAccessControlList(String mediaPackageId) throws NotFoundException, SearchServiceDatabaseException {
        try {
            Optional entity = (Optional)this.db.exec(this.getSearchEntityQuery(mediaPackageId));
            if (entity.isEmpty()) {
                throw new NotFoundException("Could not found media package with ID " + mediaPackageId);
            }
            if (((SearchEntity)entity.get()).getAccessControl() == null) {
                return null;
            }
            return AccessControlParser.parseAcl((String)((SearchEntity)entity.get()).getAccessControl());
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Could not retrieve ACL {}", (Object)mediaPackageId, (Object)e);
            throw new SearchServiceDatabaseException(e);
        }
    }

    @Override
    public Collection<Pair<String, AccessControlList>> getAccessControlLists(String seriesId, String ... excludeIds) throws SearchServiceDatabaseException {
        List<String> excludes = Arrays.asList(excludeIds);
        ArrayList<Pair<String, AccessControlList>> accessControlLists = new ArrayList<Pair<String, AccessControlList>>();
        try {
            List result = (List)this.db.exec(Queries.namedQuery.findAll("Search.findBySeriesId", SearchEntity.class, new Object[]{Pair.of((Object)"seriesId", (Object)seriesId)}));
            for (SearchEntity entity : result) {
                if (entity.getAccessControl() == null || excludes.contains(entity.getMediaPackageId())) continue;
                accessControlLists.add((Pair<String, AccessControlList>)Pair.of((Object)entity.getMediaPackageId(), (Object)AccessControlParser.parseAcl((String)entity.getAccessControl())));
            }
        }
        catch (IOException | AccessControlParsingException e) {
            throw new SearchServiceDatabaseException(e);
        }
        return accessControlLists;
    }

    @Override
    public Collection<Pair<Organization, MediaPackage>> getSeries(String seriesId) throws SearchServiceDatabaseException {
        ArrayList<Pair<Organization, MediaPackage>> episodes = new ArrayList<Pair<Organization, MediaPackage>>();
        EntityManager em = this.emf.createEntityManager();
        TypedQuery q = em.createNamedQuery("Search.findBySeriesId", SearchEntity.class).setParameter("seriesId", (Object)seriesId);
        try {
            for (SearchEntity entity : q.getResultList()) {
                if (entity.getMediaPackageXML() == null) continue;
                episodes.add((Pair<Organization, MediaPackage>)Pair.of((Object)entity.getOrganization(), (Object)MediaPackageParser.getFromXml((String)entity.getMediaPackageXML())));
            }
        }
        catch (MediaPackageException e) {
            throw new SearchServiceDatabaseException(e);
        }
        finally {
            em.close();
        }
        return episodes;
    }

    @Override
    public void storeMediaPackage(MediaPackage mediaPackage, AccessControlList acl, Date now) throws SearchServiceDatabaseException, UnauthorizedException {
        String mediaPackageXML = MediaPackageParser.getAsXml((MediaPackage)mediaPackage);
        String mediaPackageId = mediaPackage.getIdentifier().toString();
        try {
            this.db.execTxChecked(em -> {
                Optional<SearchEntity> entity = this.getSearchEntityQuery(mediaPackageId).apply((EntityManager)em);
                if (entity.isEmpty()) {
                    SearchEntity searchEntity = new SearchEntity();
                    searchEntity.setOrganization(this.securityService.getOrganization());
                    searchEntity.setMediaPackageId(mediaPackageId);
                    searchEntity.setMediaPackageXML(mediaPackageXML);
                    searchEntity.setAccessControl(AccessControlParser.toXml((AccessControlList)acl));
                    searchEntity.setModificationDate(now);
                    searchEntity.setSeriesId(mediaPackage.getSeries());
                    em.persist((Object)searchEntity);
                } else {
                    Organization currentOrg;
                    User currentUser;
                    AccessControlList accessList;
                    String accessControlXml = entity.get().getAccessControl();
                    if (accessControlXml != null && entity.get().getDeletionDate() == null && !AccessControlUtil.isAuthorized((AccessControlList)(accessList = AccessControlParser.parseAcl((String)accessControlXml)), (User)(currentUser = this.securityService.getUser()), (Organization)(currentOrg = this.securityService.getOrganization()), (Object)Permissions.Action.WRITE.toString(), (String)mediaPackageId)) {
                        throw new UnauthorizedException(String.valueOf(currentUser) + " is not authorized to update media package " + mediaPackageId);
                    }
                    entity.get().setOrganization(this.securityService.getOrganization());
                    entity.get().setMediaPackageId(mediaPackageId);
                    entity.get().setMediaPackageXML(mediaPackageXML);
                    entity.get().setAccessControl(AccessControlParser.toXml((AccessControlList)acl));
                    entity.get().setModificationDate(now);
                    entity.get().setDeletionDate(null);
                    entity.get().setSeriesId(mediaPackage.getSeries());
                    em.merge((Object)entity.get());
                }
            });
        }
        catch (UnauthorizedException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Could not update media package: {}", (Object)e.getMessage());
            throw new SearchServiceDatabaseException(e);
        }
    }

    @Override
    public MediaPackage getMediaPackage(String mediaPackageId) throws NotFoundException, SearchServiceDatabaseException, UnauthorizedException {
        try {
            return (MediaPackage)this.db.execTxChecked(em -> {
                Organization currentOrg;
                User currentUser;
                AccessControlList acl;
                Optional<SearchEntity> episodeEntity = this.getSearchEntityQuery(mediaPackageId).apply((EntityManager)em);
                if (episodeEntity.isEmpty() || episodeEntity.get().getDeletionDate() != null) {
                    throw new NotFoundException("No episode with id=" + mediaPackageId + " exists");
                }
                String accessControlXml = episodeEntity.get().getAccessControl();
                if (!(accessControlXml == null || AccessControlUtil.isAuthorized((AccessControlList)(acl = AccessControlParser.parseAcl((String)accessControlXml)), (User)(currentUser = this.securityService.getUser()), (Organization)(currentOrg = this.securityService.getOrganization()), (Object)Permissions.Action.READ.toString(), (String)mediaPackageId) || AccessControlUtil.isAuthorized((AccessControlList)acl, (User)currentUser, (Organization)currentOrg, (Object)Permissions.Action.CONTRIBUTE.toString(), (String)mediaPackageId) || AccessControlUtil.isAuthorized((AccessControlList)acl, (User)currentUser, (Organization)currentOrg, (Object)Permissions.Action.WRITE.toString(), (String)mediaPackageId))) {
                    throw new UnauthorizedException(String.valueOf(currentUser) + " is not authorized to see episode " + mediaPackageId);
                }
                return MediaPackageParser.getFromXml((String)episodeEntity.get().getMediaPackageXML());
            });
        }
        catch (UnauthorizedException | NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Could not get episode {} from database: {} ", (Object)mediaPackageId, (Object)e.getMessage());
            throw new SearchServiceDatabaseException(e);
        }
    }

    @Override
    public Date getModificationDate(String mediaPackageId) throws NotFoundException, SearchServiceDatabaseException {
        try {
            return (Date)this.db.execTxChecked(em -> {
                Organization currentOrg;
                User currentUser;
                AccessControlList acl;
                Optional<SearchEntity> searchEntity = this.getSearchEntityQuery(mediaPackageId).apply((EntityManager)em);
                if (searchEntity.isEmpty()) {
                    throw new NotFoundException("No media package with id=" + mediaPackageId + " exists");
                }
                String accessControlXml = searchEntity.get().getAccessControl();
                if (accessControlXml != null && !AccessControlUtil.isAuthorized((AccessControlList)(acl = AccessControlParser.parseAcl((String)accessControlXml)), (User)(currentUser = this.securityService.getUser()), (Organization)(currentOrg = this.securityService.getOrganization()), (Object)Permissions.Action.READ.toString(), (String)mediaPackageId)) {
                    throw new UnauthorizedException(String.valueOf(currentUser) + " is not authorized to read media package " + mediaPackageId);
                }
                return searchEntity.get().getModificationDate();
            });
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Could not get modification date {}: {}", (Object)mediaPackageId, (Object)e.getMessage());
            throw new SearchServiceDatabaseException(e);
        }
    }

    @Override
    public Date getDeletionDate(String mediaPackageId) throws NotFoundException, SearchServiceDatabaseException {
        try {
            return (Date)this.db.execTxChecked(em -> {
                Organization currentOrg;
                User currentUser;
                AccessControlList acl;
                Optional<SearchEntity> searchEntity = this.getSearchEntityQuery(mediaPackageId).apply((EntityManager)em);
                if (searchEntity.isEmpty()) {
                    throw new NotFoundException("No media package with id=" + mediaPackageId + " exists");
                }
                String accessControlXml = searchEntity.get().getAccessControl();
                if (accessControlXml != null && !AccessControlUtil.isAuthorized((AccessControlList)(acl = AccessControlParser.parseAcl((String)accessControlXml)), (User)(currentUser = this.securityService.getUser()), (Organization)(currentOrg = this.securityService.getOrganization()), (Object)Permissions.Action.READ.toString(), (String)mediaPackageId)) {
                    throw new UnauthorizedException(String.valueOf(currentUser) + " is not authorized to read media package " + mediaPackageId);
                }
                return searchEntity.get().getDeletionDate();
            });
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Could not get deletion date {}: {}", (Object)mediaPackageId, (Object)e.getMessage());
            throw new SearchServiceDatabaseException(e);
        }
    }

    @Override
    public boolean isAvailable(String mediaPackageId) throws SearchServiceDatabaseException {
        try {
            return (Boolean)this.db.execTxChecked(em -> {
                Optional<SearchEntity> searchEntity = this.getSearchEntityQuery(mediaPackageId).apply((EntityManager)em);
                return searchEntity.stream().anyMatch(entity -> entity.getDeletionDate() == null);
            });
        }
        catch (Exception e) {
            logger.error("Error while checking if mediapackage {} exists in database: {}", (Object)mediaPackageId, (Object)e.getMessage());
            throw new SearchServiceDatabaseException(e);
        }
    }

    @Override
    public String getOrganizationId(String mediaPackageId) throws NotFoundException, SearchServiceDatabaseException {
        try {
            return (String)this.db.execTxChecked(em -> {
                Organization currentOrg;
                User currentUser;
                AccessControlList acl;
                Optional<SearchEntity> searchEntity = this.getSearchEntityQuery(mediaPackageId).apply((EntityManager)em);
                if (searchEntity.isEmpty()) {
                    throw new NotFoundException("No media package with id=" + mediaPackageId + " exists");
                }
                String accessControlXml = searchEntity.get().getAccessControl();
                if (accessControlXml != null && !AccessControlUtil.isAuthorized((AccessControlList)(acl = AccessControlParser.parseAcl((String)accessControlXml)), (User)(currentUser = this.securityService.getUser()), (Organization)(currentOrg = this.securityService.getOrganization()), (Object)Permissions.Action.READ.toString(), (String)mediaPackageId)) {
                    throw new UnauthorizedException(String.valueOf(currentUser) + " is not authorized to read media package " + mediaPackageId);
                }
                return searchEntity.get().getOrganization().getId();
            });
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Could not get deletion date {}: {}", (Object)mediaPackageId, (Object)e.getMessage());
            throw new SearchServiceDatabaseException(e);
        }
    }

    private Function<EntityManager, Optional<SearchEntity>> getSearchEntityQuery(String id) {
        return Queries.namedQuery.findOpt("Search.findById", SearchEntity.class, new Object[]{Pair.of((Object)"mediaPackageId", (Object)id)});
    }
}

