/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.search.impl.persistence;

import java.util.Collection;
import java.util.Date;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.search.impl.persistence.SearchServiceDatabaseException;
import org.opencastproject.security.api.AccessControlList;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.data.Tuple;

public interface SearchServiceDatabase {
    public Stream<Tuple<MediaPackage, String>> getAllMediaPackages(int var1, int var2) throws SearchServiceDatabaseException;

    public String getOrganizationId(String var1) throws NotFoundException, SearchServiceDatabaseException;

    public int countMediaPackages() throws SearchServiceDatabaseException;

    public MediaPackage getMediaPackage(String var1) throws NotFoundException, SearchServiceDatabaseException, UnauthorizedException;

    public Collection<Pair<Organization, MediaPackage>> getSeries(String var1) throws SearchServiceDatabaseException;

    public AccessControlList getAccessControlList(String var1) throws NotFoundException, SearchServiceDatabaseException;

    public Collection<Pair<String, AccessControlList>> getAccessControlLists(String var1, String ... var2) throws SearchServiceDatabaseException;

    public Date getModificationDate(String var1) throws NotFoundException, SearchServiceDatabaseException;

    public Date getDeletionDate(String var1) throws NotFoundException, SearchServiceDatabaseException;

    public void deleteMediaPackage(String var1, Date var2) throws SearchServiceDatabaseException, NotFoundException, UnauthorizedException;

    public void storeMediaPackage(MediaPackage var1, AccessControlList var2, Date var3) throws SearchServiceDatabaseException, UnauthorizedException;

    public boolean isAvailable(String var1) throws SearchServiceDatabaseException;
}

