/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.search.impl;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.CreateIndexResponse;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.opencastproject.elasticsearch.index.ElasticsearchIndex;
import org.opencastproject.elasticsearch.index.rebuild.AbstractIndexProducer;
import org.opencastproject.elasticsearch.index.rebuild.IndexProducer;
import org.opencastproject.elasticsearch.index.rebuild.IndexRebuildException;
import org.opencastproject.elasticsearch.index.rebuild.IndexRebuildService;
import org.opencastproject.list.api.ListProviderException;
import org.opencastproject.list.api.ListProvidersService;
import org.opencastproject.list.api.ResourceListQuery;
import org.opencastproject.list.impl.ResourceListQueryImpl;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.metadata.dublincore.DublinCore;
import org.opencastproject.metadata.dublincore.DublinCoreCatalog;
import org.opencastproject.metadata.dublincore.DublinCoreUtil;
import org.opencastproject.metadata.dublincore.DublinCoreValue;
import org.opencastproject.metadata.dublincore.DublinCores;
import org.opencastproject.search.api.SearchException;
import org.opencastproject.search.api.SearchResult;
import org.opencastproject.search.api.SearchService;
import org.opencastproject.search.impl.persistence.SearchServiceDatabase;
import org.opencastproject.search.impl.persistence.SearchServiceDatabaseException;
import org.opencastproject.security.api.AccessControlEntry;
import org.opencastproject.security.api.AccessControlList;
import org.opencastproject.security.api.AccessControlUtil;
import org.opencastproject.security.api.AuthorizationService;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.Permissions;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.security.api.User;
import org.opencastproject.security.util.SecurityUtil;
import org.opencastproject.series.api.SeriesException;
import org.opencastproject.series.api.SeriesService;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.data.Tuple;
import org.opencastproject.workspace.api.Workspace;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={SearchServiceIndex.class, IndexProducer.class}, property={"service.description=Search Service Index", "service.pid=org.opencastproject.search.impl.SearchServiceIndex"})
public final class SearchServiceIndex
extends AbstractIndexProducer
implements IndexProducer {
    private static final Logger logger = LoggerFactory.getLogger(SearchServiceIndex.class);
    public static final String INDEX_NAME = "opencast_search";
    private final Gson gson = new Gson();
    private ElasticsearchIndex esIndex;
    private SeriesService seriesService;
    private Workspace workspace;
    private SecurityService securityService;
    private AuthorizationService authorizationService;
    private SearchServiceDatabase persistence;
    private OrganizationDirectoryService organizationDirectory = null;
    private ListProvidersService listProvidersService;
    private String systemUserName = null;

    public IndexRebuildService.Service getService() {
        return IndexRebuildService.Service.Search;
    }

    @Activate
    public void activate(ComponentContext cc) throws IllegalStateException {
        this.createIndex();
        this.systemUserName = SecurityUtil.getSystemUserName((ComponentContext)cc);
    }

    private void createIndex() {
        String mapping = "";
        try (InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("/search-mapping.json");){
            mapping = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new SearchException("Could not read mapping.", (Throwable)e);
        }
        try {
            logger.debug("Trying to create index for '{}'", (Object)INDEX_NAME);
            InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/elasticsearch/indexSettings.json");
            String indexSettings = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            CreateIndexRequest request = new CreateIndexRequest(INDEX_NAME).settings(indexSettings, XContentType.JSON).mapping(mapping, XContentType.JSON);
            CreateIndexResponse response = this.esIndex.getClient().indices().create(request, RequestOptions.DEFAULT);
            if (!response.isAcknowledged()) {
                throw new SearchException("Unable to create index for 'opencast_search'");
            }
        }
        catch (ElasticsearchStatusException e) {
            if (e.getDetailedMessage().contains("already_exists_exception")) {
                logger.info("Detected existing index '{}'", (Object)INDEX_NAME);
            }
            throw e;
        }
        catch (IOException e) {
            throw new SearchException((Throwable)e);
        }
    }

    @Reference
    public void setEsIndex(ElasticsearchIndex esIndex) {
        this.esIndex = esIndex;
    }

    public SearchResponse search(SearchSourceBuilder searchSource) throws SearchException {
        SearchRequest searchRequest = new SearchRequest(new String[]{INDEX_NAME});
        logger.debug("Sending for query: {}", (Object)searchSource.query());
        searchRequest.source(searchSource);
        try {
            return this.esIndex.getClient().search(searchRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new SearchException((Throwable)e);
        }
    }

    public void addSynchronously(MediaPackage mediaPackage) throws SearchException, IllegalArgumentException, UnauthorizedException, SearchServiceDatabaseException {
        if (mediaPackage == null) {
            throw new IllegalArgumentException("Unable to add a null mediapackage");
        }
        String mediaPackageId = mediaPackage.getIdentifier().toString();
        this.checkSearchEntityWritePermission(mediaPackageId);
        logger.debug("Attempting to add media package {} to search index", (Object)mediaPackageId);
        AccessControlList[] acls = new AccessControlList[1];
        Organization org = this.securityService.getOrganization();
        User systemUser = SecurityUtil.createSystemUser((String)this.systemUserName, (Organization)org);
        SecurityUtil.runAs((SecurityService)this.securityService, (Organization)org, (User)systemUser, () -> {
            acls[0] = (AccessControlList)this.authorizationService.getActiveAcl(mediaPackage).getA();
        });
        AccessControlList acl = acls[0] == null ? new AccessControlList() : acls[0];
        Date now = new Date();
        try {
            this.persistence.storeMediaPackage(mediaPackage, acl, now);
        }
        catch (SearchServiceDatabaseException e) {
            throw new SearchException(String.format("Could not store media package to search database %s", mediaPackageId), (Throwable)e);
        }
        this.indexMediaPackage(mediaPackage, acl);
    }

    public void indexMediaPackage(String mediaPackageId) throws SearchException, SearchServiceDatabaseException, UnauthorizedException, NotFoundException {
        if (!this.securityService.getUser().hasRole("ROLE_ADMIN")) {
            throw new UnauthorizedException("Only global administrators may trigger manual event updates.");
        }
        try {
            MediaPackage mp = this.persistence.getMediaPackage(mediaPackageId);
            AccessControlList acl = this.persistence.getAccessControlList(mediaPackageId);
            Date modificationDate = this.persistence.getModificationDate(mediaPackageId);
            Date deletionDate = this.persistence.getDeletionDate(mediaPackageId);
            this.indexMediaPackage(mp, acl, modificationDate, deletionDate);
        }
        catch (RuntimeException e) {
            this.logSkippingElement(logger, "event", mediaPackageId, e);
        }
    }

    private void indexMediaPackage(MediaPackage mediaPackage, AccessControlList acl) throws SearchException, SearchServiceDatabaseException {
        this.indexMediaPackage(mediaPackage, acl, null, null);
    }

    private void indexMediaPackage(MediaPackage mediaPackage, AccessControlList acl, Date modDate, Date delDate) throws SearchException, SearchServiceDatabaseException {
        String mediaPackageId = mediaPackage.getIdentifier().toString();
        String orgId = this.securityService.getOrganization().getId();
        DublinCoreCatalog dc = null == delDate ? DublinCoreUtil.loadEpisodeDublinCore((Workspace)this.workspace, (MediaPackage)mediaPackage).orElse(DublinCores.mkSimple()) : DublinCores.mkSimple();
        List<Object> seriesList = Collections.emptyList();
        if (dc.hasValue(DublinCore.PROPERTY_IS_PART_OF)) {
            seriesList = dc.get(DublinCore.PROPERTY_IS_PART_OF).stream().map(DublinCoreValue::getValue).map(s -> {
                try {
                    return this.seriesService.getSeries(s);
                }
                catch (NotFoundException e) {
                    logger.warn("Series {} not found during index of event {}, omitting the link from the indexed data", s, (Object)mediaPackageId);
                }
                catch (UnauthorizedException e) {
                    logger.warn("Not authorized for series {} during index of event {}, omitting the link from the indexed data", s, (Object)mediaPackageId);
                }
                catch (SeriesException e) {
                    throw new SearchException((Throwable)e);
                }
                return null;
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }
        acl = this.addCustomAclRoles(mediaPackageId, acl);
        SearchResult item = new SearchResult(SearchService.IndexEntryType.Episode, dc, acl, orgId, mediaPackage, null != modDate ? modDate.toInstant() : Instant.now(), null != delDate ? delDate.toInstant() : null);
        Map metadata = item.dehydrateForIndex();
        try {
            IndexRequest request = new IndexRequest(INDEX_NAME);
            request.id(mediaPackageId);
            request.source(metadata);
            this.esIndex.getClient().index(request, RequestOptions.DEFAULT);
            logger.debug("Indexed episode {}", (Object)mediaPackageId);
        }
        catch (IOException e) {
            throw new SearchException((Throwable)e);
        }
        for (DublinCoreCatalog seriesDc : seriesList) {
            String seriesId = seriesDc.getFirst(DublinCore.PROPERTY_IDENTIFIER);
            AccessControlList seriesAcl = this.persistence.getAccessControlLists(seriesId, mediaPackageId).stream().map(aclPair -> this.addCustomAclRoles((String)aclPair.getKey(), (AccessControlList)aclPair.getValue())).reduce(new AccessControlList(acl.getEntries()), AccessControlList::mergeActions);
            item = new SearchResult(SearchService.IndexEntryType.Series, seriesDc, seriesAcl, orgId, null, Instant.now(), null);
            Map seriesData = item.dehydrateForIndex();
            try {
                IndexRequest request = new IndexRequest(INDEX_NAME);
                request.id(seriesId);
                request.source(seriesData);
                this.esIndex.getClient().index(request, RequestOptions.DEFAULT);
                logger.debug("Indexed series {} related to episode {}", (Object)seriesId, (Object)mediaPackageId);
            }
            catch (IOException e) {
                throw new SearchException((Throwable)e);
            }
        }
    }

    private AccessControlList addCustomAclRoles(String mediaPackageId, AccessControlList acl) {
        HashSet<AccessControlEntry> customEntries = new HashSet<AccessControlEntry>();
        customEntries.add(new AccessControlEntry(SecurityUtil.getEpisodeRoleId((String)mediaPackageId, (String)"READ"), "read", true));
        customEntries.add(new AccessControlEntry(SecurityUtil.getEpisodeRoleId((String)mediaPackageId, (String)"WRITE"), "write", true));
        ResourceListQueryImpl query = new ResourceListQueryImpl();
        if (this.listProvidersService.hasProvider("ACL.ACTIONS")) {
            Map actions = new HashMap();
            try {
                actions = this.listProvidersService.getList("ACL.ACTIONS", (ResourceListQuery)query, true);
            }
            catch (ListProviderException e) {
                throw new SearchException("Listproviders not loaded. " + String.valueOf((Object)e));
            }
            for (String action : actions.keySet()) {
                customEntries.add(new AccessControlEntry(SecurityUtil.getEpisodeRoleId((String)mediaPackageId, (String)action), action, true));
            }
        }
        return acl;
    }

    private void checkSearchEntityWritePermission(String mediaPackageId) throws SearchException {
        User user = this.securityService.getUser();
        try {
            if (!this.persistence.isAvailable(mediaPackageId)) {
                throw new NotFoundException();
            }
            AccessControlList acl = this.persistence.getAccessControlList(mediaPackageId);
            if (!AccessControlUtil.isAuthorized((AccessControlList)acl, (User)user, (Organization)this.securityService.getOrganization(), (Object)Permissions.Action.WRITE.toString(), (String)mediaPackageId)) {
                throw new UnauthorizedException(user, "Write permission denied for " + mediaPackageId, acl);
            }
        }
        catch (NotFoundException e) {
            logger.debug("Mediapackage {} does not exist or was deleted, allowing writes for user {}", (Object)mediaPackageId, (Object)user);
        }
        catch (SearchServiceDatabaseException | UnauthorizedException e) {
            throw new SearchException(e);
        }
    }

    public boolean deleteSynchronously(String mediaPackageId) throws SearchException {
        this.checkSearchEntityWritePermission(mediaPackageId);
        String deletionString = DateTimeFormatter.ISO_INSTANT.format(Instant.now());
        try {
            logger.info("Marking media package {} as deleted in search index", (Object)mediaPackageId);
            JsonElement json = this.gson.toJsonTree(Map.of("deleted", deletionString, "modified", deletionString));
            UpdateRequest updateRequst = new UpdateRequest(INDEX_NAME, mediaPackageId).doc(this.gson.toJson(json), XContentType.JSON);
            this.esIndex.getClient().update(updateRequst, RequestOptions.DEFAULT);
        }
        catch (ElasticsearchStatusException e) {
            if (e.status().getStatus() != RestStatus.NOT_FOUND.getStatus()) {
                throw e;
            }
            logger.warn("Event {} is not in the search index. Skipping deletion", (Object)mediaPackageId);
        }
        catch (IOException e) {
            throw new SearchException("Could not delete episode " + mediaPackageId + " from index", (Throwable)e);
        }
        try {
            logger.info("Marking media package {} as deleted in search database", (Object)mediaPackageId);
            String seriesId = null;
            Date now = new Date();
            try {
                seriesId = this.persistence.getMediaPackage(mediaPackageId).getSeries();
                this.persistence.deleteMediaPackage(mediaPackageId, now);
                logger.info("Removed media package {} from search persistence", (Object)mediaPackageId);
            }
            catch (NotFoundException e) {
                logger.info("Could not find media package with id {} in persistence, but will try remove it from index anyway.", (Object)mediaPackageId);
            }
            catch (SearchServiceDatabaseException | UnauthorizedException e) {
                throw new SearchException(String.format("Could not delete media package with id %s from persistence storage", mediaPackageId), e);
            }
            if (seriesId != null) {
                try {
                    if (!this.persistence.getSeries(seriesId).isEmpty()) {
                        AccessControlList seriesAcl = this.persistence.getAccessControlLists(seriesId, new String[0]).stream().map(aclPair -> this.addCustomAclRoles((String)aclPair.getKey(), (AccessControlList)aclPair.getValue())).reduce(new AccessControlList(), AccessControlList::mergeActions);
                        JsonElement json = this.gson.toJsonTree(Map.of("searchable_acl", SearchResult.dehydrateAclForIndex((AccessControlList)seriesAcl), "modified", deletionString));
                        UpdateRequest updateRequest = new UpdateRequest(INDEX_NAME, seriesId).doc(this.gson.toJson(json), XContentType.JSON);
                        try {
                            this.esIndex.getClient().update(updateRequest, RequestOptions.DEFAULT);
                        }
                        catch (ElasticsearchStatusException e) {
                            if (RestStatus.NOT_FOUND == e.status()) {
                                logger.warn("Attempted to modify {}, but that series does not exist in the index.", (Object)seriesId);
                            }
                        }
                    } else {
                        this.deleteSeriesSynchronously(seriesId);
                    }
                }
                catch (IOException e) {
                    throw new SearchException((Throwable)e);
                }
            }
            return true;
        }
        catch (SearchServiceDatabaseException e) {
            logger.info("Could not delete media package with id {} from search index", (Object)mediaPackageId);
            throw new SearchException((Throwable)e);
        }
    }

    public boolean deleteSeriesSynchronously(String seriesId) throws SearchException {
        try {
            logger.info("Marking {} as deleted in the search index", (Object)seriesId);
            JsonElement json = this.gson.toJsonTree(Map.of("deleted", Instant.now().getEpochSecond(), "modified", Instant.now().toString()));
            UpdateRequest updateRequest = new UpdateRequest(INDEX_NAME, seriesId).doc(this.gson.toJson(json), XContentType.JSON);
            try {
                UpdateResponse response = this.esIndex.getClient().update(updateRequest, RequestOptions.DEFAULT);
                return DocWriteResponse.Result.UPDATED == response.getResult();
            }
            catch (ElasticsearchStatusException e) {
                if (RestStatus.NOT_FOUND == e.status()) {
                    logger.debug("Attempted to delete {}, but that series does not exist in the index.", (Object)seriesId);
                    return true;
                }
                throw new SearchException((Throwable)e);
            }
        }
        catch (IOException e) {
            throw new SearchException("Could not delete series " + seriesId + " from index", (Throwable)e);
        }
    }

    public void repopulate(IndexRebuildService.DataType type) throws IndexRebuildException {
        Organization originalOrg = this.securityService.getOrganization();
        User originalUser = this.securityService.getUser();
        try {
            int total = this.persistence.countMediaPackages();
            int pageSize = 50;
            int pageOffset = 0;
            AtomicInteger current = new AtomicInteger(1);
            this.logIndexRebuildBegin(logger, total, "search");
            List<Tuple> page = null;
            do {
                page = this.persistence.getAllMediaPackages(pageSize, pageOffset).collect(Collectors.toList());
                page.forEach(tuple -> {
                    try {
                        MediaPackage mediaPackage = (MediaPackage)tuple.getA();
                        Organization organization = this.organizationDirectory.getOrganization((String)tuple.getB());
                        User systemUser = SecurityUtil.createSystemUser((String)this.systemUserName, (Organization)organization);
                        this.securityService.setUser(systemUser);
                        this.securityService.setOrganization(organization);
                        String mediaPackageId = mediaPackage.getIdentifier().toString();
                        AccessControlList acl = this.persistence.getAccessControlList(mediaPackageId);
                        Date modificationDate = this.persistence.getModificationDate(mediaPackageId);
                        Date deletionDate = this.persistence.getDeletionDate(mediaPackageId);
                        current.getAndIncrement();
                        this.indexMediaPackage(mediaPackage, acl, modificationDate, deletionDate);
                    }
                    catch (SearchServiceDatabaseException e) {
                        this.logIndexRebuildError(logger, total, current.get(), e);
                        throw new RuntimeException("Internal Index Rebuild Failure", e);
                    }
                    catch (RuntimeException | NotFoundException e) {
                        this.logSkippingElement(logger, "event", ((MediaPackage)tuple.getA()).getIdentifier().toString(), e);
                    }
                });
                this.logIndexRebuildProgress(logger, total, current.get() - 1, pageSize);
            } while (++pageOffset * pageSize <= total);
        }
        catch (RuntimeException | SearchServiceDatabaseException e) {
            this.logIndexRebuildError(logger, e);
            throw new IndexRebuildException("Index Rebuild Failure", (Throwable)e);
        }
        finally {
            this.securityService.setUser(originalUser);
            this.securityService.setOrganization(originalOrg);
        }
    }

    @Reference
    public void setPersistence(SearchServiceDatabase persistence) {
        this.persistence = persistence;
    }

    @Reference
    public void setSeriesService(SeriesService seriesService) {
        this.seriesService = seriesService;
    }

    @Reference
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Reference
    public void setAuthorizationService(AuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    public void setOrganizationDirectoryService(OrganizationDirectoryService organizationDirectory) {
        this.organizationDirectory = organizationDirectory;
    }

    @Reference
    public void setListProvidersService(ListProvidersService listProvidersService) {
        this.listProvidersService = listProvidersService;
    }
}

