/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.search.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.Pair;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.opencastproject.job.api.AbstractJobProducer;
import org.opencastproject.job.api.Job;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageParser;
import org.opencastproject.search.api.SearchException;
import org.opencastproject.search.api.SearchResultList;
import org.opencastproject.search.api.SearchService;
import org.opencastproject.search.impl.SearchServiceIndex;
import org.opencastproject.search.impl.persistence.SearchServiceDatabase;
import org.opencastproject.search.impl.persistence.SearchServiceDatabaseException;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.StaticFileAuthorization;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.security.api.User;
import org.opencastproject.security.api.UserDirectoryService;
import org.opencastproject.security.util.SecurityUtil;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.serviceregistry.api.ServiceRegistryException;
import org.opencastproject.util.LoadUtil;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.data.Tuple;
import org.opencastproject.util.data.functions.Functions;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={SearchService.class, SearchServiceImpl.class, StaticFileAuthorization.class}, property={"service.description=Search Service", "service.pid=org.opencastproject.search.impl.SearchServiceImpl"})
public final class SearchServiceImpl
extends AbstractJobProducer
implements SearchService,
StaticFileAuthorization {
    private static final Logger logger = LoggerFactory.getLogger(SearchServiceImpl.class);
    public static final String JOB_TYPE = "org.opencastproject.search";
    public static final float DEFAULT_ADD_JOB_LOAD = 0.1f;
    public static final float DEFAULT_DELETE_JOB_LOAD = 0.1f;
    public static final String ADD_JOB_LOAD_KEY = "job.load.add";
    public static final String DELETE_JOB_LOAD_KEY = "job.load.delete";
    private float addJobLoad = 0.1f;
    private float deleteJobLoad = 0.1f;
    private SearchServiceIndex index;
    private SecurityService securityService;
    private ServiceRegistry serviceRegistry;
    private SearchServiceDatabase persistence;
    protected UserDirectoryService userDirectoryService = null;
    protected OrganizationDirectoryService organizationDirectory = null;
    private final LoadingCache<Tuple<User, String>, Boolean> cache = CacheBuilder.newBuilder().maximumSize(2048L).expireAfterWrite(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Tuple<User, String>, Boolean>(){

        public Boolean load(Tuple<User, String> key) {
            return SearchServiceImpl.this.loadUrlAccess((String)key.getB());
        }
    });
    private static final Pattern staticFilePattern = Pattern.compile("^/([^/]+)/(?:engage-player|engage-live)/([^/]+)/.*$");

    public SearchServiceImpl() {
        super(JOB_TYPE);
    }

    @Activate
    public void activate(ComponentContext cc) throws IllegalStateException {
        super.activate(cc);
    }

    public Job add(MediaPackage mediaPackage) throws SearchException, IllegalArgumentException {
        try {
            return this.serviceRegistry.createJob(JOB_TYPE, Operation.Add.toString(), Collections.singletonList(MediaPackageParser.getAsXml((MediaPackage)mediaPackage)), Float.valueOf(this.addJobLoad));
        }
        catch (ServiceRegistryException e) {
            throw new SearchException((Throwable)e);
        }
    }

    public void addSynchronously(MediaPackage mediaPackage) throws SearchException, IllegalArgumentException, UnauthorizedException {
        try {
            this.index.addSynchronously(mediaPackage);
        }
        catch (SearchServiceDatabaseException e) {
            throw new SearchException((Throwable)e);
        }
    }

    public Collection<Pair<Organization, MediaPackage>> getSeries(String seriesId) {
        try {
            return this.persistence.getSeries(seriesId);
        }
        catch (SearchServiceDatabaseException e) {
            throw new SearchException((Throwable)e);
        }
    }

    public Job delete(String mediaPackageId) throws SearchException {
        try {
            return this.serviceRegistry.createJob(JOB_TYPE, Operation.Delete.toString(), Collections.singletonList(mediaPackageId), Float.valueOf(this.deleteJobLoad));
        }
        catch (ServiceRegistryException e) {
            throw new SearchException((Throwable)e);
        }
    }

    public boolean deleteSynchronously(String mediaPackageId) throws SearchException {
        return this.index.deleteSynchronously(mediaPackageId);
    }

    public Job deleteSeries(String seriesId) throws SearchException {
        try {
            return this.serviceRegistry.createJob(JOB_TYPE, Operation.DeleteSeries.toString(), Collections.singletonList(seriesId), Float.valueOf(this.deleteJobLoad));
        }
        catch (ServiceRegistryException e) {
            throw new SearchException((Throwable)e);
        }
    }

    public MediaPackage get(String mediaPackageId) throws NotFoundException, UnauthorizedException {
        try {
            return this.persistence.getMediaPackage(mediaPackageId);
        }
        catch (SearchServiceDatabaseException e) {
            throw new SearchException((Throwable)e);
        }
    }

    public SearchResultList search(SearchSourceBuilder searchSource) throws SearchException {
        SearchResponse idxResp = this.index.search(searchSource);
        return new SearchResultList(idxResp.getHits());
    }

    protected String process(Job job) throws Exception {
        Operation op = null;
        String operation = job.getOperation();
        List arguments = job.getArguments();
        try {
            op = Operation.valueOf(operation);
            Organization org = this.organizationDirectory.getOrganization(job.getOrganization());
            User user = this.userDirectoryService.loadUser(job.getCreator());
            boolean[] deleted = new boolean[1];
            switch (op.ordinal()) {
                case 0: {
                    MediaPackage mediaPackage = MediaPackageParser.getFromXml((String)((String)arguments.get(0)));
                    SecurityUtil.runAs((SecurityService)this.securityService, (Organization)org, (User)user, () -> {
                        try {
                            this.index.addSynchronously(mediaPackage);
                        }
                        catch (SearchServiceDatabaseException | UnauthorizedException e) {
                            Functions.chuck((Throwable)e);
                        }
                    });
                    return null;
                }
                case 1: {
                    String mediapackageId = (String)arguments.get(0);
                    SecurityUtil.runAs((SecurityService)this.securityService, (Organization)org, (User)user, () -> {
                        deleted[0] = this.index.deleteSynchronously(mediapackageId);
                    });
                    return Boolean.toString(deleted[0]);
                }
                case 2: {
                    String seriesId = (String)arguments.get(0);
                    SecurityUtil.runAs((SecurityService)this.securityService, (Organization)org, (User)user, () -> {
                        deleted[0] = this.index.deleteSeriesSynchronously(seriesId);
                    });
                    return Boolean.toString(deleted[0]);
                }
            }
            throw new IllegalStateException("Don't know how to handle operation '" + operation + "'");
        }
        catch (IllegalArgumentException e) {
            throw new ServiceRegistryException("This service can't handle operations of type '" + String.valueOf((Object)op) + "'", (Throwable)e);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ServiceRegistryException("This argument list for operation '" + String.valueOf((Object)op) + "' does not meet expectations", (Throwable)e);
        }
        catch (Exception e) {
            throw new ServiceRegistryException("Error handling operation '" + String.valueOf((Object)op) + "'", (Throwable)e);
        }
    }

    @Reference
    public void setSearchIndex(SearchServiceIndex ssi) {
        this.index = ssi;
    }

    @Reference
    public void setPersistence(SearchServiceDatabase persistence) {
        this.persistence = persistence;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    @Reference
    public void setOrganizationDirectoryService(OrganizationDirectoryService organizationDirectory) {
        this.organizationDirectory = organizationDirectory;
    }

    protected OrganizationDirectoryService getOrganizationDirectoryService() {
        return this.organizationDirectory;
    }

    protected SecurityService getSecurityService() {
        return this.securityService;
    }

    protected ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    protected UserDirectoryService getUserDirectoryService() {
        return this.userDirectoryService;
    }

    @Modified
    public void modified(Map<String, Object> properties) {
        if (properties == null) {
            logger.info("No configuration available, using defaults");
            properties = Map.of();
        }
        logger.info("Configuring SearchServiceImpl");
        this.addJobLoad = LoadUtil.getConfiguredLoadValue(properties, (String)ADD_JOB_LOAD_KEY, (Float)Float.valueOf(0.1f), (ServiceRegistry)this.serviceRegistry);
        this.deleteJobLoad = LoadUtil.getConfiguredLoadValue(properties, (String)DELETE_JOB_LOAD_KEY, (Float)Float.valueOf(0.1f), (ServiceRegistry)this.serviceRegistry);
    }

    public List<Pattern> getProtectedUrlPattern() {
        return Collections.singletonList(staticFilePattern);
    }

    private boolean loadUrlAccess(String mediaPackageId) {
        logger.debug("Check if user `{}` has access to media package `{}`", (Object)this.securityService.getUser(), (Object)mediaPackageId);
        try {
            this.persistence.getMediaPackage(mediaPackageId);
        }
        catch (SearchServiceDatabaseException | UnauthorizedException | NotFoundException e) {
            return false;
        }
        return true;
    }

    public boolean verifyUrlAccess(String path) {
        User user = this.securityService.getUser();
        if (user.hasRole("ROLE_ADMIN")) {
            logger.debug("Allow access for admin `{}`", (Object)user);
            return true;
        }
        Matcher m = staticFilePattern.matcher(path);
        if (!m.matches()) {
            logger.debug("Path does not match pattern. Preventing access.");
            return false;
        }
        String organizationId = m.group(1);
        if (!this.securityService.getOrganization().getId().equals(organizationId)) {
            logger.debug("The user's organization does not match. Preventing access.");
            return false;
        }
        String mediaPackageId = m.group(2);
        boolean access = (Boolean)this.cache.getUnchecked((Object)Tuple.tuple((Object)user, (Object)mediaPackageId));
        logger.debug("Check if user `{}` has access to media package `{}` using cache: {}", new Object[]{user, mediaPackageId, access});
        return access;
    }

    private static enum Operation {
        Add,
        Delete,
        DeleteSeries;

    }
}

