/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.search.endpoint;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.opencastproject.job.api.JobProducer;
import org.opencastproject.metadata.dublincore.DublinCore;
import org.opencastproject.rest.AbstractJobProducerEndpoint;
import org.opencastproject.search.api.SearchException;
import org.opencastproject.search.api.SearchResult;
import org.opencastproject.search.api.SearchResultList;
import org.opencastproject.search.api.SearchService;
import org.opencastproject.search.impl.SearchServiceImpl;
import org.opencastproject.search.impl.SearchServiceIndex;
import org.opencastproject.security.api.Role;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.security.api.User;
import org.opencastproject.security.urlsigning.exception.UrlSigningException;
import org.opencastproject.security.urlsigning.service.UrlSigningService;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.RestUtil;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/search")
@RestService(name="search", title="Search Service", abstractText="This service indexes and queries available (distributed) episodes.", notes={"All paths above are relative to the REST endpoint base (something like http://your.server/files)", "If the service is down or not working it will return a status 503, this means the the underlying service is not working and is either restarting or has failed", "A status code 500 means a general failure has occurred which is not recoverable and was not anticipated. In other words, there is a bug! You should file an error report with your server logs from the time when the error occurred: <a href=\"https://github.com/opencast/opencast/issues\">Opencast Issue Tracker</a>"})
@Component(immediate=true, service={SearchRestService.class}, property={"service.description=Search REST Endpoint", "opencast.service.type=org.opencastproject.search", "opencast.service.path=/search", "opencast.service.jobproducer=true"})
@JaxrsResource
public class SearchRestService
extends AbstractJobProducerEndpoint {
    private static final Logger logger = LoggerFactory.getLogger(SearchRestService.class);
    protected SearchServiceImpl searchService;
    protected SearchServiceIndex searchIndex;
    private ServiceRegistry serviceRegistry;
    private SecurityService securityService;
    private final Gson gson = new Gson();
    private UrlSigningService urlSigningService;

    @GET
    @Path(value="series.json")
    @Produces(value={"application/json"})
    @RestQuery(name="get_series", description="Search for series matching the query parameters.", restParameters={@RestParameter(name="id", isRequired=false, type=RestParameter.Type.STRING, description="The series ID. If the additional boolean parameter \"episodes\" is \"true\", the result set will include this series episodes."), @RestParameter(name="q", isRequired=false, type=RestParameter.Type.STRING, description="Any series that matches this free-text query."), @RestParameter(name="sort", isRequired=false, type=RestParameter.Type.STRING, description="The sort order.  May include any of the following dublin core metadata: identifier, title, contributor, creator, created, modified. Add ' asc' or ' desc' to specify the sort order (e.g. 'title desc')."), @RestParameter(name="limit", isRequired=false, type=RestParameter.Type.INTEGER, defaultValue="20", description="The maximum number of items to return per page."), @RestParameter(name="offset", isRequired=false, type=RestParameter.Type.INTEGER, defaultValue="0", description="The page number.")}, responses={@RestResponse(description="The request was processed successfully.", responseCode=200)}, returnDescription="The search results, formatted as XML or JSON.")
    public Response getSeries(@QueryParam(value="id") String id, @QueryParam(value="q") String text, @QueryParam(value="sort") String sort, @QueryParam(value="limit") String limit, @QueryParam(value="offset") String offset) throws SearchException {
        String org = this.securityService.getOrganization().getId();
        String type = SearchService.IndexEntryType.Series.name();
        BoolQueryBuilder query = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"org", (String)org)).must((QueryBuilder)QueryBuilders.termQuery((String)"type", (String)type)).mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"deleted"));
        if (StringUtils.isNotEmpty((CharSequence)id)) {
            query.must((QueryBuilder)QueryBuilders.idsQuery().addIds(new String[]{id}));
        }
        if (StringUtils.isNotEmpty((CharSequence)text)) {
            query.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"fulltext", (String)("*" + text.toLowerCase() + "*")));
        }
        User user = this.securityService.getUser();
        String orgAdminRole = this.securityService.getOrganization().getAdminRole();
        if (!user.hasRole("ROLE_ADMIN") && !user.hasRole(orgAdminRole)) {
            query.must((QueryBuilder)QueryBuilders.termsQuery((String)"searchable_acl.read", (Collection)user.getRoles().stream().map(Role::getName).collect(Collectors.toList())));
        }
        int size = NumberUtils.toInt((String)limit, (int)20);
        int from = NumberUtils.toInt((String)offset);
        if (size < 0 || from < 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Limit and offset may not be negative.").build();
        }
        SearchSourceBuilder searchSource = new SearchSourceBuilder().query((QueryBuilder)query).from(from).size(size);
        if (StringUtils.isNotEmpty((CharSequence)sort)) {
            boolean validOrder;
            String[] sortParam = StringUtils.split((String)sort.toLowerCase());
            boolean validSort = Arrays.asList("identifier", "title", "contributor", "creator", "created", "modified").contains(sortParam[0]);
            boolean bl = validOrder = sortParam.length < 2 || Arrays.asList("asc", "desc").contains(sortParam[1]);
            if (sortParam.length > 2 || !validSort || !validOrder) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid sort parameter").build();
            }
            SortOrder order = SortOrder.fromString((String)(sortParam.length > 1 ? sortParam[1] : "asc"));
            if ("modified".equals(sortParam[0])) {
                searchSource.sort(sortParam[0], order);
            } else {
                searchSource.sort("dc." + sortParam[0], order);
            }
        }
        SearchHits hits = this.searchIndex.search(searchSource).getHits();
        List result = Arrays.stream(hits.getHits()).map(SearchHit::getSourceAsMap).peek(hit -> hit.remove("type")).collect(Collectors.toList());
        long total = hits.getTotalHits().value;
        JsonElement json = this.gson.toJsonTree(Map.of("offset", from, "total", total, "result", result, "limit", size));
        return Response.ok((Object)this.gson.toJson(json)).build();
    }

    @GET
    @Path(value="episode.json")
    @Produces(value={"application/json"})
    @RestQuery(name="search_episodes", description="Search for episodes matching the query parameters.", restParameters={@RestParameter(name="id", isRequired=false, type=RestParameter.Type.STRING, description="The ID of the single episode to be returned, if it exists."), @RestParameter(name="q", isRequired=false, type=RestParameter.Type.STRING, description="Any episode that matches this free-text query."), @RestParameter(name="sid", isRequired=false, type=RestParameter.Type.STRING, description="Any episode that belongs to specified series id."), @RestParameter(name="sname", isRequired=false, type=RestParameter.Type.STRING, description="Any episode that belongs to specified series name (note that the specified series name must be unique)."), @RestParameter(name="sort", isRequired=false, type=RestParameter.Type.STRING, description="The sort order.  May include any of the following dublin core metadata: title, contributor, creator, created, modified. Add ' asc' or ' desc' to specify the sort order (e.g. 'title desc')."), @RestParameter(name="limit", isRequired=false, type=RestParameter.Type.INTEGER, defaultValue="20", description="The maximum number of items to return per page. Limited to 250 for non-admins."), @RestParameter(name="offset", isRequired=false, type=RestParameter.Type.INTEGER, defaultValue="0", description="The page number."), @RestParameter(name="sign", isRequired=false, type=RestParameter.Type.BOOLEAN, defaultValue="true", description="If results are to be signed")}, responses={@RestResponse(description="The request was processed successfully.", responseCode=200)}, returnDescription="The search results, formatted as xml or json.")
    public Response getEpisodes(@QueryParam(value="id") String id, @QueryParam(value="q") String text, @QueryParam(value="sid") String seriesId, @QueryParam(value="sname") String seriesName, @QueryParam(value="sort") String sort, @QueryParam(value="limit") String limit, @QueryParam(value="offset") String offset, @QueryParam(value="sign") String sign) throws SearchException {
        boolean bl;
        SearchSourceBuilder seriesSearchSource;
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{seriesName, seriesId})) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"invalid request, both 'sid' and 'sname' specified").build();
        }
        String org = this.securityService.getOrganization().getId();
        String type = SearchService.IndexEntryType.Episode.name();
        boolean snameNotFound = false;
        List<Object> series = Collections.emptyList();
        if (StringUtils.isNotEmpty((CharSequence)seriesName) && (series = this.searchService.search(seriesSearchSource = new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)"org", (String)org)).filter((QueryBuilder)QueryBuilders.termQuery((String)"type", (Object)SearchService.IndexEntryType.Series)).filter((QueryBuilder)QueryBuilders.termQuery((String)"dc.title", (String)seriesName)).mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"deleted")))).getHits().stream().map(h -> h.getDublinCore().getFirst(DublinCore.PROPERTY_IDENTIFIER)).collect(Collectors.toList())).isEmpty()) {
            snameNotFound = true;
        }
        BoolQueryBuilder query = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)"org", (String)org)).filter((QueryBuilder)QueryBuilders.termQuery((String)"type", (String)type)).mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"deleted"));
        if (StringUtils.isNotEmpty((CharSequence)id)) {
            query.filter((QueryBuilder)QueryBuilders.idsQuery().addIds(new String[]{id}));
        }
        if (StringUtils.isNotEmpty((CharSequence)seriesId)) {
            series = Collections.singletonList(seriesId);
        }
        if (!series.isEmpty()) {
            if (series.size() == 1) {
                query.must((QueryBuilder)QueryBuilders.termQuery((String)"dc.isPartOf", (String)((String)series.get(0))));
            } else {
                BoolQueryBuilder seriesQuery = QueryBuilders.boolQuery();
                for (String string : series) {
                    seriesQuery.should((QueryBuilder)QueryBuilders.termQuery((String)"dc.isPartOf", (String)string));
                }
                query.must((QueryBuilder)seriesQuery);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)text)) {
            query.minimumShouldMatch(1);
            query.should((QueryBuilder)QueryBuilders.matchQuery((String)"fulltext", (Object)text).fuzziness((Object)"AUTO").operator(Operator.AND));
        }
        User user = this.securityService.getUser();
        String orgAdminRole = this.securityService.getOrganization().getAdminRole();
        boolean bl2 = bl = user.hasRole("ROLE_ADMIN") || user.hasRole(orgAdminRole);
        if (!bl) {
            query.must((QueryBuilder)QueryBuilders.termsQuery((String)"searchable_acl.read", (Collection)user.getRoles().stream().map(Role::getName).collect(Collectors.toList())));
        }
        logger.debug("limit: {}, offset: {}", (Object)limit, (Object)offset);
        int size = NumberUtils.toInt((String)limit, (int)20);
        int from = NumberUtils.toInt((String)offset);
        if (size < 0 || from < 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Limit and offset may not be negative.").build();
        }
        if (!bl && size > 250) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Only admins are allowed to request more than 250 items.").build();
        }
        SearchSourceBuilder searchSource = new SearchSourceBuilder().query((QueryBuilder)query).from(from).size(size);
        if (StringUtils.isNotEmpty((CharSequence)sort)) {
            boolean validOrder;
            String[] sortParam = StringUtils.split((String)sort.toLowerCase());
            boolean validSort = Arrays.asList("title", "contributor", "creator", "created", "modified").contains(sortParam[0]);
            boolean bl3 = validOrder = sortParam.length < 2 || Arrays.asList("asc", "desc").contains(sortParam[1]);
            if (sortParam.length > 2 || !validSort || !validOrder) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Invalid sort parameter").build();
            }
            SortOrder order = SortOrder.fromString((String)(sortParam.length > 1 ? sortParam[1] : "asc"));
            if ("modified".equals(sortParam[0])) {
                searchSource.sort(sortParam[0], order);
            } else {
                searchSource.sort("dc." + sortParam[0], order);
            }
        }
        List result = null;
        long total = 0L;
        if (snameNotFound) {
            result = Collections.emptyList();
        } else {
            SearchResultList hits = this.searchService.search(searchSource);
            result = hits.getHits().stream().map(SearchResult::dehydrateForREST).collect(Collectors.toList());
            if (!"false".equals(sign) && this.urlSigningService != null) {
                this.findURLsAndSign(result);
            }
            total = hits.getTotalHits();
        }
        String json = this.gson.toJson(Map.of("offset", from, "total", total, "result", result, "limit", size));
        return Response.ok((Object)json).build();
    }

    @POST
    @Path(value="updateIndex")
    @RestQuery(name="updateIndex", description="Trigger search index update for event. The usage of this is limited to global administrators.", restParameters={@RestParameter(name="id", isRequired=true, type=RestParameter.Type.STRING, description="The event ID to trigger an index update for.")}, responses={@RestResponse(description="Update successfully triggered.", responseCode=204), @RestResponse(description="Not allowed to trigger update.", responseCode=403), @RestResponse(description="No such event found.", responseCode=404)}, returnDescription="No content is returned.")
    public Response indexUpdate(@FormParam(value="id") String id) {
        try {
            this.searchIndex.indexMediaPackage(id);
            return RestUtil.R.noContent();
        }
        catch (UnauthorizedException e) {
            return RestUtil.R.forbidden();
        }
        catch (NotFoundException e) {
            return RestUtil.R.notFound();
        }
        catch (Exception e) {
            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private void findURLsAndSign(Object obj) {
        block6: {
            block5: {
                if (!(obj instanceof Map)) break block5;
                Map map = (Map)obj;
                for (Map.Entry entry : map.entrySet()) {
                    if (((String)entry.getKey()).equals("url") && entry.getValue() instanceof String) {
                        String urlToSign = (String)entry.getValue();
                        if (!this.urlSigningService.accepts(urlToSign)) continue;
                        try {
                            String signedUrl = this.urlSigningService.sign(urlToSign, Long.valueOf(7200L), null, null);
                            map.put((String)entry.getKey(), signedUrl);
                        }
                        catch (UrlSigningException e) {
                            logger.debug("Unable to sign url '{}'.", (Object)urlToSign);
                        }
                        continue;
                    }
                    this.findURLsAndSign(entry.getValue());
                }
                break block6;
            }
            if (!(obj instanceof List)) break block6;
            for (Object item : (List)obj) {
                this.findURLsAndSign(item);
            }
        }
    }

    public JobProducer getService() {
        return this.searchService;
    }

    @Reference
    public void setSearchService(SearchServiceImpl searchService) {
        this.searchService = searchService;
    }

    @Reference
    public void setSearchIndex(SearchServiceIndex searchIndex) {
        this.searchIndex = searchIndex;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    void setUrlSigningService(UrlSigningService service) {
        this.urlSigningService = service;
    }
}

