/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.search.api;

import com.google.gson.Gson;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.opencastproject.mediapackage.EName;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageException;
import org.opencastproject.mediapackage.MediaPackageParser;
import org.opencastproject.metadata.dublincore.DublinCore;
import org.opencastproject.metadata.dublincore.DublinCoreCatalog;
import org.opencastproject.metadata.dublincore.DublinCoreValue;
import org.opencastproject.metadata.dublincore.DublinCores;
import org.opencastproject.metadata.dublincore.OpencastDctermsDublinCore;
import org.opencastproject.search.api.SearchException;
import org.opencastproject.search.api.SearchService;
import org.opencastproject.security.api.AccessControlEntry;
import org.opencastproject.security.api.AccessControlList;

public class SearchResult {
    public static final String TYPE = "type";
    public static final String MEDIAPACKAGE = "mediapackage";
    public static final String MEDIAPACKAGE_XML = "mediapackage_xml";
    public static final String DUBLINCORE = "dc";
    public static final String ORG = "org";
    public static final String MODIFIED_DATE = "modified";
    public static final String DELETED_DATE = "deleted";
    public static final String INDEX_ACL = "searchable_acl";
    public static final String REST_ACL = "acl";
    private static final Gson gson = new Gson();
    private SearchService.IndexEntryType type;
    private MediaPackage mp;
    private DublinCoreCatalog dublinCore;
    private AccessControlList acl;
    private String orgId;
    private String id = null;
    private Instant modified = null;
    private Instant deleted = null;

    public SearchResult(SearchService.IndexEntryType type, DublinCoreCatalog dc, AccessControlList acl, String orgId, MediaPackage mp, Instant modified, Instant deleted) {
        this.type = type;
        this.dublinCore = dc;
        this.acl = acl;
        this.orgId = orgId;
        this.mp = mp;
        this.deleted = deleted;
        this.modified = modified;
        if (SearchService.IndexEntryType.Episode.equals((Object)type)) {
            this.id = this.getMediaPackage().getIdentifier().toString();
        } else if (SearchService.IndexEntryType.Series.equals((Object)type)) {
            this.id = this.dublinCore.getFirst(DublinCore.PROPERTY_IDENTIFIER);
        }
    }

    public Date getModifiedDate() {
        return new Date(this.modified.toEpochMilli());
    }

    public String getId() {
        return this.id;
    }

    public Date getDeletionDate() {
        return null == this.deleted ? null : new Date(this.deleted.toEpochMilli());
    }

    public static SearchResult rehydrate(Map<String, Object> data) throws SearchException {
        try {
            SearchService.IndexEntryType type = SearchService.IndexEntryType.valueOf((String)data.get(TYPE));
            DublinCoreCatalog dc = SearchResult.rehydrateDC(type, (Map)data.get(DUBLINCORE));
            AccessControlList acl = SearchResult.rehydrateACL((Map)data.get(INDEX_ACL));
            String org = (String)data.get(ORG);
            Instant deleted = null;
            if (data.containsKey(DELETED_DATE) && null != data.get(DELETED_DATE)) {
                deleted = Instant.parse((String)data.get(DELETED_DATE));
            }
            Instant modified = null;
            if (data.containsKey(MODIFIED_DATE) && !data.get(MODIFIED_DATE).equals("null")) {
                modified = Instant.parse((String)data.get(MODIFIED_DATE));
            }
            MediaPackage mp = null;
            if (SearchService.IndexEntryType.Episode.equals((Object)type)) {
                mp = MediaPackageParser.getFromXml((String)((String)data.get(MEDIAPACKAGE_XML)));
            }
            return new SearchResult(type, dc, acl, org, mp, modified, deleted);
        }
        catch (MediaPackageException e) {
            throw new SearchException(e);
        }
    }

    public static Map<String, List<String>> dehydrateDC(DublinCoreCatalog dublinCoreCatalog) {
        HashMap<String, List<String>> metadata = new HashMap<String, List<String>>();
        for (Map.Entry entry : dublinCoreCatalog.getValues().entrySet()) {
            String key = ((EName)entry.getKey()).getLocalName();
            List values = ((List)entry.getValue()).stream().map(DublinCoreValue::getValue).map(val -> {
                if (((EName)entry.getKey()).equals((Object)DublinCore.PROPERTY_CREATED)) {
                    TemporalAccessor date = DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER.parse(val);
                    return DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER.withZone((ZoneId)ZoneOffset.UTC).format(date);
                }
                return val;
            }).collect(Collectors.toList());
            metadata.put(key, values);
        }
        return metadata;
    }

    public static Map<String, Set<String>> dehydrateAclForIndex(AccessControlList acl) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (AccessControlEntry entry : acl.getEntries()) {
            String action = entry.getAction();
            if (!result.containsKey(action)) {
                result.put(action, new HashSet());
            }
            result.get(action).add(entry.getRole());
        }
        return result;
    }

    public static List<Map<String, ?>> dehydrateAclForREST(AccessControlList acl) {
        return acl.getEntries().stream().map(ace -> Map.of("action", ace.getAction(), "role", ace.getRole(), "allow", Boolean.TRUE)).collect(Collectors.toList());
    }

    public static AccessControlList rehydrateACL(Map<String, Object> map) {
        LinkedList<AccessControlEntry> aces = new LinkedList<AccessControlEntry>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String action = entry.getKey();
            for (String rolename : (List)entry.getValue()) {
                AccessControlEntry ace = new AccessControlEntry(rolename, action, true);
                aces.add(ace);
            }
        }
        return new AccessControlList(aces);
    }

    public static DublinCoreCatalog rehydrateDC(SearchService.IndexEntryType type, Map<String, Object> map) throws SearchException {
        OpencastDctermsDublinCore.Episode dc;
        if (SearchService.IndexEntryType.Episode.equals((Object)type)) {
            dc = DublinCores.mkOpencastEpisode();
        } else if (SearchService.IndexEntryType.Series.equals((Object)type)) {
            dc = DublinCores.mkOpencastSeries();
        } else {
            throw new SearchException("Unknown DC type!");
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            List value = (List)entry.getValue();
            dc.set(EName.mk((String)"http://purl.org/dc/terms/", (String)key), value);
        }
        return dc.getCatalog();
    }

    public Map<String, Object> dehydrateForIndex() {
        return this.dehydrate().entrySet().stream().filter(entry -> !((String)entry.getKey()).equals(REST_ACL)).collect(HashMap::new, (m, v) -> m.put((String)v.getKey(), v.getValue()), HashMap::putAll);
    }

    public Map<String, Object> dehydrateForREST() {
        return this.dehydrate().entrySet().stream().filter(entry -> !((String)entry.getKey()).equals(INDEX_ACL)).filter(entry -> !((String)entry.getKey()).equals(MEDIAPACKAGE_XML)).collect(HashMap::new, (m, v) -> m.put((String)v.getKey(), v.getValue()), HashMap::putAll);
    }

    public Map<String, Object> dehydrate() {
        if (SearchService.IndexEntryType.Episode.equals((Object)this.getType())) {
            return this.dehydrateEpisode();
        }
        if (SearchService.IndexEntryType.Series.equals((Object)this.getType())) {
            return this.dehydrateSeries();
        }
        return null;
    }

    public Map<String, Object> dehydrateEpisode() {
        HashMap<String, Object> ret = new HashMap<String, Object>(Map.of(MEDIAPACKAGE, ((Map)gson.fromJson(MediaPackageParser.getAsJSON((MediaPackage)this.mp), Map.class)).get(MEDIAPACKAGE), MEDIAPACKAGE_XML, MediaPackageParser.getAsXml((MediaPackage)this.mp), INDEX_ACL, SearchResult.dehydrateAclForIndex(this.acl), REST_ACL, SearchResult.dehydrateAclForREST(this.acl), DUBLINCORE, SearchResult.dehydrateDC(this.dublinCore), ORG, this.orgId, TYPE, this.type.name(), MODIFIED_DATE, DateTimeFormatter.ISO_INSTANT.format(this.modified)));
        ret.put(DELETED_DATE, null == this.deleted ? null : DateTimeFormatter.ISO_INSTANT.format(this.deleted));
        return ret;
    }

    public Map<String, Object> dehydrateSeries() {
        HashMap<String, Object> ret = new HashMap<String, Object>(Map.of(INDEX_ACL, SearchResult.dehydrateAclForIndex(this.acl), REST_ACL, SearchResult.dehydrateAclForREST(this.acl), DUBLINCORE, SearchResult.dehydrateDC(this.dublinCore), ORG, this.orgId, TYPE, this.type.name(), MODIFIED_DATE, DateTimeFormatter.ISO_INSTANT.format(this.modified)));
        ret.put(DELETED_DATE, null == this.deleted ? null : DateTimeFormatter.ISO_INSTANT.format(this.deleted));
        return ret;
    }

    public DublinCoreCatalog getDublinCore() {
        return this.dublinCore;
    }

    public AccessControlList getAcl() {
        return this.acl;
    }

    public MediaPackage getMediaPackage() {
        return this.mp;
    }

    public SearchService.IndexEntryType getType() {
        return this.type;
    }

    public Instant getCreatedDate() {
        TemporalAccessor acc = DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER.parse(this.dublinCore.getFirst(DublinCore.PROPERTY_CREATED));
        return Instant.from(acc);
    }

    public String getOrgId() {
        return this.orgId;
    }
}

