/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.scheduler.remote;

import com.entwinemedia.fn.data.Opt;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.property.RRule;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.opencastproject.mediapackage.MediaPackage;
import org.opencastproject.mediapackage.MediaPackageParser;
import org.opencastproject.metadata.dublincore.DublinCoreCatalog;
import org.opencastproject.metadata.dublincore.DublinCores;
import org.opencastproject.scheduler.api.Recording;
import org.opencastproject.scheduler.api.RecordingImpl;
import org.opencastproject.scheduler.api.SchedulerConflictException;
import org.opencastproject.scheduler.api.SchedulerException;
import org.opencastproject.scheduler.api.SchedulerService;
import org.opencastproject.scheduler.api.TechnicalMetadata;
import org.opencastproject.scheduler.api.TechnicalMetadataImpl;
import org.opencastproject.security.api.TrustedHttpClient;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.serviceregistry.api.RemoteBase;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.DateTimeSupport;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.UrlSupport;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={SchedulerService.class}, property={"service.description=Scheduler Remote Service Proxy"})
public class SchedulerServiceRemoteImpl
extends RemoteBase
implements SchedulerService {
    private static final Logger logger = LoggerFactory.getLogger(SchedulerServiceRemoteImpl.class);
    private final JSONParser parser = new JSONParser();

    public SchedulerServiceRemoteImpl() {
        super("org.opencastproject.scheduler");
    }

    public void addEvent(Date startDateTime, Date endDateTime, String captureAgentId, Set<String> userIds, MediaPackage mediaPackage, Map<String, String> wfProperties, Map<String, String> caMetadata, Opt<String> schedulingSource) throws UnauthorizedException, SchedulerConflictException, SchedulerException {
        HttpPost post = new HttpPost("/");
        String eventId = mediaPackage.getIdentifier().toString();
        logger.debug("Start adding a new event {} through remote Schedule Service", (Object)eventId);
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("start", Long.toString(startDateTime.getTime())));
        params.add(new BasicNameValuePair("end", Long.toString(endDateTime.getTime())));
        params.add(new BasicNameValuePair("agent", captureAgentId));
        params.add(new BasicNameValuePair("users", StringUtils.join(userIds, (String)",")));
        params.add(new BasicNameValuePair("mediaPackage", MediaPackageParser.getAsXml((MediaPackage)mediaPackage)));
        params.add(new BasicNameValuePair("wfproperties", this.toPropertyString(wfProperties)));
        params.add(new BasicNameValuePair("agentparameters", this.toPropertyString(caMetadata)));
        if (schedulingSource.isSome()) {
            params.add(new BasicNameValuePair("source", (String)schedulingSource.get()));
        }
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, StandardCharsets.UTF_8));
        HttpResponse response = this.getResponse((HttpRequestBase)post, new Integer[]{201, 401, 409});
        try {
            if (response != null && 201 == response.getStatusLine().getStatusCode()) {
                logger.info("Successfully added event {} to the scheduler service", (Object)eventId);
                return;
            }
            try {
                if (response != null && 409 == response.getStatusLine().getStatusCode()) {
                    String errorJson = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
                    JSONObject json = (JSONObject)this.parser.parse(errorJson);
                    JSONObject error = (JSONObject)json.get((Object)"error");
                    String errorCode = (String)error.get((Object)"code");
                    if ("ConflictsFound".equals(errorCode)) {
                        logger.info("Conflicting events found when adding event {}", (Object)eventId);
                        throw new SchedulerConflictException("Conflicting events found when adding event " + eventId);
                    }
                    throw new SchedulerException("Unexpected error code " + errorCode);
                }
                if (response != null && 401 == response.getStatusLine().getStatusCode()) {
                    logger.info("Unauthorized to create the event");
                    throw new UnauthorizedException("Unauthorized to create the event");
                }
                throw new SchedulerException("Unable to add event " + eventId + " to the scheduler service");
            }
            catch (SchedulerConflictException | UnauthorizedException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SchedulerException("Unable to add event " + eventId + " to the scheduler service", (Throwable)e);
            }
        }
        finally {
            this.closeConnection(response);
        }
    }

    public Map<String, Period> addMultipleEvents(RRule rRule, Date start, Date end, Long duration, TimeZone tz, String captureAgentId, Set<String> userIds, MediaPackage templateMp, Map<String, String> wfProperties, Map<String, String> caMetadata, Opt<String> schedulingSource) throws UnauthorizedException, SchedulerConflictException, SchedulerException {
        HttpPost post = new HttpPost("/");
        logger.debug("Start adding a new events through remote Schedule Service");
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("rrule", rRule.getValue()));
        params.add(new BasicNameValuePair("start", Long.toString(start.getTime())));
        params.add(new BasicNameValuePair("end", Long.toString(end.getTime())));
        params.add(new BasicNameValuePair("duration", Long.toString(duration)));
        params.add(new BasicNameValuePair("tz", tz.toZoneId().getId()));
        params.add(new BasicNameValuePair("agent", captureAgentId));
        params.add(new BasicNameValuePair("users", StringUtils.join(userIds, (String)",")));
        params.add(new BasicNameValuePair("templateMp", MediaPackageParser.getAsXml((MediaPackage)templateMp)));
        params.add(new BasicNameValuePair("wfproperties", this.toPropertyString(wfProperties)));
        params.add(new BasicNameValuePair("agentparameters", this.toPropertyString(caMetadata)));
        if (schedulingSource.isSome()) {
            params.add(new BasicNameValuePair("source", (String)schedulingSource.get()));
        }
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, StandardCharsets.UTF_8));
        String eventId = templateMp.getIdentifier().toString();
        HttpResponse response = this.getResponse((HttpRequestBase)post, new Integer[]{201, 401, 409});
        try {
            if (response != null && 201 == response.getStatusLine().getStatusCode()) {
                logger.info("Successfully added events to the scheduler service");
                Map<String, Period> map = null;
                return map;
            }
            try {
                if (response != null && 409 == response.getStatusLine().getStatusCode()) {
                    String errorJson = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
                    JSONObject json = (JSONObject)this.parser.parse(errorJson);
                    JSONObject error = (JSONObject)json.get((Object)"error");
                    String errorCode = (String)error.get((Object)"code");
                    if ("ConflictsFound".equals(errorCode)) {
                        logger.info("Conflicting events found when adding event based on {}", (Object)eventId);
                        throw new SchedulerConflictException("Conflicting events found when adding event based on" + eventId);
                    }
                    throw new SchedulerException("Unexpected error code " + errorCode);
                }
                if (response != null && 401 == response.getStatusLine().getStatusCode()) {
                    logger.info("Unauthorized to create the event");
                    throw new UnauthorizedException("Unauthorized to create the event");
                }
                throw new SchedulerException("Unable to add event " + eventId + " to the scheduler service");
            }
            catch (SchedulerConflictException | UnauthorizedException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SchedulerException("Unable to add event " + eventId + " to the scheduler service", (Throwable)e);
            }
        }
        finally {
            this.closeConnection(response);
        }
    }

    public void updateEvent(String eventId, Opt<Date> startDateTime, Opt<Date> endDateTime, Opt<String> captureAgentId, Opt<Set<String>> userIds, Opt<MediaPackage> mediaPackage, Opt<Map<String, String>> wfProperties, Opt<Map<String, String>> caMetadata) throws NotFoundException, UnauthorizedException, SchedulerConflictException, SchedulerException {
        this.updateEvent(eventId, startDateTime, endDateTime, captureAgentId, userIds, mediaPackage, wfProperties, caMetadata, false);
    }

    public void updateEvent(String eventId, Opt<Date> startDateTime, Opt<Date> endDateTime, Opt<String> captureAgentId, Opt<Set<String>> userIds, Opt<MediaPackage> mediaPackage, Opt<Map<String, String>> wfProperties, Opt<Map<String, String>> caMetadata, boolean allowConflict) throws NotFoundException, UnauthorizedException, SchedulerConflictException, SchedulerException {
        logger.debug("Start updating event {}.", (Object)eventId);
        HttpPut put = new HttpPut("/" + eventId);
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        if (startDateTime.isSome()) {
            params.add(new BasicNameValuePair("start", Long.toString(((Date)startDateTime.get()).getTime())));
        }
        if (endDateTime.isSome()) {
            params.add(new BasicNameValuePair("end", Long.toString(((Date)endDateTime.get()).getTime())));
        }
        if (captureAgentId.isSome()) {
            params.add(new BasicNameValuePair("agent", (String)captureAgentId.get()));
        }
        if (userIds.isSome()) {
            params.add(new BasicNameValuePair("users", StringUtils.join((Iterable)((Iterable)userIds.get()), (String)",")));
        }
        if (mediaPackage.isSome()) {
            params.add(new BasicNameValuePair("mediaPackage", MediaPackageParser.getAsXml((MediaPackage)((MediaPackage)mediaPackage.get()))));
        }
        if (wfProperties.isSome()) {
            params.add(new BasicNameValuePair("wfproperties", this.toPropertyString((Map)wfProperties.get())));
        }
        if (caMetadata.isSome()) {
            params.add(new BasicNameValuePair("agentparameters", this.toPropertyString((Map)caMetadata.get())));
        }
        params.add(new BasicNameValuePair("allowConflict", BooleanUtils.toString((Boolean)allowConflict, (String)"true", (String)"false", (String)"false")));
        put.setEntity((HttpEntity)new UrlEncodedFormEntity(params, StandardCharsets.UTF_8));
        HttpResponse response = this.getResponse((HttpRequestBase)put, new Integer[]{200, 404, 401, 403, 409});
        try {
            if (response != null) {
                if (404 == response.getStatusLine().getStatusCode()) {
                    logger.info("Event {} was not found by the scheduler service", (Object)eventId);
                    throw new NotFoundException("Event '" + eventId + "' not found on remote scheduler service!");
                }
                if (200 == response.getStatusLine().getStatusCode()) {
                    logger.info("Event {} successfully updated with capture agent metadata.", (Object)eventId);
                    return;
                }
                if (response != null && 409 == response.getStatusLine().getStatusCode()) {
                    String errorJson = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
                    JSONObject json = (JSONObject)this.parser.parse(errorJson);
                    JSONObject error = (JSONObject)json.get((Object)"error");
                    String errorCode = (String)error.get((Object)"code");
                    if ("ConflictsFound".equals(errorCode)) {
                        logger.info("Conflicting events found when updating event {}", (Object)eventId);
                        throw new SchedulerConflictException("Conflicting events found when updating event " + eventId);
                    }
                    throw new SchedulerException("Unexpected error code " + errorCode);
                }
                if (401 == response.getStatusLine().getStatusCode()) {
                    logger.info("Unauthorized to update the event {}.", (Object)eventId);
                    throw new UnauthorizedException("Unauthorized to update the event " + eventId);
                }
                if (403 == response.getStatusLine().getStatusCode()) {
                    logger.info("Forbidden to update the event {}.", (Object)eventId);
                    throw new SchedulerException("Event with specified ID cannot be updated");
                }
                throw new SchedulerException("Unexpected status code " + response.getStatusLine());
            }
        }
        catch (SchedulerConflictException | UnauthorizedException | NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchedulerException("Unable to update event " + eventId + " to the scheduler service", (Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new SchedulerException("Unable to update  event " + eventId);
    }

    public void removeEvent(String eventId) throws NotFoundException, UnauthorizedException, SchedulerException {
        logger.debug("Start removing event {} from scheduling service.", (Object)eventId);
        HttpDelete delete = new HttpDelete("/" + eventId);
        HttpResponse response = this.getResponse((HttpRequestBase)delete, new Integer[]{200, 404, 401, 409});
        try {
            if (response != null && 404 == response.getStatusLine().getStatusCode()) {
                logger.info("Event {} was not found by the scheduler service", (Object)eventId);
                throw new NotFoundException("Event '" + eventId + "' not found on remote scheduler service!");
            }
            if (response != null && 200 == response.getStatusLine().getStatusCode()) {
                logger.info("Event {} removed from scheduling service.", (Object)eventId);
                return;
            }
            if (response != null && 401 == response.getStatusLine().getStatusCode()) {
                logger.info("Unauthorized to remove the event {}.", (Object)eventId);
                throw new UnauthorizedException("Unauthorized to remove the event " + eventId);
            }
        }
        catch (UnauthorizedException | NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchedulerException("Unable to remove event " + eventId + " from the scheduler service", (Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new SchedulerException("Unable to remove  event " + eventId);
    }

    public MediaPackage getMediaPackage(String eventId) throws NotFoundException, UnauthorizedException, SchedulerException {
        HttpGet get = new HttpGet(eventId.concat("/mediapackage.xml"));
        HttpResponse response = this.getResponse((HttpRequestBase)get, new Integer[]{200, 404, 401});
        try {
            if (response != null) {
                if (404 == response.getStatusLine().getStatusCode()) {
                    throw new NotFoundException("Event mediapackage '" + eventId + "' not found on remote scheduler service!");
                }
                if (401 == response.getStatusLine().getStatusCode()) {
                    logger.info("Unauthorized to get mediapacakge of the event {}.", (Object)eventId);
                    throw new UnauthorizedException("Unauthorized to get mediapackage of the event " + eventId);
                }
                MediaPackage mp = MediaPackageParser.getFromXml((String)EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8));
                logger.info("Successfully get event mediapackage {} from the remote scheduler service", (Object)eventId);
                MediaPackage mediaPackage = mp;
                return mediaPackage;
            }
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (UnauthorizedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchedulerException("Unable to parse event media package from remote scheduler service", (Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new SchedulerException("Unable to get event media package from remote scheduler service");
    }

    public DublinCoreCatalog getDublinCore(String eventId) throws NotFoundException, UnauthorizedException, SchedulerException {
        HttpGet get = new HttpGet(eventId.concat("/dublincore.xml"));
        HttpResponse response = this.getResponse((HttpRequestBase)get, new Integer[]{200, 404, 401});
        try {
            if (response != null) {
                if (404 == response.getStatusLine().getStatusCode()) {
                    throw new NotFoundException("Event catalog '" + eventId + "' not found on remote scheduler service!");
                }
                if (401 == response.getStatusLine().getStatusCode()) {
                    logger.info("Unauthorized to get dublincore of the event {}.", (Object)eventId);
                    throw new UnauthorizedException("Unauthorized to get dublincore of the event " + eventId);
                }
                DublinCoreCatalog dublinCoreCatalog = DublinCores.read((InputStream)response.getEntity().getContent());
                logger.info("Successfully get event dublincore {} from the remote scheduler service", (Object)eventId);
                DublinCoreCatalog dublinCoreCatalog2 = dublinCoreCatalog;
                return dublinCoreCatalog2;
            }
        }
        catch (UnauthorizedException | NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchedulerException("Unable to parse event dublincore from remote scheduler service", (Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new SchedulerException("Unable to get event dublincore from remote scheduler service");
    }

    public TechnicalMetadata getTechnicalMetadata(String eventId) throws NotFoundException, UnauthorizedException, SchedulerException {
        HttpGet get = new HttpGet(eventId.concat("/technical.json"));
        HttpResponse response = this.getResponse((HttpRequestBase)get, new Integer[]{200, 404, 401});
        try {
            if (response != null) {
                if (404 == response.getStatusLine().getStatusCode()) {
                    throw new NotFoundException("Event with id '" + eventId + "' not found on remote scheduler service!");
                }
                if (401 == response.getStatusLine().getStatusCode()) {
                    logger.info("Unauthorized to get the technical metadata of the event {}.", (Object)eventId);
                    throw new UnauthorizedException("Unauthorized to get the technical metadata of the event " + eventId);
                }
                String technicalMetadataJson = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
                JSONObject json = (JSONObject)this.parser.parse(technicalMetadataJson);
                String recordingId = (String)json.get((Object)"id");
                Date start = new Date(DateTimeSupport.fromUTC((String)((String)json.get((Object)"start"))));
                Date end = new Date(DateTimeSupport.fromUTC((String)((String)json.get((Object)"end"))));
                String location = (String)json.get((Object)"location");
                HashSet<String> presenters = new HashSet<String>();
                JSONArray presentersArr = (JSONArray)json.get((Object)"presenters");
                for (int i = 0; i < presentersArr.size(); ++i) {
                    presenters.add((String)presentersArr.get(i));
                }
                HashMap<String, String> wfProperties = new HashMap<String, String>();
                JSONObject wfPropertiesObj = (JSONObject)json.get((Object)"wfProperties");
                Set entrySet = wfPropertiesObj.entrySet();
                for (Map.Entry entry : entrySet) {
                    wfProperties.put((String)entry.getKey(), (String)entry.getValue());
                }
                HashMap<String, String> agentConfig = new HashMap<String, String>();
                JSONObject agentConfigObj = (JSONObject)json.get((Object)"agentConfig");
                entrySet = agentConfigObj.entrySet();
                for (Map.Entry entry : entrySet) {
                    agentConfig.put((String)entry.getKey(), (String)entry.getValue());
                }
                String status = (String)json.get((Object)"state");
                String lastHeard = (String)json.get((Object)"lastHeardFrom");
                RecordingImpl recording = null;
                if (StringUtils.isNotBlank((CharSequence)status) && StringUtils.isNotBlank((CharSequence)lastHeard)) {
                    recording = new RecordingImpl(recordingId, status, DateTimeSupport.fromUTC((String)lastHeard));
                }
                Opt recordingOpt = Opt.nul(recording);
                logger.info("Successfully get the technical metadata of event '{}' from the remote scheduler service", (Object)eventId);
                TechnicalMetadataImpl technicalMetadataImpl = new TechnicalMetadataImpl(recordingId, location, start, end, presenters, wfProperties, agentConfig, recordingOpt);
                return technicalMetadataImpl;
            }
        }
        catch (UnauthorizedException | NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchedulerException("Unable to parse the technical metadata from remote scheduler service", (Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new SchedulerException("Unable to get the technical metadata from remote scheduler service");
    }

    public Map<String, String> getWorkflowConfig(String eventId) throws NotFoundException, UnauthorizedException, SchedulerException {
        HttpGet get = new HttpGet(eventId.concat("/workflow.properties"));
        HttpResponse response = this.getResponse((HttpRequestBase)get, new Integer[]{200, 404, 401});
        try {
            if (response != null) {
                if (404 == response.getStatusLine().getStatusCode()) {
                    throw new NotFoundException("Event workflow configuration '" + eventId + "' not found on remote scheduler service!");
                }
                if (401 == response.getStatusLine().getStatusCode()) {
                    logger.info("Unauthorized to get workflow config of the event {}.", (Object)eventId);
                    throw new UnauthorizedException("Unauthorized to get workflow config of the event " + eventId);
                }
                Properties properties = new Properties();
                properties.load(response.getEntity().getContent());
                logger.info("Successfully get event workflow configuration {} from the remote scheduler service", (Object)eventId);
                HashMap<Object, Object> hashMap = new HashMap<Object, Object>(properties);
                return hashMap;
            }
        }
        catch (UnauthorizedException | NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchedulerException("Unable to parse event workflow configuration from remote scheduler service", (Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new SchedulerException("Unable to get event workflow configuration from remote scheduler service");
    }

    public Map<String, String> getCaptureAgentConfiguration(String eventId) throws NotFoundException, UnauthorizedException, SchedulerException {
        HttpGet get = new HttpGet(eventId.concat("/agent.properties"));
        HttpResponse response = this.getResponse((HttpRequestBase)get, new Integer[]{200, 404, 401});
        try {
            if (response != null) {
                if (404 == response.getStatusLine().getStatusCode()) {
                    throw new NotFoundException("Event capture agent configuration '" + eventId + "' not found on remote scheduler service!");
                }
                if (401 == response.getStatusLine().getStatusCode()) {
                    logger.info("Unauthorized to get capture agent config of the event {}.", (Object)eventId);
                    throw new UnauthorizedException("Unauthorized to get capture agent config of the event " + eventId);
                }
                Properties properties = new Properties();
                properties.load(response.getEntity().getContent());
                logger.info("Successfully get event capture agent configuration {} from the remote scheduler service", (Object)eventId);
                HashMap<Object, Object> hashMap = new HashMap<Object, Object>(properties);
                return hashMap;
            }
        }
        catch (UnauthorizedException | NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchedulerException("Unable to parse event capture agent configuration from remote scheduler service", (Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new SchedulerException("Unable to get event capture agent configuration from remote scheduler service");
    }

    public int getEventCount() throws SchedulerException, UnauthorizedException {
        HttpGet get = new HttpGet(UrlSupport.concat((String[])new String[]{"eventCount"}));
        HttpResponse response = this.getResponse((HttpRequestBase)get, new Integer[]{200, 401});
        try {
            if (401 == response.getStatusLine().getStatusCode()) {
                logger.info("Unauthorized to get event count");
                throw new UnauthorizedException("Unauthorized to get event count");
            }
            String countString = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
            int n = Integer.parseInt(countString);
            return n;
        }
        catch (UnauthorizedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchedulerException("Unable to get event count from remote scheduler service", (Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
    }

    public String getScheduleLastModified(String agentId) throws SchedulerException {
        HttpGet get = new HttpGet(UrlSupport.concat((String)agentId, (String)"lastmodified"));
        HttpResponse response = this.getResponse((HttpRequestBase)get, new Integer[]{200});
        try {
            if (response != null && 200 == response.getStatusLine().getStatusCode()) {
                String agentHash = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
                logger.info("Successfully get agent last modified hash of agent with id {} from the remote scheduler service", (Object)agentId);
                String string = agentHash;
                return string;
            }
        }
        catch (Exception e) {
            throw new SchedulerException("Unable to get agent last modified hash from remote scheduler service", (Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new SchedulerException("Unable to get agent last modified hash from remote scheduler service");
    }

    public List<MediaPackage> search(Opt<String> captureAgentId, Opt<Date> startsFrom, Opt<Date> startsTo, Opt<Date> endFrom, Opt<Date> endTo) throws UnauthorizedException, SchedulerException {
        ArrayList<BasicNameValuePair> queryStringParams = new ArrayList<BasicNameValuePair>();
        for (String s : captureAgentId) {
            queryStringParams.add(new BasicNameValuePair("agent", s));
        }
        for (Date d : startsFrom) {
            queryStringParams.add(new BasicNameValuePair("startsfrom", Long.toString(d.getTime())));
        }
        for (Date d : startsTo) {
            queryStringParams.add(new BasicNameValuePair("startsto", Long.toString(d.getTime())));
        }
        for (Date d : endFrom) {
            queryStringParams.add(new BasicNameValuePair("endsfrom", Long.toString(d.getTime())));
        }
        for (Date d : endTo) {
            queryStringParams.add(new BasicNameValuePair("endsto", Long.toString(d.getTime())));
        }
        HttpGet get = new HttpGet("recordings.xml?".concat(URLEncodedUtils.format(queryStringParams, (Charset)StandardCharsets.UTF_8)));
        HttpResponse response = this.getResponse((HttpRequestBase)get, new Integer[]{200, 401});
        try {
            if (response != null) {
                if (200 == response.getStatusLine().getStatusCode()) {
                    String mediaPackageXml = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
                    List events = MediaPackageParser.getArrayFromXml((String)mediaPackageXml);
                    logger.info("Successfully get recordings from the remote scheduler service");
                    List list = events;
                    return list;
                }
                if (401 == response.getStatusLine().getStatusCode()) {
                    logger.info("Unauthorized to search for events");
                    throw new UnauthorizedException("Unauthorized to search for events");
                }
            }
        }
        catch (UnauthorizedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchedulerException("Unable to get recordings from remote scheduler service", (Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new SchedulerException("Unable to get recordings from remote scheduler service");
    }

    public Opt<MediaPackage> getCurrentRecording(String captureAgentId) throws SchedulerException, UnauthorizedException {
        HttpGet get = new HttpGet(UrlSupport.concat((String)"currentRecording", (String)captureAgentId));
        HttpResponse response = this.getResponse((HttpRequestBase)get, new Integer[]{200, 204, 401});
        try {
            if (200 == response.getStatusLine().getStatusCode()) {
                String mediaPackageXml = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
                MediaPackage event = MediaPackageParser.getFromXml((String)mediaPackageXml);
                logger.info("Successfully get current recording of agent {} from the remote scheduler service", (Object)captureAgentId);
                Opt opt = Opt.some((Object)event);
                return opt;
            }
            if (401 == response.getStatusLine().getStatusCode()) {
                logger.info("Unauthorized to get current recording of agent {}", (Object)captureAgentId);
                throw new UnauthorizedException("Unauthorized to get current recording of agent " + captureAgentId);
            }
            Opt mediaPackageXml = Opt.none();
            return mediaPackageXml;
        }
        catch (UnauthorizedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchedulerException("Unable to get current recording from remote scheduler service", (Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
    }

    public Opt<MediaPackage> getUpcomingRecording(String captureAgentId) throws SchedulerException, UnauthorizedException {
        HttpGet get = new HttpGet(UrlSupport.concat((String)"upcomingRecording", (String)captureAgentId));
        HttpResponse response = this.getResponse((HttpRequestBase)get, new Integer[]{200, 204, 401});
        try {
            if (200 == response.getStatusLine().getStatusCode()) {
                String mediaPackageXml = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
                MediaPackage event = MediaPackageParser.getFromXml((String)mediaPackageXml);
                logger.info("Successfully get upcoming recording of agent {} from the remote scheduler service", (Object)captureAgentId);
                Opt opt = Opt.some((Object)event);
                return opt;
            }
            if (401 == response.getStatusLine().getStatusCode()) {
                logger.info("Unauthorized to get upcoming recording of agent {}", (Object)captureAgentId);
                throw new UnauthorizedException("Unauthorized to get upcoming recording of agent " + captureAgentId);
            }
            Opt mediaPackageXml = Opt.none();
            return mediaPackageXml;
        }
        catch (UnauthorizedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchedulerException("Unable to get upcoming recording from remote scheduler service", (Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
    }

    public List<MediaPackage> findConflictingEvents(String captureDeviceID, Date startDate, Date endDate) throws UnauthorizedException, SchedulerException {
        ArrayList<BasicNameValuePair> queryStringParams = new ArrayList<BasicNameValuePair>();
        queryStringParams.add(new BasicNameValuePair("agent", captureDeviceID));
        queryStringParams.add(new BasicNameValuePair("start", Long.toString(startDate.getTime())));
        queryStringParams.add(new BasicNameValuePair("end", Long.toString(endDate.getTime())));
        HttpGet get = new HttpGet("conflicts.xml?".concat(URLEncodedUtils.format(queryStringParams, (Charset)StandardCharsets.UTF_8)));
        HttpResponse response = this.getResponse((HttpRequestBase)get, new Integer[]{200, 204});
        try {
            if (response != null) {
                if (200 == response.getStatusLine().getStatusCode()) {
                    String mediaPackageXml = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
                    List events = MediaPackageParser.getArrayFromXml((String)mediaPackageXml);
                    logger.info("Successfully get conflicts from the remote scheduler service");
                    List list = events;
                    return list;
                }
                if (401 == response.getStatusLine().getStatusCode()) {
                    logger.info("Unauthorized to search for conflicting events");
                    throw new UnauthorizedException("Unauthorized to search for conflicting events");
                }
                if (204 == response.getStatusLine().getStatusCode()) {
                    List<MediaPackage> mediaPackageXml = Collections.emptyList();
                    return mediaPackageXml;
                }
            }
        }
        catch (UnauthorizedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchedulerException("Unable to get conflicts from remote scheduler service", (Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new SchedulerException("Unable to get conflicts from remote scheduler service");
    }

    public List<MediaPackage> findConflictingEvents(String captureAgentId, RRule rrule, Date startDate, Date endDate, long duration, TimeZone timezone) throws UnauthorizedException, SchedulerException {
        ArrayList<BasicNameValuePair> queryStringParams = new ArrayList<BasicNameValuePair>();
        queryStringParams.add(new BasicNameValuePair("agent", captureAgentId));
        queryStringParams.add(new BasicNameValuePair("rrule", rrule.getRecur().toString()));
        queryStringParams.add(new BasicNameValuePair("start", Long.toString(startDate.getTime())));
        queryStringParams.add(new BasicNameValuePair("end", Long.toString(endDate.getTime())));
        queryStringParams.add(new BasicNameValuePair("duration", Long.toString(duration)));
        queryStringParams.add(new BasicNameValuePair("timezone", timezone.getID()));
        HttpGet get = new HttpGet("conflicts.xml?".concat(URLEncodedUtils.format(queryStringParams, (Charset)StandardCharsets.UTF_8)));
        HttpResponse response = this.getResponse((HttpRequestBase)get, new Integer[]{200, 204});
        try {
            if (response != null) {
                if (200 == response.getStatusLine().getStatusCode()) {
                    String mediaPackageXml = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
                    List events = MediaPackageParser.getArrayFromXml((String)mediaPackageXml);
                    logger.info("Successfully get conflicts from the remote scheduler service");
                    List list = events;
                    return list;
                }
                if (401 == response.getStatusLine().getStatusCode()) {
                    logger.info("Unauthorized to search for conflicting events");
                    throw new UnauthorizedException("Unauthorized to search for conflicting events");
                }
                if (204 == response.getStatusLine().getStatusCode()) {
                    List<MediaPackage> mediaPackageXml = Collections.emptyList();
                    return mediaPackageXml;
                }
            }
        }
        catch (UnauthorizedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchedulerException("Unable to get conflicts from remote scheduler service", (Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new SchedulerException("Unable to get conflicts from remote scheduler service");
    }

    public String getCalendar(Opt<String> captureAgentId, Opt<String> seriesId, Opt<Date> cutoff) throws SchedulerException {
        ArrayList<BasicNameValuePair> queryStringParams = new ArrayList<BasicNameValuePair>();
        for (String s : captureAgentId) {
            queryStringParams.add(new BasicNameValuePair("agentid", s));
        }
        for (String s : seriesId) {
            queryStringParams.add(new BasicNameValuePair("seriesid", s));
        }
        for (Date d : cutoff) {
            queryStringParams.add(new BasicNameValuePair("cutoff", Long.toString(d.getTime())));
        }
        HttpGet get = new HttpGet("calendars?".concat(URLEncodedUtils.format(queryStringParams, (Charset)StandardCharsets.UTF_8)));
        HttpResponse response = this.getResponse((HttpRequestBase)get, new Integer[]{200});
        try {
            if (response != null && 200 == response.getStatusLine().getStatusCode()) {
                String calendar = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
                logger.info("Successfully get calendar of agent with id {} from the remote scheduler service", captureAgentId);
                String string = calendar;
                return string;
            }
        }
        catch (Exception e) {
            throw new SchedulerException("Unable to get calendar from remote scheduler service", (Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new SchedulerException("Unable to get calendar from remote scheduler service");
    }

    public void removeScheduledRecordingsBeforeBuffer(long buffer) throws UnauthorizedException, SchedulerException {
        HttpPost post = new HttpPost("/removeOldScheduledRecordings");
        logger.debug("Start removing old schedules before buffer {} through remote Schedule Service", (Object)buffer);
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("buffer", Long.toString(buffer)));
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, StandardCharsets.UTF_8));
        HttpResponse response = this.getResponse((HttpRequestBase)post, new Integer[]{200, 401});
        try {
            if (response != null && 200 == response.getStatusLine().getStatusCode()) {
                logger.info("Successfully started removing old schedules before butter {} to the scheduler service", (Object)buffer);
                return;
            }
            if (401 == response.getStatusLine().getStatusCode()) {
                logger.info("Unauthorized to remove old schedules before buffer {}.", (Object)buffer);
                throw new UnauthorizedException("Unauthorized to remove old schedules");
            }
        }
        catch (UnauthorizedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchedulerException("Unable to remove old schedules from the scheduler service", (Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new SchedulerException("Unable to remove old schedules from the scheduler service");
    }

    public boolean updateRecordingState(String mediapackageId, String state) throws NotFoundException, SchedulerException {
        HttpPut put = new HttpPut(UrlSupport.concat((String)mediapackageId, (String)"recordingStatus"));
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("state", state));
        put.setEntity((HttpEntity)new UrlEncodedFormEntity(params, StandardCharsets.UTF_8));
        HttpResponse response = this.getResponse((HttpRequestBase)put, new Integer[]{200, 404, 400});
        try {
            if (response != null) {
                if (404 == response.getStatusLine().getStatusCode()) {
                    logger.warn("Event with mediapackage id {} was not found by the scheduler service", (Object)mediapackageId);
                    throw new NotFoundException("Event with mediapackage id '" + mediapackageId + "' not found on remote scheduler service!");
                }
                if (400 == response.getStatusLine().getStatusCode()) {
                    logger.info("Unable to update event with mediapackage id {}, invalid recording state: {}.", (Object)mediapackageId, (Object)state);
                    boolean bl = false;
                    return bl;
                }
                if (200 == response.getStatusLine().getStatusCode()) {
                    logger.info("Event with mediapackage id {} successfully updated with recording status.", (Object)mediapackageId);
                    boolean bl = true;
                    return bl;
                }
                throw new SchedulerException("Unexpected status code " + response.getStatusLine());
            }
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchedulerException("Unable to update recording state of event with mediapackage id " + mediapackageId + " to the scheduler service", (Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new SchedulerException("Unable to update recording state of event with mediapackage id " + mediapackageId);
    }

    public Recording getRecordingState(String id) throws NotFoundException, SchedulerException {
        HttpGet get = new HttpGet(UrlSupport.concat((String)id, (String)"recordingStatus"));
        HttpResponse response = this.getResponse((HttpRequestBase)get, new Integer[]{200, 404});
        try {
            if (response != null) {
                if (200 == response.getStatusLine().getStatusCode()) {
                    String recordingStateJson = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
                    JSONObject json = (JSONObject)this.parser.parse(recordingStateJson);
                    String recordingId = (String)json.get((Object)"id");
                    String status = (String)json.get((Object)"state");
                    Long lastHeard = (Long)json.get((Object)"lastHeardFrom");
                    logger.info("Successfully get calendar of agent with id {} from the remote scheduler service", (Object)id);
                    RecordingImpl recordingImpl = new RecordingImpl(recordingId, status, lastHeard.longValue());
                    return recordingImpl;
                }
                if (404 == response.getStatusLine().getStatusCode()) {
                    logger.warn("Event with mediapackage id {} was not found by the scheduler service", (Object)id);
                    throw new NotFoundException("Event with mediapackage id '" + id + "' not found on remote scheduler service!");
                }
            }
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchedulerException("Unable to get calendar from remote scheduler service", (Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new SchedulerException("Unable to get calendar from remote scheduler service");
    }

    public void removeRecording(String eventId) throws NotFoundException, SchedulerException {
        HttpDelete delete = new HttpDelete(UrlSupport.concat((String)eventId, (String)"recordingStatus"));
        HttpResponse response = this.getResponse((HttpRequestBase)delete, new Integer[]{200, 404});
        try {
            if (response != null && 404 == response.getStatusLine().getStatusCode()) {
                logger.info("Event {} was not found by the scheduler service", (Object)eventId);
                throw new NotFoundException("Event '" + eventId + "' not found on remote scheduler service!");
            }
            if (response != null && 200 == response.getStatusLine().getStatusCode()) {
                logger.info("Recording status of event {} removed from scheduling service.", (Object)eventId);
                return;
            }
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchedulerException("Unable to remove recording status of event " + eventId + " from the scheduler service", (Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new SchedulerException("Unable to remove  recording status of event " + eventId);
    }

    public Map<String, Recording> getKnownRecordings() throws SchedulerException {
        HttpGet get = new HttpGet("recordingStatus");
        HttpResponse response = this.getResponse((HttpRequestBase)get, new Integer[]{200});
        try {
            if (response != null && 200 == response.getStatusLine().getStatusCode()) {
                String recordingStates = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
                JSONArray recordings = (JSONArray)this.parser.parse(recordingStates);
                HashMap<String, Recording> recordingsMap = new HashMap<String, Recording>();
                for (int i = 0; i < recordings.size(); ++i) {
                    JSONObject recording = (JSONObject)recordings.get(i);
                    String recordingId = (String)recording.get((Object)"id");
                    String status = (String)recording.get((Object)"state");
                    Long lastHeard = (Long)recording.get((Object)"lastHeardFrom");
                    recordingsMap.put(recordingId, (Recording)new RecordingImpl(recordingId, status, lastHeard.longValue()));
                }
                logger.info("Successfully get recording states from the remote scheduler service");
                HashMap<String, Recording> hashMap = recordingsMap;
                return hashMap;
            }
        }
        catch (Exception e) {
            throw new SchedulerException("Unable to get recording states from remote scheduler service", (Throwable)e);
        }
        finally {
            this.closeConnection(response);
        }
        throw new SchedulerException("Unable to get recording states from remote scheduler service");
    }

    private String toPropertyString(Map<String, String> properties) {
        StringBuilder wfPropertiesString = new StringBuilder();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            wfPropertiesString.append(entry.getKey() + "=" + entry.getValue() + "\n");
        }
        return wfPropertiesString.toString();
    }

    @Reference
    public void setTrustedHttpClient(TrustedHttpClient trustedHttpClient) {
        super.setTrustedHttpClient(trustedHttpClient);
    }

    @Reference
    public void setRemoteServiceManager(ServiceRegistry serviceRegistry) {
        super.setRemoteServiceManager(serviceRegistry);
    }
}

