/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.scheduler.impl;

import org.opencastproject.kernel.scanner.AbstractBufferScanner;
import org.opencastproject.kernel.scanner.AbstractScanner;
import org.opencastproject.scheduler.api.SchedulerException;
import org.opencastproject.scheduler.api.SchedulerService;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.OrganizationDirectoryService;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.util.NeedleEye;
import org.opencastproject.util.data.Option;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.Scheduler;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={ManagedService.class}, property={"service.description=Cleanup Finished Recordings from the Schedule Scanner"})
public class OldScheduledScanner
extends AbstractBufferScanner
implements ManagedService {
    private static final Logger logger = LoggerFactory.getLogger(OldScheduledScanner.class);
    public static final String SCANNER_NAME = "Cleanup Finished Scheduled Events Scanner";
    public static final String JOB_GROUP = "mh-scheduler-cleanup-job-group";
    public static final String JOB_NAME = "mh-scheduler-cleanup-job";
    public static final String TRIGGER_GROUP = "mh-scheduler-cleanup-trigger";
    public static final String TRIGGER_NAME = "mh-scheduler-cleanup-trigger";
    private SchedulerService service;

    public OldScheduledScanner() {
        try {
            this.quartz = new StdSchedulerFactory().getScheduler();
            this.quartz.start();
            JobDetail job = new JobDetail(this.getJobName(), this.getJobGroup(), Runner.class);
            job.setDurability(false);
            job.setVolatility(true);
            job.getJobDataMap().put((Object)"parent", (Object)this);
            this.quartz.addJob(job, true);
        }
        catch (org.quartz.SchedulerException e) {
            throw new RuntimeException(e);
        }
    }

    @Activate
    public void activate(ComponentContext cc) {
        super.activate(cc);
    }

    @Deactivate
    public void deactivate() {
        super.deactivate();
    }

    @Reference
    public void setService(SchedulerService service) {
        this.service = service;
    }

    @Reference
    public void bindServiceRegistry(ServiceRegistry serviceRegistry) {
        super.bindServiceRegistry(serviceRegistry);
    }

    @Reference
    public void bindOrganizationDirectoryService(OrganizationDirectoryService organizationDirectoryService) {
        super.bindOrganizationDirectoryService(organizationDirectoryService);
    }

    @Reference
    public void bindSecurityService(SecurityService securityService) {
        super.bindSecurityService(securityService);
    }

    public void setQuartz(Scheduler quartz) {
        this.quartz = quartz;
    }

    public void unsetService(SchedulerService service) {
        this.service = null;
    }

    public String getJobGroup() {
        return JOB_GROUP;
    }

    public String getJobName() {
        return JOB_NAME;
    }

    public String getTriggerGroupName() {
        return "mh-scheduler-cleanup-trigger";
    }

    public String getTriggerName() {
        return "mh-scheduler-cleanup-trigger";
    }

    public String getScannerName() {
        return SCANNER_NAME;
    }

    public void scan() {
        try {
            this.service.removeScheduledRecordingsBeforeBuffer(this.getBuffer());
        }
        catch (UnauthorizedException e) {
            logger.error("Unable to scan for finished recordings, not authorized: ", (Throwable)e);
        }
        catch (SchedulerException e) {
            logger.error("Unable to scan for finished recordings: ", (Throwable)e);
        }
    }

    public static class Runner
    extends AbstractScanner.TypedQuartzJob<AbstractScanner> {
        private static final NeedleEye eye = new NeedleEye();

        public Runner() {
            super(Option.some((Object)eye));
        }

        protected void execute(AbstractScanner parameters, JobExecutionContext ctx) {
            logger.debug("Starting " + parameters.getScannerName() + " job.");
            for (Organization org : parameters.getOrganizationDirectoryService().getOrganizations()) {
                parameters.getAdminContextFor(org.getId()).runInContext(() -> ((AbstractScanner)parameters).scan());
            }
            logger.info("Finished " + parameters.getScannerName() + " job.");
        }
    }
}

