/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.runtimeinfo.rest;

import org.opencastproject.util.doc.rest.RestResponse;

public class StatusData {
    private int code;
    private String name;
    private String description;
    private String xmlSchema;

    public StatusData(RestResponse restResponse) throws IllegalArgumentException {
        this(restResponse.responseCode(), restResponse.description());
    }

    public StatusData(int code, String description, String xmlSchema) throws IllegalArgumentException {
        if (code < 100 || code > 1100) {
            throw new IllegalArgumentException("Code (" + code + ") is outside of the valid range: 100-1100.");
        }
        this.code = code;
        this.name = StatusData.findName(code);
        this.description = description.isEmpty() ? null : description;
        this.xmlSchema = xmlSchema;
    }

    public StatusData(int code, String description) throws IllegalArgumentException {
        this(code, description, null);
    }

    public String toString() {
        return "SC:" + this.code + ":" + this.name;
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public static String findName(int code) throws IllegalArgumentException {
        if (code < 100 || code > 1100) {
            throw new IllegalArgumentException("Code (" + code + ") is outside of the valid range: 100-1100.");
        }
        return switch (code) {
            case 100 -> "Continue";
            case 101 -> "Switching Protocols";
            case 200 -> "OK";
            case 201 -> "Created";
            case 202 -> "Accepted";
            case 203 -> "Non-Authoritative Information";
            case 204 -> "No Content";
            case 205 -> "Reset Content";
            case 206 -> "Partial Content";
            case 300 -> "Multiple Choices";
            case 301 -> "Moved Permanently";
            case 302 -> "Found";
            case 303 -> "See Other";
            case 304 -> "Not Modified";
            case 305 -> "Use Proxy";
            case 307 -> "Temporary Redirect";
            case 400 -> "Bad Request";
            case 401 -> "Unauthorized";
            case 402 -> "Payment Required";
            case 403 -> "Forbidden";
            case 404 -> "Not Found";
            case 405 -> "Method Not Allowed";
            case 406 -> "Not Acceptable";
            case 407 -> "Proxy Authentication Required";
            case 408 -> "Request Timeout";
            case 409 -> "Conflict";
            case 410 -> "Gone";
            case 411 -> "Length Required";
            case 412 -> "Precondition Failed";
            case 413 -> "Request Entity Too Large";
            case 414 -> "Request URI Too Long";
            case 415 -> "Unsupported Media Type";
            case 416 -> "Requested Range Not Satisfiable";
            case 417 -> "Expectation Failed";
            case 500 -> "Internal Server Error";
            case 501 -> "Not Implemented";
            case 502 -> "Bad Gateway";
            case 503 -> "Service Unavailable";
            case 504 -> "Gateway Timeout";
            case 505 -> "Version Not Supported";
            default -> "UNKNOWN";
        };
    }

    public String getXmlSchema() {
        return this.xmlSchema;
    }

    public void setXmlSchema(String xmlSchema) {
        this.xmlSchema = xmlSchema;
    }
}

