/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.runtimeinfo.rest;

import java.util.ArrayList;
import java.util.List;
import org.opencastproject.runtimeinfo.rest.RestEndpointData;
import org.opencastproject.runtimeinfo.rest.RestParamData;

public class RestFormData {
    private boolean ajaxSubmit = false;
    private boolean fileUpload = false;
    private boolean basic = false;
    private List<RestParamData> items;

    public RestFormData(RestEndpointData endpoint) throws IllegalArgumentException {
        if (endpoint == null) {
            throw new IllegalArgumentException("Endpoint must not be null.");
        }
        this.ajaxSubmit = true;
        this.items = new ArrayList<RestParamData>(3);
        boolean hasUpload = false;
        if (endpoint.getPathParams() != null) {
            for (RestParamData param : endpoint.getPathParams()) {
                param.setRequired(true);
                this.items.add(param);
            }
        }
        if (endpoint.getRequiredParams() != null) {
            for (RestParamData param : endpoint.getRequiredParams()) {
                param.setRequired(true);
                if (RestParamData.Type.FILE.name().equalsIgnoreCase(param.getType())) {
                    hasUpload = true;
                }
                this.items.add(param);
            }
        }
        if (endpoint.getOptionalParams() != null) {
            for (RestParamData param : endpoint.getOptionalParams()) {
                param.setRequired(false);
                if (RestParamData.Type.FILE.name().equalsIgnoreCase(param.getType())) {
                    hasUpload = true;
                }
                this.items.add(param);
            }
        }
        if (endpoint.getBodyParam() != null) {
            RestParamData param = endpoint.getBodyParam();
            param.setRequired(true);
            if (RestParamData.Type.FILE.name().equalsIgnoreCase(param.getType())) {
                hasUpload = true;
            }
            this.items.add(param);
        }
        if (hasUpload) {
            this.fileUpload = true;
            this.ajaxSubmit = false;
        }
        if (this.items.isEmpty() && endpoint.isGetMethod()) {
            this.basic = true;
        }
    }

    public boolean isEmpty() {
        boolean empty = true;
        if (this.items != null && !this.items.isEmpty()) {
            empty = false;
        }
        return empty;
    }

    public void setAjaxSubmit(boolean ajaxSubmit) {
        this.ajaxSubmit = ajaxSubmit;
    }

    public void setFileUpload(boolean fileUpload) {
        this.fileUpload = fileUpload;
        if (fileUpload) {
            this.ajaxSubmit = false;
        }
    }

    public String toString() {
        if (this.items == null) {
            return "FORM:items=0";
        }
        return "FORM:items=" + this.items.size();
    }

    public boolean isAjaxSubmit() {
        return this.ajaxSubmit;
    }

    public boolean isFileUpload() {
        return this.fileUpload;
    }

    public boolean isBasic() {
        return this.basic;
    }

    public List<RestParamData> getItems() {
        return this.items;
    }
}

