/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.runtimeinfo;

import com.google.gson.Gson;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.commons.lang3.StringUtils;
import org.opencastproject.security.api.Organization;
import org.opencastproject.security.api.Role;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.security.api.User;
import org.opencastproject.serviceregistry.api.HostRegistration;
import org.opencastproject.serviceregistry.api.ServiceRegistration;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.serviceregistry.api.ServiceRegistryException;
import org.opencastproject.userdirectory.UserIdRoleProvider;
import org.opencastproject.util.UrlSupport;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/info")
@RestService(name="RuntimeInfo", title="Runtime Information", abstractText="This service provides information about the runtime environment, including the services that are deployed and the current user context.", notes={})
@Tag(name="Runtime Information", description="This service provides information about the runtime environment, including the services that are deployed and the current user context.")
@Component(service={RuntimeInfo.class}, property={"service.description=Runtime Information REST Endpoint", "opencast.service.type=org.opencastproject.info", "opencast.service.path=/info"})
@JaxrsResource
public class RuntimeInfo {
    private static final Logger logger = LoggerFactory.getLogger(RuntimeInfo.class);
    private static final String ADMIN_URL_PROPERTY = "org.opencastproject.admin.ui.url";
    private static final String ENGAGE_URL_PROPERTY = "org.opencastproject.engage.ui.url";
    private static final Gson gson = new Gson();
    public static final String HEALTH_CHECK_VERSION = "1";
    public static final String HEALTH_CHECK_STATUS_PASS = "pass";
    public static final String HEALTH_CHECK_STATUS_WARN = "warn";
    public static final String HEALTH_CHECK_STATUS_FAIL = "fail";
    public static final String SERVICE_FILTER = "(&(!(objectClass=javax.servlet.Servlet))(opencast.service.path=*))";
    private UserIdRoleProvider userIdRoleProvider;
    private SecurityService securityService;
    private ServiceRegistry serviceRegistry;
    private BundleContext bundleContext;
    private URL serverUrl;

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, unbind="unsetUserIdRoleProvider")
    protected void setUserIdRoleProvider(UserIdRoleProvider userIdRoleProvider) {
        this.userIdRoleProvider = userIdRoleProvider;
    }

    protected void unsetUserIdRoleProvider(UserIdRoleProvider userIdRoleProvider) {
        if (this.userIdRoleProvider == userIdRoleProvider) {
            this.userIdRoleProvider = null;
        }
    }

    @Reference
    protected void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Reference
    protected void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    private ServiceReference[] getRestServiceReferences() throws InvalidSyntaxException {
        return this.bundleContext.getAllServiceReferences(null, SERVICE_FILTER);
    }

    private ServiceReference[] getUserInterfaceServiceReferences() throws InvalidSyntaxException {
        return this.bundleContext.getAllServiceReferences(Servlet.class.getName(), "(&(alias=*)(classpath=*))");
    }

    @Activate
    public void activate(ComponentContext cc) throws MalformedURLException {
        logger.debug("start()");
        this.bundleContext = cc.getBundleContext();
        this.serverUrl = new URL(this.bundleContext.getProperty("org.opencastproject.server.url"));
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="components.json")
    @RestQuery(name="services", description="List the REST services and user interfaces running on this host", responses={@RestResponse(description="The components running on this host", responseCode=200)}, returnDescription="")
    @Operation(summary="List the REST services and user interfaces running on this host", description="List the REST services and user interfaces running on this host")
    @ApiResponse(responseCode="200", description="The components running on this host")
    public String getRuntimeInfo(@Context HttpServletRequest request) throws MalformedURLException, InvalidSyntaxException {
        Organization organization = this.securityService.getOrganization();
        String targetScheme = request.getScheme();
        URL targetEngageBaseUrl = null;
        String orgEngageBaseUrl = (String)organization.getProperties().get(ENGAGE_URL_PROPERTY);
        if (StringUtils.isNotBlank((CharSequence)orgEngageBaseUrl)) {
            try {
                targetEngageBaseUrl = new URL(orgEngageBaseUrl);
            }
            catch (MalformedURLException e) {
                logger.warn("Engage url '{}' of organization '{}' is malformed", (Object)orgEngageBaseUrl, (Object)organization.getId());
            }
        }
        if (targetEngageBaseUrl == null) {
            logger.debug("Using 'org.opencastproject.server.url' as a fallback for the non-existing organization level key '{}' for the components.json response", (Object)ENGAGE_URL_PROPERTY);
            targetEngageBaseUrl = new URL(targetScheme, this.serverUrl.getHost(), this.serverUrl.getPort(), this.serverUrl.getFile());
        }
        URL targetAdminBaseUrl = null;
        String orgAdminBaseUrl = (String)organization.getProperties().get(ADMIN_URL_PROPERTY);
        if (StringUtils.isNotBlank((CharSequence)orgAdminBaseUrl)) {
            try {
                targetAdminBaseUrl = new URL(orgAdminBaseUrl);
            }
            catch (MalformedURLException e) {
                logger.warn("Admin url '{}' of organization '{}' is malformed", (Object)orgAdminBaseUrl, (Object)organization.getId());
            }
        }
        if (targetAdminBaseUrl == null) {
            logger.debug("Using 'org.opencastproject.server.url' as a fallback for the non-existing organization level key '{}' for the components.json response", (Object)ADMIN_URL_PROPERTY);
            targetAdminBaseUrl = new URL(targetScheme, this.serverUrl.getHost(), this.serverUrl.getPort(), this.serverUrl.getFile());
        }
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("engage", targetEngageBaseUrl.toString());
        json.put("admin", targetAdminBaseUrl.toString());
        json.put("rest", this.getRestEndpointsAsJson(request));
        json.put("ui", this.getUserInterfacesAsJson());
        return gson.toJson(json);
    }

    @GET
    @Path(value="me.json")
    @Produces(value={"application/json"})
    @RestQuery(name="me", description="Information about the curent user", responses={@RestResponse(description="Returns information about the current user", responseCode=200)}, returnDescription="")
    @Operation(summary="Information about the curent user", description="Returns information about the current user")
    @ApiResponse(responseCode="200", description="Returns information about the current user")
    public String getMyInfo() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        User user = this.securityService.getUser();
        HashMap<String, String> jsonUser = new HashMap<String, String>();
        jsonUser.put("username", user.getUsername());
        jsonUser.put("name", user.getName());
        jsonUser.put("email", user.getEmail());
        jsonUser.put("provider", user.getProvider());
        result.put("user", jsonUser);
        if (this.userIdRoleProvider != null) {
            result.put("userRole", UserIdRoleProvider.getUserIdRole((String)user.getUsername()));
        }
        result.put("roles", user.getRoles().stream().map(Role::getName).collect(Collectors.toList()));
        Organization org = this.securityService.getOrganization();
        HashMap<String, Object> jsonOrg = new HashMap<String, Object>();
        jsonOrg.put("id", org.getId());
        jsonOrg.put("name", org.getName());
        jsonOrg.put("adminRole", org.getAdminRole());
        jsonOrg.put("anonymousRole", org.getAnonymousRole());
        jsonOrg.put("properties", org.getProperties());
        result.put("org", jsonOrg);
        return gson.toJson(result);
    }

    @GET
    @Path(value="health")
    @Produces(value={"application/health+json"})
    @RestQuery(name="health", description="Opencast node health check. Implements this internet-draft health check api https://inadarei.github.io/rfc-healthcheck", responses={@RestResponse(responseCode=200, description="Node is running, check reponse for details"), @RestResponse(responseCode=503, description="Node is offline or unresponsive, check response for details")}, returnDescription="Details of the Opencast node's health status")
    @Operation(summary="Opencast node health check", description="Implements this internet-draft health check api https://inadarei.github.io/rfc-healthcheck")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Node is running, check response for details"), @ApiResponse(responseCode="503", description="Node is offline or unresponsive, check response for details")})
    public String getHealth(@Context HttpServletResponse response) {
        Health health;
        String releaseId = this.bundleContext != null ? this.bundleContext.getBundle().getVersion().toString() : "TEST";
        String hostname = this.serviceRegistry.getRegistryHostname();
        HashMap<String, List<Object>> checks = new HashMap<String, List<Object>>();
        try {
            HostRegistration host = this.serviceRegistry.getHostRegistration(hostname);
            health = this.checkHostHealth(host);
        }
        catch (ServiceRegistryException e) {
            logger.error("Failed to get host registration: ", (Throwable)e);
            health = new Health(this);
            health.setStatus(HEALTH_CHECK_STATUS_FAIL);
            health.addNote("internal health check error!");
        }
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("status", health.getStatus());
        json.put("version", HEALTH_CHECK_VERSION);
        json.put("releaseId", releaseId);
        json.put("serviceId", hostname);
        json.put("description", "Opencast node's health status");
        if (!health.getNotes().isEmpty()) {
            json.put("notes", health.getNotes());
        }
        if (!health.getServiceStates().isEmpty()) {
            checks.put("service:states", health.getServiceStates());
        }
        if (!checks.isEmpty()) {
            json.put("checks", checks);
        }
        if (HEALTH_CHECK_STATUS_FAIL.equalsIgnoreCase(health.getStatus())) {
            response.setStatus(503);
        } else {
            response.setStatus(200);
        }
        return gson.toJson(json);
    }

    private Health checkHostHealth(HostRegistration host) {
        Health health = new Health(this);
        if (!host.isOnline()) {
            health.setStatus(HEALTH_CHECK_STATUS_FAIL);
            health.addNote("node is offline");
        } else if (!host.isActive()) {
            health.setStatus(HEALTH_CHECK_STATUS_FAIL);
            health.addNote("node is disabled");
        } else if (host.isMaintenanceMode()) {
            health.setStatus(HEALTH_CHECK_STATUS_FAIL);
            health.addNote("node is in maintenance");
        } else {
            try {
                List services = this.serviceRegistry.getServiceRegistrationsByHost(host.getBaseUrl());
                for (ServiceRegistration service : services) {
                    switch (service.getServiceState()) {
                        case WARNING: {
                            health.setStatus(HEALTH_CHECK_STATUS_WARN);
                            health.addNote("service(s) in WARN state");
                            health.addServiceState(this.getServiceStateAsJson(service));
                            break;
                        }
                        case ERROR: {
                            health.setStatus(HEALTH_CHECK_STATUS_WARN);
                            health.addNote("service(s) in ERROR state");
                            health.addServiceState(this.getServiceStateAsJson(service));
                            break;
                        }
                    }
                }
            }
            catch (ServiceRegistryException e) {
                logger.error("Failed to get services: ", (Throwable)e);
                health.setStatus(HEALTH_CHECK_STATUS_FAIL);
                health.addNote("internal health check error!");
            }
        }
        return health;
    }

    protected Map<String, Object> getServiceStateAsJson(ServiceRegistration service) {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("componentId", service.getServiceType());
        json.put("observedValue", service.getServiceState().toString());
        json.put("changed", service.getStateChanged().toString());
        HashMap<String, String> links = new HashMap<String, String>();
        links.put("path", service.getPath());
        json.put("links", links);
        return json;
    }

    private List<Map<String, String>> getRestEndpointsAsJson(HttpServletRequest request) throws MalformedURLException, InvalidSyntaxException {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        ServiceReference[] serviceRefs = this.getRestServiceReferences();
        if (serviceRefs == null) {
            return result;
        }
        for (ServiceReference servletRef : RuntimeInfo.sort(serviceRefs)) {
            String servletContextPath = (String)servletRef.getProperty("opencast.service.path");
            HashMap<String, String> endpoint = new HashMap<String, String>();
            endpoint.put("description", (String)servletRef.getProperty("service.description"));
            endpoint.put("version", servletRef.getBundle().getVersion().toString());
            endpoint.put("type", (String)servletRef.getProperty("opencast.service.type"));
            URL url = new URL(request.getScheme(), request.getServerName(), request.getServerPort(), servletContextPath);
            endpoint.put("path", servletContextPath);
            endpoint.put("docs", UrlSupport.concat((String)url.toExternalForm(), (String)"/docs"));
            result.add(endpoint);
        }
        return result;
    }

    private List<Map<String, String>> getUserInterfacesAsJson() throws InvalidSyntaxException {
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        ServiceReference[] serviceRefs = this.getUserInterfaceServiceReferences();
        if (serviceRefs == null) {
            return result;
        }
        for (ServiceReference ref : RuntimeInfo.sort(serviceRefs)) {
            String description = (String)ref.getProperty("service.description");
            String version = ref.getBundle().getVersion().toString();
            String alias = (String)ref.getProperty("alias");
            String welcomeFile = (String)ref.getProperty("welcome.file");
            String welcomePath = "/".equals(alias) ? alias + welcomeFile : alias + "/" + welcomeFile;
            HashMap<String, Object> endpoint = new HashMap<String, Object>();
            endpoint.put("description", description);
            endpoint.put("version", version);
            endpoint.put("welcomepage", String.valueOf(this.serverUrl) + welcomePath);
            result.add(endpoint);
        }
        return result;
    }

    private static SortedSet<ServiceReference> sort(ServiceReference[] references) {
        TreeSet<ServiceReference> sortedServiceRefs = new TreeSet<ServiceReference>((o1, o2) -> {
            String o1Description = Objects.toString(o1.getProperty("service.description"), o1.toString());
            String o2Description = Objects.toString(o2.getProperty("service.description"), o2.toString());
            return o1Description.compareTo(o2Description);
        });
        sortedServiceRefs.addAll(Arrays.asList(references));
        return sortedServiceRefs;
    }

    private class Health {
        private String status = "pass";
        private List<String> notes = new ArrayList<String>();
        private List<Object> serviceStates = new ArrayList<Object>();

        Health(RuntimeInfo runtimeInfo) {
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public List<String> getNotes() {
            return this.notes;
        }

        public void setNotes(List<String> notes) {
            this.notes = notes;
        }

        public List<Object> getServiceStates() {
            return this.serviceStates;
        }

        public void setServiceStates(List<Object> serviceStates) {
            this.serviceStates = serviceStates;
        }

        public void addNote(String note) {
            this.notes.add(note);
        }

        public void addServiceState(Object serviceState) {
            this.serviceStates.add(serviceState);
        }
    }
}

