/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.runtimeinfo.ui;

import io.swagger.v3.oas.annotations.Hidden;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.jaxrs.whiteboard.propertytypes.JaxrsResource;

@Path(value="/")
@Hidden
@Component(immediate=true, service={WelcomeResources.class}, property={"service.description=Welcome Resources", "opencast.service.type=org.opencastproject.welcome", "opencast.service.path=/"})
@JaxrsResource
public class WelcomeResources {
    private static final Map<String, MediaType> MEDIA_TYPES = new HashMap<String, MediaType>();

    @GET
    @Path(value="{path: .*}")
    public Response img(@PathParam(value="path") String path) {
        InputStream resource;
        if ("".equals(path)) {
            path = "index.html";
        }
        return Objects.isNull(resource = this.getClass().getClassLoader().getResourceAsStream("ui/" + path)) ? Response.status((Response.Status)Response.Status.NOT_FOUND).build() : Response.ok().entity((Object)resource).build();
    }

    @GET
    @Path(value="{path: (img|scripts|styles)/.*}")
    public Response staticResources(@PathParam(value="path") String path) {
        String extension;
        InputStream resource = this.getClass().getClassLoader().getResourceAsStream("ui/" + path);
        Response.ResponseBuilder builder = Objects.isNull(resource) ? Response.status((Response.Status)Response.Status.NOT_FOUND) : Response.ok().entity((Object)resource);
        int index = path.lastIndexOf(".");
        if (index != -1 && MEDIA_TYPES.containsKey(extension = path.substring(index + 1))) {
            builder.type(MEDIA_TYPES.get(extension));
        }
        return builder.build();
    }

    static {
        MEDIA_TYPES.put("js", new MediaType("text", "javascript", StandardCharsets.UTF_8.name()));
        MEDIA_TYPES.put("css", new MediaType("text", "css"));
        MEDIA_TYPES.put("svg", new MediaType("image", "svg+xml"));
        MEDIA_TYPES.put("png", new MediaType("image", "png"));
    }
}

