/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.test.rest;

import java.io.IOException;
import java.net.URL;
import java.util.concurrent.ThreadLocalRandom;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.opencastproject.util.UrlSupport;
import org.opencastproject.util.data.functions.Misc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RestServiceTestEnv {
    private Server server;
    private URL baseUrl = null;
    private final ResourceConfig cfg;
    private static final Logger logger = LoggerFactory.getLogger(RestServiceTestEnv.class);

    private RestServiceTestEnv(ResourceConfig cfg) {
        this.cfg = cfg;
    }

    public static RestServiceTestEnv testEnvForClasses(Class<?> ... restServices) {
        return new RestServiceTestEnv(new ResourceConfig((Class[])restServices));
    }

    public String host(String path) {
        if (this.baseUrl == null) {
            throw new RuntimeException("Server not yet started");
        }
        return UrlSupport.url((URL)this.baseUrl, (String)path).toString();
    }

    public void setUpServer() {
        int port = -1;
        int maxRetries = 100;
        try {
            ServletContainer servletContainer = new ServletContainer(this.cfg);
            ServletHolder jerseyServlet = new ServletHolder((Servlet)servletContainer);
            for (int tries = maxRetries; tries > 0; --tries) {
                try {
                    port = 3000 + tries + ThreadLocalRandom.current().nextInt(62000);
                    logger.info("Starting http server at port {}", (Object)port);
                    this.server = new Server(port);
                    ServletContextHandler context = new ServletContextHandler((HandlerContainer)this.server, "/");
                    context.addServlet(jerseyServlet, "/*");
                    this.server.start();
                    this.baseUrl = UrlSupport.url((String)"http", (String)"127.0.0.1", (int)port);
                    return;
                }
                catch (IOException e) {
                    logger.error("Couldn't bind server to port {}. Retrying with new port...", (Object)port, (Object)e);
                    if (tries == 1) {
                        logger.error("Couldn't start server after {} tries.", (Object)maxRetries);
                        throw e;
                    }
                    Thread.sleep(100L);
                    continue;
                }
            }
        }
        catch (Exception e) {
            logger.error("Unexpected Exception occurred while setting up http server");
            Misc.chuck((Throwable)e);
        }
    }

    public void tearDownServer() {
        if (this.server != null) {
            logger.info("Stop http server");
            try {
                this.server.stop();
            }
            catch (Exception e) {
                logger.warn("Stop http server - failed {}", (Object)e.getMessage());
            }
        }
    }
}

