/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.presets.impl;

import org.apache.commons.lang3.StringUtils;
import org.opencastproject.presets.api.PresetProvider;
import org.opencastproject.security.api.SecurityService;
import org.opencastproject.series.api.SeriesService;
import org.opencastproject.util.NotFoundException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={PresetProvider.class}, property={"service.description=Provides Series and Organization Presets"})
public class PresetProviderImpl
implements PresetProvider {
    private static final Logger logger = LoggerFactory.getLogger(PresetProvider.class);
    private SeriesService seriesService;
    private SecurityService securityService;

    @Reference
    public void setSeriesService(SeriesService seriesService) {
        this.seriesService = seriesService;
    }

    @Reference
    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Override
    public String getProperty(String seriesID, String propertyName) throws NotFoundException {
        String propertyValue = "";
        if (StringUtils.trimToNull((String)seriesID) != null) {
            try {
                propertyValue = this.seriesService.getSeriesProperty(seriesID, propertyName);
            }
            catch (NotFoundException e) {
                logger.debug("The property {} was not found in the series {} so we will try to find it in the organization.", (Object)propertyName, (Object)seriesID);
            }
            catch (Exception e) {
                logger.warn("Unable to get the property {} from the series {} so we will try to find it in the organization. The exception was ", new Object[]{propertyName, seriesID, e});
            }
        }
        if (StringUtils.isBlank((CharSequence)propertyValue) && StringUtils.isBlank((CharSequence)(propertyValue = (String)this.securityService.getOrganization().getProperties().get(propertyName)))) {
            throw new NotFoundException("Unable to find the property in either the series or organization");
        }
        return propertyValue;
    }
}

