/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.playlists.persistence;

import java.util.stream.Stream;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;
import org.opencastproject.playlists.PlaylistEntryType;

@Converter(autoApply=true)
public class PlaylistEntryTypeConverter
implements AttributeConverter<PlaylistEntryType, String> {
    public String convertToDatabaseColumn(PlaylistEntryType type) {
        if (type == null) {
            return null;
        }
        return type.getCode();
    }

    public PlaylistEntryType convertToEntityAttribute(String code) {
        if (code == null) {
            return null;
        }
        return Stream.of(PlaylistEntryType.values()).filter(c -> c.getCode().equals(code)).findFirst().orElseThrow(IllegalArgumentException::new);
    }
}

