/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.playlists;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OrderColumn;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.opencastproject.playlists.PlaylistAccessControlEntry;
import org.opencastproject.playlists.PlaylistEntry;
import org.opencastproject.util.RequireUtil;

@Entity(name="Playlist")
@Table(name="oc_playlist")
@NamedQueries(value={@NamedQuery(name="Playlist.findById", query="SELECT p FROM Playlist p WHERE p.id = :id and p.organization = :organizationId")})
public class Playlist {
    @Id
    @Column(name="id")
    private String id;
    @Column(name="organization", nullable=false, length=128)
    private String organization;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REMOVE}, mappedBy="playlist", orphanRemoval=true)
    @OrderColumn(name="position_entries")
    private List<PlaylistEntry> entries = new ArrayList<PlaylistEntry>();
    @Column(name="title")
    private String title;
    @Column(name="description")
    private String description;
    @Column(name="creator")
    private String creator;
    @Column(name="updated", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date updated;
    @Column(name="deletion_date")
    @Temporal(value=TemporalType.TIMESTAMP)
    protected Date deletionDate = null;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REMOVE}, mappedBy="playlist", orphanRemoval=true)
    @OrderColumn(name="position_access_control_entries")
    private List<PlaylistAccessControlEntry> accessControlEntries = new ArrayList<PlaylistAccessControlEntry>();

    @PrePersist
    public void generateId() {
        if (this.id == null) {
            this.id = UUID.randomUUID().toString();
        }
    }

    public Playlist() {
    }

    public Playlist(String id, String organization, List<PlaylistEntry> entries, String title, String description, String creator, Date updated, List<PlaylistAccessControlEntry> accessControlEntries) {
        this.id = id;
        this.organization = organization;
        this.entries = entries;
        this.title = title;
        this.description = description;
        this.creator = creator;
        this.updated = updated;
        this.accessControlEntries = accessControlEntries;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String organization) {
        this.organization = organization;
    }

    public List<PlaylistEntry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<PlaylistEntry> entries) {
        for (PlaylistEntry entry : entries) {
            if (this.entries.stream().noneMatch(e -> entry.getId() == e.getId())) {
                entry.setId(0L);
            }
            entry.setPlaylist(this);
        }
        this.entries = entries;
    }

    public boolean addEntry(PlaylistEntry entry) {
        RequireUtil.notNull((Object)entry, (String)"entry");
        if (this.entries.contains(entry)) {
            this.entries.remove(entry);
        }
        entry.setPlaylist(this);
        return this.entries.add(entry);
    }

    public boolean removeEntry(PlaylistEntry entry) {
        RequireUtil.notNull((Object)entry, (String)"entry");
        entry.setPlaylist(null);
        return this.entries.remove(entry);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public void setUpdated(Date updated) {
        this.updated = updated;
    }

    public Date getDeletionDate() {
        return this.deletionDate;
    }

    public void setDeletionDate(Date deletionDate) {
        this.deletionDate = deletionDate;
    }

    public boolean isDeleted() {
        return this.deletionDate != null;
    }

    public List<PlaylistAccessControlEntry> getAccessControlEntries() {
        return this.accessControlEntries;
    }

    public void setAccessControlEntries(List<PlaylistAccessControlEntry> accessControlEntries) {
        for (PlaylistAccessControlEntry accessControlEntry : accessControlEntries) {
            accessControlEntry.setPlaylist(this);
        }
        this.accessControlEntries = accessControlEntries;
    }
}

