/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.playlists;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationModule;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.simple.parser.ParseException;
import org.opencastproject.playlists.Playlist;
import org.opencastproject.playlists.PlaylistEntryType;
import org.opencastproject.playlists.PlaylistService;
import org.opencastproject.playlists.serialization.JaxbPlaylist;
import org.opencastproject.search.api.SearchService;
import org.opencastproject.security.api.AuthorizationService;
import org.opencastproject.security.api.UnauthorizedException;
import org.opencastproject.util.NotFoundException;
import org.opencastproject.util.XmlSafeParser;
import org.opencastproject.util.data.Option;
import org.opencastproject.util.doc.rest.RestParameter;
import org.opencastproject.util.doc.rest.RestQuery;
import org.opencastproject.util.doc.rest.RestResponse;
import org.opencastproject.util.doc.rest.RestService;
import org.opencastproject.util.requests.SortCriterion;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@Path(value="/")
@RestService(name="playlistservice", title="Playlist Service", abstractText="This service lists available playlists and stuff", notes={"All paths above are relative to the REST endpoint base (something like http://your.server/files)", "If the service is down or not working it will return a status 503, this means the the underlying service is not working and is either restarting or has failed", "A status code 500 means a general failure has occurred which is not recoverable and was not anticipated. In other words, there is a bug! You should file an error report with your server logs from the time when the error occurred: <a href=\"https://github.com/opencast/opencast/issues\">Opencast Issue Tracker</a>"})
@Component(immediate=true, service={PlaylistRestService.class}, property={"service.description=Playlist REST Endpoint", "opencast.service.type=org.opencastproject.playlists", "opencast.service.path=/playlists"})
public class PlaylistRestService {
    private static final Logger logger = LoggerFactory.getLogger(PlaylistRestService.class);
    public static final String SAMPLE_PLAYLIST_JSON = "{\n        \"title\": \"Opencast Playlist\",\n        \"description\": \"This is a playlist about Opencast\",\n        \"creator\": \"Opencast\",\n        \"entries\": [\n            {\n                \"contentId\": \"ID-about-opencast\",\n                \"type\": \"EVENT\"\n            },\n            {\n                \"contentId\": \"ID-3d-print\",\n                \"type\": \"EVENT\"\n            }\n        ],\n        \"accessControlEntries\": [\n            {\n                \"allow\": true,\n                \"role\": \"ROLE_USER_BOB\",\n                \"action\": \"read\"\n            }\n        ]\n}";
    public static final String SAMPLE_PLAYLIST_ENTRIES_JSON = "[\n            {\n                \"contentId\": \"ID-about-opencast\",\n                \"type\": \"EVENT\"\n            },\n            {\n                \"contentId\": \"ID-3d-print\",\n                \"type\": \"EVENT\"\n            }\n        ],";
    public static final String SAMPLE_PLAYLIST_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><ns3:playlist xmlns:ns2=\"http://mediapackage.opencastproject.org\" xmlns:ns3=\"http://playlist.opencastproject.org\"><organization>mh_default_org</organization><entries><contentId>ID-av-portal</contentId><type>EVENT</type></entries><entries><contentId>ID-av-print</contentId><type>EVENT</type></entries><title>Opencast Playlist</title><description>This is a playlist about Opencast</description><creator>Opencast</creator><updated>1701787700848</updated><accessControlEntries><allow>true</allow><role>ROLE_USER_BOB</role><action>read</action></accessControlEntries></ns3:playlist>";
    public static final String SAMPLE_PLAYLIST_ENTRIES_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<entries>\n\t<entry id=\"1061\">\n\t\t<contentId>ID-av-portal</contentId>\n\t\t<type>EVENT</type>\n\t</entry>\n\t<entry id=\"1062\">\n\t\t<contentId>ID-av-print</contentId>\n\t\t<type>EVENT</type>\n\t</entry>\n</entries>";
    private PlaylistService service;
    protected SearchService searchService = null;
    protected AuthorizationService authorizationService = null;

    @Reference
    public void setService(PlaylistService service) {
        this.service = service;
    }

    @Reference
    protected void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    @Reference
    public void setAuthorizationService(AuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{id}.json")
    @RestQuery(name="playlist", description="Get a playlist.", returnDescription="A playlist as JSON", pathParameters={@RestParameter(name="id", isRequired=true, description="The playlist identifier", type=RestParameter.Type.STRING)}, restParameters={@RestParameter(name="withPublications", isRequired=false, description="If available publications forthe content should be returned. Only works for content of type EVENT.", type=RestParameter.Type.BOOLEAN, defaultValue="true")}, responses={@RestResponse(responseCode=200, description="A playlist as JSON."), @RestResponse(responseCode=404, description="No playlist with that identifier exists."), @RestResponse(responseCode=401, description="Not authorized to perform this action")})
    public Response getPlaylistAsJson(@PathParam(value="id") String id, @FormParam(value="withPublications") boolean withPublications) throws NotFoundException, UnauthorizedException {
        Playlist playlist = this.service.getPlaylistById(id);
        JaxbPlaylist jaxbPlaylist = withPublications ? this.service.enrich(playlist) : new JaxbPlaylist(playlist);
        return Response.ok().entity((Object)jaxbPlaylist).build();
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="{id}.xml")
    @RestQuery(name="playlist", description="Get a playlist.", returnDescription="A playlist as XML", pathParameters={@RestParameter(name="id", isRequired=true, description="The playlist identifier", type=RestParameter.Type.STRING)}, restParameters={@RestParameter(name="withPublications", isRequired=false, description="If available publications forthe content should be returned. Only works for content of type EVENT.", type=RestParameter.Type.BOOLEAN, defaultValue="true")}, responses={@RestResponse(responseCode=200, description="A playlist as XML."), @RestResponse(responseCode=404, description="No playlist with that identifier exists."), @RestResponse(responseCode=401, description="Not authorized to perform this action")})
    public Response getPlaylistAsXml(@PathParam(value="id") String id, @FormParam(value="withPublications") boolean withPublications) throws NotFoundException, UnauthorizedException {
        return this.getPlaylistAsJson(id, withPublications);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="playlists.json")
    @RestQuery(name="playlists", description="Get playlists. Playlists that you do not have read access to will not show up.", returnDescription="A JSON object containing an array.", restParameters={@RestParameter(name="limit", isRequired=false, type=RestParameter.Type.INTEGER, description="The maximum number of results to return for a single request.", defaultValue="100"), @RestParameter(name="offset", isRequired=false, type=RestParameter.Type.INTEGER, description="The index of the first result to return."), @RestParameter(name="sort", isRequired=false, type=RestParameter.Type.STRING, description="Sort the results based upon a sorting criteria. A criteria is specified as a pair such as:<Sort Name>:ASC or <Sort Name>:DESC. Adding the suffix ASC or DESC sets the order as ascending ordescending order and is mandatory. Sort Name is case sensitive. Supported Sort Names are 'updated'", defaultValue="updated:ASC")}, responses={@RestResponse(responseCode=200, description="A playlist as JSON."), @RestResponse(responseCode=400, description="A request parameter was illegal.")})
    public Response getPlaylistsAsJson(@FormParam(value="limit") int limit, @FormParam(value="offset") int offset, @FormParam(value="sort") String sort) throws NotFoundException {
        if (offset < 0) {
            return Response.status((int)400).build();
        }
        if (limit < 0) {
            return Response.status((int)400).build();
        }
        SortCriterion sortCriterion = new SortCriterion("", SortCriterion.Order.None);
        Option optSort = Option.option((Object)StringUtils.trimToNull((String)sort));
        if (optSort.isSome()) {
            sortCriterion = SortCriterion.parse((String)((String)optSort.get()));
            switch (sortCriterion.getFieldName()) {
                case "updated": {
                    break;
                }
                default: {
                    logger.info("Unknown sort criteria {}", (Object)sortCriterion.getFieldName());
                    return Response.status((int)400).build();
                }
            }
        }
        ArrayList<JaxbPlaylist> jaxbPlaylists = new ArrayList<JaxbPlaylist>();
        for (Playlist playlist : this.service.getPlaylists(limit, offset, sortCriterion)) {
            jaxbPlaylists.add(new JaxbPlaylist(playlist));
        }
        return Response.ok().entity((Object)new GenericEntity<List<JaxbPlaylist>>(jaxbPlaylists){}).build();
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="playlists.xml")
    @RestQuery(name="playlists", description="Get playlists. Playlists that you do not have read access to will not show up.", returnDescription="A XML object containing an array.", restParameters={@RestParameter(name="limit", isRequired=false, type=RestParameter.Type.INTEGER, description="The maximum number of results to return for a single request.", defaultValue="100"), @RestParameter(name="offset", isRequired=false, type=RestParameter.Type.INTEGER, description="The index of the first result to return."), @RestParameter(name="sort", isRequired=false, type=RestParameter.Type.STRING, description="Sort the results based upon a sorting criteria. A criteria is specified as a pair such as:<Sort Name>:ASC or <Sort Name>:DESC. Adding the suffix ASC or DESC sets the order as ascending ordescending order and is mandatory. Sort Name is case sensitive. Supported Sort Names are 'updated'", defaultValue="updated:ASC")}, responses={@RestResponse(responseCode=200, description="A playlist as XML.")})
    public Response getPlaylistsAsXml(@FormParam(value="limit") int limit, @FormParam(value="offset") int offset, @FormParam(value="sort") String sort) throws NotFoundException {
        return this.getPlaylistsAsJson(limit, offset, sort);
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="new.json")
    @RestQuery(name="create", description="Creates a playlist.", returnDescription="The created playlist.", restParameters={@RestParameter(name="playlist", isRequired=false, description="Playlist in JSON format", type=RestParameter.Type.TEXT, jaxbClass=JaxbPlaylist.class, defaultValue="{\n        \"title\": \"Opencast Playlist\",\n        \"description\": \"This is a playlist about Opencast\",\n        \"creator\": \"Opencast\",\n        \"entries\": [\n            {\n                \"contentId\": \"ID-about-opencast\",\n                \"type\": \"EVENT\"\n            },\n            {\n                \"contentId\": \"ID-3d-print\",\n                \"type\": \"EVENT\"\n            }\n        ],\n        \"accessControlEntries\": [\n            {\n                \"allow\": true,\n                \"role\": \"ROLE_USER_BOB\",\n                \"action\": \"read\"\n            }\n        ]\n}")}, responses={@RestResponse(responseCode=201, description="Playlist created."), @RestResponse(responseCode=401, description="Not authorized to perform this action")})
    public Response createAsJson(@FormParam(value="playlist") String playlistText) throws UnauthorizedException {
        try {
            Playlist playlist = this.parseJsonToPlaylist(playlistText);
            playlist = this.service.update(playlist);
            return Response.status((Response.Status)Response.Status.CREATED).entity((Object)new JaxbPlaylist(playlist)).build();
        }
        catch (Exception e) {
            return Response.serverError().build();
        }
    }

    @POST
    @Produces(value={"application/xml"})
    @Path(value="new.xml")
    @RestQuery(name="create", description="Creates a playlist.", returnDescription="The created playlist.", restParameters={@RestParameter(name="playlist", isRequired=false, description="Playlist in XML format", type=RestParameter.Type.TEXT, jaxbClass=JaxbPlaylist.class, defaultValue="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><ns3:playlist xmlns:ns2=\"http://mediapackage.opencastproject.org\" xmlns:ns3=\"http://playlist.opencastproject.org\"><organization>mh_default_org</organization><entries><contentId>ID-av-portal</contentId><type>EVENT</type></entries><entries><contentId>ID-av-print</contentId><type>EVENT</type></entries><title>Opencast Playlist</title><description>This is a playlist about Opencast</description><creator>Opencast</creator><updated>1701787700848</updated><accessControlEntries><allow>true</allow><role>ROLE_USER_BOB</role><action>read</action></accessControlEntries></ns3:playlist>")}, responses={@RestResponse(responseCode=200, description="Playlist updated."), @RestResponse(responseCode=401, description="Not authorized to perform this action")})
    public Response createAsXml(@FormParam(value="playlist") String playlistText) throws UnauthorizedException {
        try {
            Playlist playlist = this.parseXmlToPlaylist(playlistText);
            playlist = this.service.update(playlist);
            return Response.ok().entity((Object)new JaxbPlaylist(playlist)).build();
        }
        catch (Exception e) {
            return Response.serverError().build();
        }
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="{id}.json")
    @RestQuery(name="update", description="Updates a playlist.", returnDescription="The updated playlist.", pathParameters={@RestParameter(name="id", isRequired=true, description="Playlist identifier", type=RestParameter.Type.STRING)}, restParameters={@RestParameter(name="playlist", isRequired=false, description="Playlist in JSON format", type=RestParameter.Type.TEXT, jaxbClass=JaxbPlaylist.class, defaultValue="{\n        \"title\": \"Opencast Playlist\",\n        \"description\": \"This is a playlist about Opencast\",\n        \"creator\": \"Opencast\",\n        \"entries\": [\n            {\n                \"contentId\": \"ID-about-opencast\",\n                \"type\": \"EVENT\"\n            },\n            {\n                \"contentId\": \"ID-3d-print\",\n                \"type\": \"EVENT\"\n            }\n        ],\n        \"accessControlEntries\": [\n            {\n                \"allow\": true,\n                \"role\": \"ROLE_USER_BOB\",\n                \"action\": \"read\"\n            }\n        ]\n}")}, responses={@RestResponse(responseCode=200, description="Playlist updated."), @RestResponse(responseCode=401, description="Not authorized to perform this action")})
    public Response updateAsJson(@PathParam(value="id") String id, @FormParam(value="playlist") String playlistText) throws UnauthorizedException {
        try {
            Playlist playlist = this.service.updateWithJson(id, playlistText);
            return Response.ok().entity((Object)new JaxbPlaylist(playlist)).build();
        }
        catch (Exception e) {
            return Response.serverError().build();
        }
    }

    @PUT
    @Produces(value={"application/xml"})
    @Path(value="{id}.xml")
    @RestQuery(name="update", description="Updates a playlist.", returnDescription="The updated playlist.", pathParameters={@RestParameter(name="id", isRequired=true, description="Playlist identifier", type=RestParameter.Type.STRING)}, restParameters={@RestParameter(name="playlist", isRequired=false, description="Playlist in XML format", type=RestParameter.Type.TEXT, jaxbClass=JaxbPlaylist.class, defaultValue="<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><ns3:playlist xmlns:ns2=\"http://mediapackage.opencastproject.org\" xmlns:ns3=\"http://playlist.opencastproject.org\"><organization>mh_default_org</organization><entries><contentId>ID-av-portal</contentId><type>EVENT</type></entries><entries><contentId>ID-av-print</contentId><type>EVENT</type></entries><title>Opencast Playlist</title><description>This is a playlist about Opencast</description><creator>Opencast</creator><updated>1701787700848</updated><accessControlEntries><allow>true</allow><role>ROLE_USER_BOB</role><action>read</action></accessControlEntries></ns3:playlist>")}, responses={@RestResponse(responseCode=200, description="Playlist updated."), @RestResponse(responseCode=401, description="Not authorized to perform this action")})
    public Response updateAsXml(@PathParam(value="id") String id, @FormParam(value="playlist") String playlistText) throws UnauthorizedException {
        try {
            XmlMapper xmlMapper = new XmlMapper();
            JsonNode node = xmlMapper.readTree(playlistText.getBytes());
            ObjectMapper jsonMapper = new ObjectMapper();
            jsonMapper.enable(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
            String json = jsonMapper.writeValueAsString((Object)node);
            Playlist playlist = this.service.updateWithJson(id, json);
            return Response.ok().entity((Object)new JaxbPlaylist(playlist)).build();
        }
        catch (Exception e) {
            return Response.serverError().build();
        }
    }

    @DELETE
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @RestQuery(name="remove", description="Removes a playlist.", returnDescription="The removed playlist.", pathParameters={@RestParameter(name="id", isRequired=true, description="Playlist identifier", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="Playlist removed."), @RestResponse(responseCode=404, description="No playlist with that identifier exists."), @RestResponse(responseCode=401, description="Not authorized to perform this action")})
    public Response remove(@PathParam(value="id") String id) throws NotFoundException, UnauthorizedException {
        try {
            Playlist playlist = this.service.remove(id);
            return Response.ok().entity((Object)new JaxbPlaylist(playlist)).build();
        }
        catch (Exception e) {
            return Response.serverError().build();
        }
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="{id}/entries/new")
    @RestQuery(name="addEntry", description="Add entry to playlist.", returnDescription="The playlist with the new entry.", pathParameters={@RestParameter(name="id", isRequired=true, description="Playlist identifier", type=RestParameter.Type.STRING)}, restParameters={@RestParameter(name="contentId", isRequired=false, description="Content identifier", type=RestParameter.Type.STRING), @RestParameter(name="type", isRequired=false, description="Entry type. Enum. Valid values are EVENT, INACCESSIBLE.", type=RestParameter.Type.STRING)}, responses={@RestResponse(responseCode=200, description="Playlist updated."), @RestResponse(responseCode=404, description="No playlist with that identifier exists."), @RestResponse(responseCode=401, description="Not authorized to perform this action")})
    public Response addEntry(@PathParam(value="id") String playlistId, @FormParam(value="contentId") String contentId, @FormParam(value="type") PlaylistEntryType type) throws NotFoundException, UnauthorizedException {
        try {
            Playlist playlist = this.service.addEntry(playlistId, contentId, type);
            return Response.ok().entity((Object)new JaxbPlaylist(playlist)).build();
        }
        catch (Exception e) {
            return Response.serverError().build();
        }
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="{id}/entries/{entryId}")
    @RestQuery(name="removeEntry", description="Remove entry from playlist.", returnDescription="Playlist without the entry.", pathParameters={@RestParameter(name="id", isRequired=true, type=RestParameter.Type.STRING, description="Identifier of the playlist to delete from"), @RestParameter(name="entryId", isRequired=false, type=RestParameter.Type.LONG, description="Identifier of the entry that should be deleted")}, responses={@RestResponse(responseCode=200, description="Playlist updated."), @RestResponse(responseCode=404, description="No playlist or entry with that identifier exists."), @RestResponse(responseCode=401, description="Not authorized to perform this action")})
    public Response addEntry(@PathParam(value="id") String playlistId, @PathParam(value="entryId") Long entryId) throws NotFoundException, UnauthorizedException {
        try {
            Playlist playlist = this.service.removeEntry(playlistId, entryId);
            return Response.ok().entity((Object)new JaxbPlaylist(playlist)).build();
        }
        catch (Exception e) {
            return Response.serverError().build();
        }
    }

    public Playlist parseJsonToPlaylist(String json) throws ParseException, IOException {
        JaxbAnnotationModule module = new JaxbAnnotationModule();
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)module);
        JaxbPlaylist jaxbPlaylist = (JaxbPlaylist)objectMapper.readValue(json, JaxbPlaylist.class);
        return jaxbPlaylist.toPlaylist();
    }

    private Playlist parseXmlToPlaylist(String xml) throws JAXBException, IOException, SAXException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{JaxbPlaylist.class});
        JaxbPlaylist jaxbPlaylist = (JaxbPlaylist)context.createUnmarshaller().unmarshal((Node)XmlSafeParser.parse((InputStream)IOUtils.toInputStream((String)xml, (String)"UTF8")), JaxbPlaylist.class).getValue();
        return jaxbPlaylist.toPlaylist();
    }
}

