/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.playlists;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.opencastproject.playlists.Playlist;
import org.opencastproject.security.api.AccessControlEntry;

@Entity(name="PlaylistAccessControlEntry")
@Table(name="oc_playlist_access_control_entry")
public class PlaylistAccessControlEntry {
    @Id
    @GeneratedValue
    @Column(name="id")
    private long id;
    @Column(name="allow", nullable=false)
    private boolean allow;
    @Column(name="role", nullable=false)
    private String role;
    @Column(name="action", nullable=false)
    private String action;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="playlist_id", nullable=false)
    private Playlist playlist;

    public PlaylistAccessControlEntry() {
    }

    public PlaylistAccessControlEntry(boolean allow, String role, String action) {
        this.allow = allow;
        this.role = role;
        this.action = action;
    }

    public PlaylistAccessControlEntry(long id, boolean allow, String role, String action) {
        this.id = id;
        this.allow = allow;
        this.role = role;
        this.action = action;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public boolean isAllow() {
        return this.allow;
    }

    public void setAllow(boolean allow) {
        this.allow = allow;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public Playlist getPlaylist() {
        return this.playlist;
    }

    public void setPlaylist(Playlist playlist) {
        this.playlist = playlist;
    }

    public AccessControlEntry toAccessControlEntry() {
        return new AccessControlEntry(this.getRole(), this.getAction(), this.isAllow());
    }

    public void fromAccessControlEntry(AccessControlEntry accessControlEntry) {
        this.setAllow(accessControlEntry.isAllow());
        this.setRole(accessControlEntry.getRole());
        this.setAction(accessControlEntry.getAction());
    }
}

