/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.workflow.handler.notification;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.opencastproject.job.api.JobContext;
import org.opencastproject.serviceregistry.api.ServiceRegistry;
import org.opencastproject.workflow.api.AbstractWorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowInstance;
import org.opencastproject.workflow.api.WorkflowOperationException;
import org.opencastproject.workflow.api.WorkflowOperationHandler;
import org.opencastproject.workflow.api.WorkflowOperationResult;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={WorkflowOperationHandler.class}, property={"service.description=Http Notification Operation Handler", "workflow.operation=http-notify"})
public class HttpNotificationWorkflowOperationHandler
extends AbstractWorkflowOperationHandler {
    public static final String OPT_URL_PATH = "url";
    public static final String OPT_NOTIFICATION_SUBJECT = "subject";
    public static final String OPT_NOTIFICATION_MESSAGE = "message";
    public static final String OPT_METHOD = "method";
    public static final String OPT_MAX_RETRY = "max-retry";
    public static final String OPT_TIMEOUT = "timeout";
    public static final String HTTP_PARAM_SUBJECT = "subject";
    public static final String HTTP_PARAM_MESSAGE = "message";
    public static final String HTTP_PARAM_WORKFLOW = "workflowInstanceId";
    private static final Logger logger = LoggerFactory.getLogger(HttpNotificationWorkflowOperationHandler.class);
    private static final int DEFAULT_MAX_RETRY = 5;
    private static final int DEFAULT_TIMEOUT = 10000;
    public static final int INITIAL_SLEEP_TIME = 10000;
    public static final int SLEEP_SCALE_FACTOR = 2;

    public WorkflowOperationResult start(WorkflowInstance workflowInstance, JobContext context) throws WorkflowOperationException {
        logger.debug("Running HTTP notification workflow operation on workflow {}", (Object)workflowInstance.getId());
        int maxRetry = 5;
        int timeout = 10000;
        String urlPath = this.getConfig(workflowInstance, OPT_URL_PATH);
        String notificationSubject = this.getConfig(workflowInstance, "subject", null);
        String notificationMessage = this.getConfig(workflowInstance, "message", null);
        String method = this.getConfig(workflowInstance, OPT_METHOD, "post");
        String maxRetryOpt = this.getConfig(workflowInstance, OPT_MAX_RETRY, null);
        String timeoutOpt = this.getConfig(workflowInstance, OPT_TIMEOUT, null);
        if (timeoutOpt != null) {
            timeout = Integer.parseInt(timeoutOpt) * 1000;
        }
        if (maxRetryOpt != null) {
            maxRetry = Integer.parseInt(maxRetryOpt);
        }
        HttpPost request = null;
        if (StringUtils.equalsIgnoreCase((CharSequence)"post", (CharSequence)method)) {
            request = new HttpPost(urlPath);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"put", (CharSequence)method)) {
            request = new HttpPut(urlPath);
        } else {
            throw new WorkflowOperationException("The configuration key 'method' only supports 'post' and 'put'");
        }
        logger.debug("Request will be sent using the '{}' method", (Object)method);
        try {
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            if (notificationSubject != null) {
                params.add(new BasicNameValuePair("subject", notificationSubject));
            }
            if (notificationMessage != null) {
                params.add(new BasicNameValuePair("message", notificationMessage));
            }
            params.add(new BasicNameValuePair(HTTP_PARAM_WORKFLOW, Long.toString(workflowInstance.getId())));
            request.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new WorkflowOperationException("Error happened during the encoding of the event parameter as form parameter:", (Throwable)e);
        }
        if (!this.executeRequest((HttpUriRequest)request, maxRetry, timeout, 10000)) {
            throw new WorkflowOperationException(String.format("Notification could not be delivered to %s", urlPath));
        }
        return this.createResult(workflowInstance.getMediaPackage(), WorkflowOperationResult.Action.CONTINUE);
    }

    private boolean executeRequest(HttpUriRequest request, int maxAttempts, int timeout, int sleepTime) {
        CloseableHttpResponse response;
        logger.debug("Executing notification request on target {}, {} attempts left", (Object)request.getURI(), (Object)maxAttempts);
        RequestConfig config = RequestConfig.custom().setConnectTimeout(timeout).setConnectionRequestTimeout(timeout).setSocketTimeout(timeout).build();
        CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
        try {
            response = httpClient.execute(request);
        }
        catch (ClientProtocolException e) {
            logger.error("Protocol error during execution of query on target {}: {}", (Object)request.getURI(), (Object)e.getMessage());
            return false;
        }
        catch (IOException e) {
            logger.error("I/O error during execution of query on target {}: {}", (Object)request.getURI(), (Object)e.getMessage());
            return false;
        }
        Integer statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 200 || statusCode == 204 || statusCode == 202) {
            logger.debug("Request successfully executed on target {}, status code: {}", (Object)request.getURI(), (Object)statusCode);
            return true;
        }
        if (maxAttempts > 1) {
            logger.debug("Request failed on target {}, status code: {}, will retry in {} seconds", new Object[]{request.getURI(), statusCode, sleepTime / 1000});
            try {
                Thread.sleep(sleepTime);
                return this.executeRequest(request, --maxAttempts, timeout, sleepTime * 2);
            }
            catch (InterruptedException e) {
                logger.error("Error during sleep time before new notification request try: {}", (Object)e.getMessage());
                return false;
            }
        }
        logger.warn("Request failed on target {}, status code: {}, no more attempt.", (Object)request.getURI(), (Object)statusCode);
        return false;
    }

    @Reference
    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        super.setServiceRegistry(serviceRegistry);
    }
}

