/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.metadata.mpeg7;

import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.opencastproject.metadata.mpeg7.MediaTime;
import org.opencastproject.metadata.mpeg7.MediaTimeImpl;
import org.opencastproject.metadata.mpeg7.MediaTimePointImpl;
import org.opencastproject.metadata.mpeg7.SpatioTemporalLocator;
import org.opencastproject.metadata.mpeg7.SpatioTemporalLocatorImpl;
import org.opencastproject.metadata.mpeg7.Textual;
import org.opencastproject.metadata.mpeg7.VideoText;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class VideoTextImpl
implements VideoText {
    private static DecimalFormatSymbols standardSymbols = new DecimalFormatSymbols(Locale.US);
    protected VideoText.Type type = VideoText.Type.superimposed;
    protected String id = null;
    protected Textual text = null;
    protected Rectangle boundary = null;
    protected SpatioTemporalLocator locator = null;
    protected String fontType = null;
    protected int fontSize = -1;

    public VideoTextImpl(String id) {
        this(id, null, null, null);
    }

    public VideoTextImpl(String id, Textual text, Rectangle boundary, MediaTime time) {
        this.id = id;
        this.text = text;
        this.boundary = boundary;
        if (time != null) {
            this.locator = new SpatioTemporalLocatorImpl(time);
        }
    }

    @Override
    public void setIdentifier(String id) {
        this.id = id;
    }

    @Override
    public String getIdentifier() {
        return this.id;
    }

    @Override
    public void setType(VideoText.Type type) {
        this.type = type;
    }

    @Override
    public VideoText.Type getType() {
        return this.type;
    }

    @Override
    public void setText(Textual text) {
        this.text = text;
    }

    @Override
    public Textual getText() {
        return this.text;
    }

    @Override
    public void setBoundary(Rectangle rectangle) {
        this.boundary = rectangle;
    }

    @Override
    public Rectangle getBoundary() {
        return this.boundary;
    }

    @Override
    public void setFontSize(int size) {
        this.fontSize = size;
    }

    @Override
    public int getFontSize() {
        return this.fontSize;
    }

    @Override
    public void setFontType(String fontType) {
        this.fontType = fontType;
    }

    @Override
    public String getFontType() {
        return this.fontType;
    }

    @Override
    public void setSpatioTemporalLocator(SpatioTemporalLocator locator) {
        this.locator = locator;
    }

    @Override
    public SpatioTemporalLocator getSpatioTemporalLocator() {
        return this.locator;
    }

    public Node toXml(Document document) {
        DecimalFormat format = new DecimalFormat();
        format.setDecimalFormatSymbols(standardSymbols);
        Element videoText = document.createElement("VideoText");
        videoText.setAttribute("id", this.id);
        videoText.setAttribute("textType", this.type.toString());
        if (this.fontSize > 0) {
            videoText.setAttribute("fontSize", Integer.toString(this.fontSize));
        }
        if (this.fontType != null) {
            videoText.setAttribute("fontType", this.fontType);
        }
        if (this.locator != null) {
            videoText.appendChild(this.locator.toXml(document));
        }
        if (this.boundary != null) {
            Element temporalMask = document.createElement("SpatioTemporalMask");
            videoText.appendChild(temporalMask);
            Element subRegion = document.createElement("SubRegion");
            temporalMask.appendChild(subRegion);
            Element parameterTrajectory = document.createElement("ParameterTrajectory");
            subRegion.appendChild(parameterTrajectory);
            parameterTrajectory.appendChild(new MediaTimeImpl(new MediaTimePointImpl(), null).toXml(document));
            Element initialRegion = document.createElement("InitialRegion");
            parameterTrajectory.appendChild(initialRegion);
            StringBuffer coordinates = new StringBuffer();
            coordinates.append(format.format(this.boundary.getX())).append(" ");
            coordinates.append(format.format(this.boundary.getY())).append(" ");
            coordinates.append(format.format(this.boundary.getX() + this.boundary.getWidth())).append(" ");
            coordinates.append(format.format(this.boundary.getY() + this.boundary.getHeight()));
            Element box = document.createElement("Box");
            box.setAttribute("dim", "2 2");
            box.appendChild(document.createTextNode(coordinates.toString()));
            initialRegion.appendChild(box);
        }
        videoText.appendChild(this.text.toXml(document));
        return videoText;
    }
}

