/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.metadata.mpeg7;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.opencastproject.metadata.mpeg7.MediaTime;
import org.opencastproject.metadata.mpeg7.SpatioTemporalDecomposition;
import org.opencastproject.metadata.mpeg7.Textual;
import org.opencastproject.metadata.mpeg7.VideoText;
import org.opencastproject.metadata.mpeg7.VideoTextImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SpatioTemporalDecompositionImpl
implements SpatioTemporalDecomposition {
    protected boolean hasGap = true;
    protected boolean hasOverlap = false;
    protected List<VideoText> videoTexts = null;

    public SpatioTemporalDecompositionImpl(boolean gap, boolean overlap) {
        this.hasGap = gap;
        this.hasOverlap = overlap;
        this.videoTexts = new ArrayList<VideoText>();
    }

    @Override
    public boolean hasGap() {
        return this.hasGap;
    }

    @Override
    public boolean isOverlapping() {
        return this.hasOverlap;
    }

    @Override
    public void setGap(boolean hasGap) {
        this.hasGap = hasGap;
    }

    @Override
    public void setOverlapping(boolean isOverlapping) {
        this.hasOverlap = isOverlapping;
    }

    @Override
    public VideoText addVideoText(Textual text, Rectangle boundary, MediaTime time) {
        VideoTextImpl videoText = new VideoTextImpl("videotext-" + this.videoTexts.size(), text, boundary, time);
        this.videoTexts.add(videoText);
        return videoText;
    }

    @Override
    public void addVideoText(VideoText videoText) {
        this.videoTexts.add(videoText);
    }

    @Override
    public VideoText[] getVideoText() {
        return this.videoTexts.toArray(new VideoText[this.videoTexts.size()]);
    }

    @Override
    public VideoText getVideoText(String id) {
        for (VideoText videoText : this.videoTexts) {
            if (!id.equals(videoText.getIdentifier())) continue;
            return videoText;
        }
        return null;
    }

    public Node toXml(Document document) {
        Element node = document.createElement("SpatioTemporalDecomposition");
        node.setAttribute("gap", this.hasGap ? "true" : "false");
        node.setAttribute("overlap", this.hasOverlap ? "true" : "false");
        for (VideoText videoText : this.videoTexts) {
            node.appendChild(videoText.toXml(document));
        }
        return node;
    }
}

