/*
 * Decompiled with CFR 0.152.
 */
package org.opencastproject.metadata.mpeg7;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.opencastproject.metadata.mpeg7.AudioSegment;
import org.opencastproject.metadata.mpeg7.AudioVisualSegment;
import org.opencastproject.metadata.mpeg7.MediaTime;
import org.opencastproject.metadata.mpeg7.Segment;
import org.opencastproject.metadata.mpeg7.SpatioTemporalDecomposition;
import org.opencastproject.metadata.mpeg7.SpatioTemporalDecompositionImpl;
import org.opencastproject.metadata.mpeg7.TextAnnotation;
import org.opencastproject.metadata.mpeg7.TextAnnotationImpl;
import org.opencastproject.metadata.mpeg7.VideoSegment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SegmentImpl
implements Segment,
AudioSegment,
VideoSegment,
AudioVisualSegment {
    protected Segment.Type type = null;
    protected String id = null;
    protected MediaTime mediaTime = null;
    protected List<TextAnnotation> annotations = null;
    protected SpatioTemporalDecomposition spatioTemporalDecomposition = null;

    public SegmentImpl(Segment.Type type, String id) {
        this.type = type;
        this.id = id;
        this.annotations = new ArrayList<TextAnnotation>();
    }

    @Override
    public String getIdentifier() {
        return this.id;
    }

    @Override
    public void setMediaTime(MediaTime mediaTime) {
        this.mediaTime = mediaTime;
    }

    @Override
    public MediaTime getMediaTime() {
        return this.mediaTime;
    }

    @Override
    public boolean hasTextAnnotations() {
        return this.annotations.size() > 0;
    }

    @Override
    public boolean hasTextAnnotations(String language) {
        return this.hasTextAnnotations(0.0f, 0.0f, language);
    }

    @Override
    public boolean hasTextAnnotations(float relevance, float confidence) {
        return this.hasTextAnnotations(relevance, confidence, null);
    }

    @Override
    public boolean hasTextAnnotations(float relevance, float confidence, String language) {
        for (TextAnnotation annotation : this.annotations) {
            if (!(annotation.getRelevance() >= relevance) || !(annotation.getConfidence() >= confidence)) continue;
            if (language != null) {
                if (!language.equals(annotation.getLanguage())) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    @Override
    public int getTextAnnotationCount() {
        return this.annotations.size();
    }

    @Override
    public Iterator<TextAnnotation> textAnnotationsByConfidence() {
        TreeSet<TextAnnotation> set = new TreeSet<TextAnnotation>(new Comparator<TextAnnotation>(this){

            @Override
            public int compare(TextAnnotation a1, TextAnnotation a2) {
                if (a1.getConfidence() > a2.getConfidence()) {
                    return 1;
                }
                if (a1.getConfidence() > a2.getConfidence()) {
                    return -1;
                }
                return 0;
            }
        });
        set.addAll(this.annotations);
        return set.iterator();
    }

    @Override
    public Iterator<TextAnnotation> textAnnotationsByRelevance() {
        TreeSet<TextAnnotation> set = new TreeSet<TextAnnotation>(new Comparator<TextAnnotation>(this){

            @Override
            public int compare(TextAnnotation a1, TextAnnotation a2) {
                if (a1.getRelevance() > a2.getRelevance()) {
                    return 1;
                }
                if (a1.getRelevance() > a2.getRelevance()) {
                    return -1;
                }
                return 0;
            }
        });
        set.addAll(this.annotations);
        return set.iterator();
    }

    @Override
    public TextAnnotation createTextAnnotation(float relevance, float confidence, String language) {
        TextAnnotationImpl annotation = new TextAnnotationImpl(relevance, confidence, language);
        this.annotations.add(annotation);
        return annotation;
    }

    @Override
    public Iterator<TextAnnotation> textAnnotations() {
        return this.annotations.iterator();
    }

    @Override
    public SpatioTemporalDecomposition createSpatioTemporalDecomposition(boolean gap, boolean overlap) throws IllegalStateException {
        if (this.spatioTemporalDecomposition != null) {
            throw new IllegalStateException("A spatio temporal decomposition has already been created");
        }
        this.spatioTemporalDecomposition = new SpatioTemporalDecompositionImpl(true, false);
        return this.spatioTemporalDecomposition;
    }

    @Override
    public SpatioTemporalDecomposition getSpatioTemporalDecomposition() {
        return this.spatioTemporalDecomposition;
    }

    @Override
    public boolean hasSpatioTemporalDecomposition() {
        return this.spatioTemporalDecomposition != null;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Segment) {
            return this.id.equals(((Segment)obj).getIdentifier());
        }
        return super.equals(obj);
    }

    public Node toXml(Document document) {
        Element node = document.createElement(this.type.toString());
        node.setAttribute("id", this.id);
        node.appendChild(this.mediaTime.toXml(document));
        if (this.spatioTemporalDecomposition != null) {
            node.appendChild(this.spatioTemporalDecomposition.toXml(document));
        }
        for (TextAnnotation annotation : this.annotations) {
            node.appendChild(annotation.toXml(document));
        }
        return node;
    }
}

